/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.getwayapi.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.getwayapi.dao.GetWayDao;
import com.xdja.pams.getwayapi.entity.SafeClientOnOffRecord;
import com.xdja.pams.scms.entity.Device;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GetWayDaoImpl
implements GetWayDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<Device> getBySn(String sn) {
        return this.baseDao.getListByHQL("from Device where upper(sn)=upper(?) or upper(sn)=upper(?)", new String[]{sn, sn.substring(1)});
    }

    @Override
    public SafeClientOnOffRecord saveSafeClientOnOffRecord(SafeClientOnOffRecord entity) {
        this.baseDao.create(entity);
        return entity;
    }

    public void deleteOffTimeIsNull(String personId) {
        String sql = "delete T_SAFECLIENT_ONOFF_FLOW_RECORD where person_id=? and off_time is null";
        this.baseDao.updateBySql(sql, new String[]{personId});
    }

    @Override
    public SafeClientOnOffRecord getSafeClientOnOffRecordOfOnlineLast(String personId, String sn) {
        return (SafeClientOnOffRecord)this.baseDao.getObjectByHQL("from SafeClientOnOffRecord where personId= ? and (upper(sn)=upper(?) or upper(sn)=upper(?)) and offTime is null  and rownum=1 order by onTime desc", new String[]{personId, sn, sn.substring(1)});
    }

    @Override
    public SafeClientOnOffRecord getSafeClientOnOffRecordOfOnlineLast(String personId, String sn, String ip, String port, String gatewayUrl) {
        return (SafeClientOnOffRecord)this.baseDao.getObjectByHQL("from SafeClientOnOffRecord where personId= ? and (upper(sn)=upper(?) or upper(sn)=upper(?)) and  ip=? and port=? and gatewayUrl = ? and offlineFlag = '0'  and rownum=1 order by onTime desc", new String[]{personId, sn, sn.substring(1), ip, port, gatewayUrl});
    }

    @Override
    public SafeClientOnOffRecord getSafeClientOnOffRecordOfOnlineLast(String sn, String ip, String port, String gatewayUrl) {
        return (SafeClientOnOffRecord)this.baseDao.getObjectByHQL("from SafeClientOnOffRecord where (upper(sn)=upper(?) or upper(sn)=upper(?)) and  ip=? and port=? and gatewayUrl = ? and offlineFlag = '0'  and rownum=1 order by onTime desc", new String[]{sn, sn.substring(1), ip, port, gatewayUrl});
    }

    @Override
    public SafeClientOnOffRecord updateSafeClientOnOffRecord(SafeClientOnOffRecord entity) {
        this.baseDao.update(entity);
        return entity;
    }

    @Override
    public void updateOffLine(List<String> snList, Date reqDate, String gatewayUrl) {
        if (snList.isEmpty()) {
            snList.add(" ");
        }
        String sns0 = "";
        String sns1 = "";
        for (String sn : snList) {
            sns0 = sns0 + "'" + sn + "',";
        }
        sns0 = sns0.substring(0, sns0.length() - 1);
        String sql = "update T_SAFECLIENT_ONOFF_FLOW_RECORD set off_time = sysdate , offline_flag = '1'  where offline_flag = '0' and gateway_url = ?";
        this.baseDao.updateBySql(sql, new Object[]{gatewayUrl});
    }

    @Override
    public void updateOnLineFlow(String uploaded, String downloaded, String ip, String port, String sn, String gatewayUrl) {
        String sql = "update T_SAFECLIENT_ONOFF_FLOW_RECORD set uploaded=?,downloaded = ? where ip = ? and port = ? and (upper(sn)=upper(?) or upper('0'||sn)=upper(?)) and offline_flag = '0'  and gateway_url = ?";
        this.baseDao.updateBySql(sql, new Object[]{uploaded, downloaded, ip, port, sn, sn, gatewayUrl});
    }
}

