/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.jwzs.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.jwzs.bean.FLFGBean;
import com.xdja.pams.jwzs.entity.FLFG;
import com.xdja.pams.jwzs.service.FlfgService;
import com.xdja.pams.logms.service.SystemLogService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class FlfgControler
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private FlfgService flfgService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(FlfgControler.class);
    private static final String STR_PID = "pid";
    private static final String STR_PARENT_ID = "person_id";
    private static final String STR_ID = "id";
    private static final String STR_TITLE = "title";

    @RequestMapping(value={"/jwzs/FlfgControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)STR_PARENT_ID, (Object)this.person.getId());
            map.put((Object)STR_PID, (Object)0);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/jwzs/FlfgControler/list.do"})
    public void list(HttpServletRequest request, HttpServletResponse response, PageParam page, FLFGBean bean) {
        int operateResult = 1;
        try {
            Page p = new Page(page.getPage(), page.getRows());
            List<FLFG> list = this.flfgService.queryList(bean, p);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", p.getTotal());
            map.put("rows", list);
            Util.writeUtf8Text(response, Util.toJsonStr(map));
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jwzs/FlfgControler/getChildForTree.do"})
    public void getChildForTree(HttpServletRequest request, HttpServletResponse response, String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            Util.writeUtf8Text(response, "[{\"text\":\"" + MessageManager.getProMessage(this.message, "jwzs.flfg.controller.flfg") + "\",\"id\":\"0\",\"state\":\"closed\"}]");
            return;
        }
        String jsonlist = "[]";
        try {
            FLFGBean bean = new FLFGBean();
            int i_id = Integer.parseInt(id);
            bean.setPid(i_id);
            List<FLFG> list = this.flfgService.queryList(bean, null);
            ArrayList listmap = new ArrayList();
            for (FLFG flfg : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(STR_ID, flfg.getId());
                map.put("text", flfg.getContent());
                map.put("state", "closed");
                HashMap<String, Integer> attributes = new HashMap<String, Integer>();
                attributes.put(STR_PID, flfg.getPid());
                map.put("attributes", attributes);
                listmap.add(map);
            }
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("\u6cd5\u5f8b\u6cd5\u89c4\u5355\u4f4d\u6570\u83b7\u53d6\u51fa\u9519\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/jwzs/FlfgControler/getById.do"})
    public void getById(int id, HttpServletResponse response) {
        FLFG person = this.flfgService.queryById(id);
        Util.writeUtf8JSON(response, Util.toJsonStr(person));
    }

    @RequestMapping(value={"/jwzs/FlfgControler/forwardUpdatePage.do"})
    public String forwardUpdatePage(int id, ModelMap map) {
        map.put((Object)STR_ID, (Object)id);
        return "jwzs/flfg/default/update";
    }

    @RequestMapping(value={"/jwzs/FlfgControler/forwardAddPage.do"})
    public String forwardAddPage(int pid, ModelMap map) {
        map.put((Object)STR_PID, (Object)pid);
        return "jwzs/flfg/default/add";
    }

    @RequestMapping(value={"/jwzs/FlfgControler/save.do"})
    public void save(FLFG bean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.flfgService.save(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jwzs/FlfgControler/update.do"})
    public void update(FLFG bean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        int operateResult = 0;
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.flfgService.update(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jwzs/FlfgControler/del.do"})
    public void del(int id, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            FLFG bean = this.flfgService.queryById(id);
            this.flfgService.deleteAndChild(Integer.toString(id));
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jwzs/FlfgControler/queryPid.do"})
    public void queryPid(int id, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        boolean operateResult = true;
        try {
            FLFG bean = this.flfgService.queryById(id);
            rtnResult.setData(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = false;
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }
}

