/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.jwzs.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.jwzs.bean.BLLCBean;
import com.xdja.pams.jwzs.dao.BllcDao;
import com.xdja.pams.jwzs.entity.BLLC;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BllcDaoImpl
implements BllcDao {
    @Autowired
    private BaseDao baseDao;
    private static final Logger log = LoggerFactory.getLogger(BllcDaoImpl.class);

    @Override
    public BLLC queryById(int id) {
        return (BLLC)this.baseDao.getObjectById(BLLC.class, Integer.valueOf(id));
    }

    @Override
    public List<BLLC> queryList(BLLCBean bLLCBean, Page page) {
        StringBuilder select = new StringBuilder("from BLLC where 1=1 ");
        ArrayList<String> list = new ArrayList<String>();
        if (bLLCBean != null) {
            if (StringUtils.isNotBlank((CharSequence)bLLCBean.getTitle())) {
                select.append(" and title like ?");
                list.add("%" + bLLCBean.getTitle() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)bLLCBean.getPid())) {
                select.append(" and matterid = ?");
                list.add(bLLCBean.getPid());
            }
        }
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        log.info(selectCount);
        return this.baseDao.getListByHQL(selectCount, select.toString() + "order by xh", values, page);
    }

    @Override
    public List<BLLC> queryByPid(String pid) {
        StringBuilder select = new StringBuilder("from BLLC where 1=1 ");
        ArrayList<String> list = new ArrayList<String>();
        select.append(" and matterid = ?");
        list.add(pid);
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        log.info(selectCount);
        return this.baseDao.getListByHQL(select.toString(), values);
    }

    @Override
    public BLLC save(BLLC bean) {
        this.baseDao.create(bean);
        return bean;
    }

    @Override
    public void update(BLLC bean) {
        this.baseDao.update(bean);
    }

    @Override
    public void delete(BLLC bean) {
        this.baseDao.delete(bean);
    }

    @Override
    public void deleteAndChild(String id) {
        String sql = "delete t_ywblzd  where  id in (select id from t_ywblzd connect by prior id = matterid start with id = ?)";
        this.baseDao.updateBySql(sql, new String[]{id});
    }
}

