/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.logms.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.bean.LogQueryConditionIn;
import com.xdja.pams.logms.dao.LogmsDao;
import com.xdja.pams.logms.entity.UserOperateLog;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class LogmsDaoImpl
implements LogmsDao {
    @Autowired
    private BaseDao dao;

    @Override
    public List<UserOperateLog> getUserOperateLogList(LogQueryConditionIn uol, Page page) {
        String[] opTypes;
        String[] opNames;
        int i;
        List<UserOperateLog> uolList = null;
        if (uol == null || Util.varCheckEmp(uol.getOperateDateFrom()) || Util.varCheckEmp(uol.getOperateDateTo())) {
            return uolList;
        }
        StringBuffer hqlStr = new StringBuffer();
        ArrayList<Object> paramList = new ArrayList<Object>();
        hqlStr.append("from T_LOGMS_USEROPERATELOG uol where 1=1 ");
        if (!Util.varCheckEmp(uol.getControlDepIds())) {
            hqlStr.append(" and uol.ORGANIZATION_ID  in (" + this.getChildDepsSql(uol.getControlDepIds()) + ")");
        }
        if (!Util.varCheckEmp(uol.getUserId())) {
            hqlStr.append(" and uol.USER_ID like ? ");
            paramList.add("%" + uol.getUserId() + "%");
        }
        if (!Util.varCheckEmp(uol.getUserName())) {
            hqlStr.append(" and uol.USER_NAME like ? ");
            paramList.add("%" + uol.getUserName() + "%");
        }
        if (uol.getOrgCode() != null && !uol.getOrgCode().isEmpty()) {
            List<String> orgCodeList = uol.getOrgCode();
            hqlStr.append(" and (");
            for (i = 0; i < orgCodeList.size(); ++i) {
                String orgCode = orgCodeList.get(i);
                if (i != 0) {
                    hqlStr.append(" or ");
                }
                hqlStr.append(" uol.ORGANIZATION_ID = ? ");
                paramList.add(orgCode);
            }
            hqlStr.append(" ) ");
        }
        if (!Util.varCheckEmp(uol.getOrgName())) {
            hqlStr.append(" and uol.ORGANIZATION like ? ");
            paramList.add("%" + uol.getOrgName() + "%");
        }
        if (!Util.varCheckEmp(uol.getOperateDateFrom())) {
            hqlStr.append(" and uol.OPERATE_TIME >= ? ");
            paramList.add(uol.getOperateDateFrom().replaceAll("-", "") + "000000");
        }
        if (!Util.varCheckEmp(uol.getOperateDateTo())) {
            hqlStr.append(" and uol.OPERATE_TIME <= ? ");
            paramList.add(uol.getOperateDateTo().replaceAll("-", "") + "235959");
        }
        if (!Util.varCheckEmp(uol.getOperateName()) && (opNames = uol.getOperateName().split(",")) != null && opNames.length > 0) {
            hqlStr.append(" and ( ");
            for (i = 0; i < opNames.length; ++i) {
                if (i != 0) {
                    hqlStr.append(" or ");
                }
                hqlStr.append(" uol.OPERATE_CODE = ? ");
                paramList.add(opNames[i]);
            }
            hqlStr.append(" ) ");
        }
        if (!Util.varCheckEmp(uol.getOperateType()) && (opTypes = uol.getOperateType().split(",")) != null && opTypes.length > 0) {
            hqlStr.append(" and ( ");
            for (i = 0; i < opTypes.length; ++i) {
                if (i != 0) {
                    hqlStr.append(" or ");
                }
                hqlStr.append(" uol.OPERATE_TYPE = ? ");
                paramList.add(Integer.parseInt(opTypes[i]));
            }
            hqlStr.append(" ) ");
        }
        hqlStr.append("order by uol.OPERATE_TIME desc ");
        String sCount = "select count(*) ";
        String sSelect = "select * ";
        uolList = this.dao.getListBySQL(sCount + hqlStr.toString(), sSelect + hqlStr.toString(), paramList.toArray(), page, UserOperateLog.class);
        return uolList;
    }

    @Override
    public void addUserOperateLog(UserOperateLog uol) {
        this.dao.create(uol);
    }

    private String getChildDepsSql(String controlDeps) {
        String[] depsArray = controlDeps.split(",");
        String depIds = "";
        for (String depId : depsArray) {
            depIds = depIds + "'" + depId + "',";
        }
        depIds = depIds.substring(0, depIds.length() - 1);
        return "select code from t_department connect by prior id = parent_id start with id in (" + depIds + ") ";
    }
}

