/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.logms.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.bean.LogQueryConditionIn;
import com.xdja.pams.logms.dao.LogmsDao;
import com.xdja.pams.logms.entity.UserOperateLog;
import com.xdja.pams.logms.service.LogmsService;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogmsServiceImpl
implements LogmsService {
    @Autowired
    private LogmsDao dao;
    @Autowired
    CommonCodePbService ccps;

    @Override
    public List<UserOperateLog> getUserOperateLogList(LogQueryConditionIn lqcIn, Page page) throws Exception {
        List<UserOperateLog> tmpList = this.dao.getUserOperateLogList(lqcIn, page);
        if (tmpList != null && !tmpList.isEmpty()) {
            for (UserOperateLog uol : tmpList) {
                String operateType = this.ccps.getCodeNameByCode(String.valueOf(uol.getOperateType()), "operateType");
                uol.setOperateTypeStr(operateType);
                String operateResult = this.ccps.getCodeNameByCode(String.valueOf(uol.getOperateResult()), "operateResult");
                uol.setOperateResultStr(operateResult);
                Date operateTime = Util.parseDate(uol.getOperateTime(), "yyyyMMddHHmmss");
                uol.setOperateTimeStr(Util.getDate("yyyy-MM-dd HH:mm:ss", operateTime));
            }
        }
        return tmpList;
    }
}

