/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.logms.service.impl;

import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.dao.LogmsDao;
import com.xdja.pams.logms.entity.UserOperateLog;
import com.xdja.pams.logms.service.SystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemLogServiceImpl
implements SystemLogService {
    private static final Logger log = LoggerFactory.getLogger(SystemLogServiceImpl.class);
    @Autowired
    private LogmsDao dao;
    @Autowired
    private ResourceBundleMessageSource message;

    @Override
    @Transactional
    public void saveLoginLog(String userId, String userName, String orgCode, String orgName, String terminalId, Integer operateResult, String operateCondition, String description, String errorCode) {
        try {
            Integer operateType = new Integer(0);
            boolean rtn = this.checkParam(userId, userName, orgCode, orgName, terminalId, operateType, operateResult);
            if (rtn) {
                this.saveSystemLog(userId, userName, orgCode, orgName, terminalId, operateType, operateResult, operateCondition, description, errorCode, "LOGIN", "");
            }
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58\u767b\u5f55\u65e5\u5fd7\u51fa\u73b0\u4f4d\u7f6e\u5f02\u5e38", (Throwable)e2);
        }
    }

    @Override
    @Transactional
    public void saveOperateLog(String userId, String userName, String orgCode, String orgName, String terminalId, Integer operateType, Integer operateResult, String operateCondition, String description, String errorCode, String operateModelCode, String operateName) {
        try {
            boolean rtn = this.checkParam(userId, userName, orgCode, orgName, terminalId, operateType, operateResult);
            if (rtn) {
                this.saveSystemLog(userId, userName, orgCode, orgName, terminalId, operateType, operateResult, operateCondition, description, errorCode, operateModelCode, operateName);
            }
        }
        catch (Exception e2) {
            log.error("$\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u51fa\u73b0\u4f4d\u7f6e\u5f02\u5e38:" + e2.getMessage(), (Throwable)e2);
        }
    }

    private boolean checkParam(String userId, String userName, String orgCode, String orgName, String terminalId, Integer operateType, Integer operateResult) {
        if (Util.varCheckEmp(userId)) {
            log.error(MessageManager.getProMessage(this.message, "logms.error.saveLoginLog", new String[]{MessageManager.getProMessage(this.message, "logms.page.info.userId")}));
            return false;
        }
        if (Util.varCheckEmp(userName)) {
            log.error(MessageManager.getProMessage(this.message, "logms.error.saveLoginLog", new String[]{MessageManager.getProMessage(this.message, "logms.page.info.userName")}));
            return false;
        }
        if (Util.varCheckEmp(orgCode)) {
            log.error(MessageManager.getProMessage(this.message, "logms.error.saveLoginLog", new String[]{MessageManager.getProMessage(this.message, "logms.page.info.orgCode")}));
            return false;
        }
        if (Util.varCheckEmp(orgName)) {
            log.error(MessageManager.getProMessage(this.message, "logms.error.saveLoginLog", new String[]{MessageManager.getProMessage(this.message, "logms.page.info.orgName")}));
            return false;
        }
        if (Util.varCheckEmp(terminalId)) {
            log.error(MessageManager.getProMessage(this.message, "logms.error.saveLoginLog", new String[]{MessageManager.getProMessage(this.message, "logms.page.info.terminalId")}));
            return false;
        }
        if (operateType == null) {
            log.error(MessageManager.getProMessage(this.message, "logms.error.saveLoginLog", new String[]{MessageManager.getProMessage(this.message, "logms.page.info.operateType")}));
            return false;
        }
        if (operateResult == null) {
            log.error(MessageManager.getProMessage(this.message, "logms.error.saveLoginLog", new String[]{MessageManager.getProMessage(this.message, "logms.page.info.operateResult")}));
            return false;
        }
        return true;
    }

    private void saveSystemLog(String userId, String userName, String orgCode, String orgName, String terminalId, Integer operateType, Integer operateResult, String operateCondition, String description, String errorCode, String operateModelCode, String operateName) {
        UserOperateLog uol = new UserOperateLog();
        uol.setDescription(description);
        uol.setErrorCode(errorCode);
        uol.setUserId(userId);
        uol.setUserName(userName);
        uol.setOperateResult(operateResult);
        uol.setOperateTime(Util.getDate("yyyyMMddHHmmss"));
        uol.setOperateType(operateType);
        uol.setRegId("PAMS");
        uol.setOrgCode(orgCode);
        uol.setOrgName(orgName);
        uol.setTerminalId(terminalId);
        uol.setOperateCondition(operateCondition);
        uol.setOperateModelCode(operateModelCode);
        uol.setOperateName(operateName);
        this.dao.addUserOperateLog(uol);
    }
}

