/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.lsbk.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.lsbk.bean.PersonControlBean;
import com.xdja.pams.lsbk.dao.PersonControlDao;
import com.xdja.pams.lsbk.entity.PersonControl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PersonControlDaoImpl
implements PersonControlDao {
    @Autowired
    private BaseDao baseDao;
    private static final Logger log = LoggerFactory.getLogger(PersonControlDaoImpl.class);

    @Override
    public PersonControl queryById(String id) {
        return (PersonControl)this.baseDao.getObjectById(PersonControl.class, (Serializable)((Object)id));
    }

    @Override
    public List<PersonControl> queryList(PersonControlBean personControlBean, Page page) {
        StringBuilder select = new StringBuilder("from PersonControl where 1=1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (personControlBean != null) {
            if (StringUtils.isNotBlank((CharSequence)personControlBean.getSfzh())) {
                select.append(" and sfzh like ?");
                list.add("%" + personControlBean.getSfzh() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)personControlBean.getKssj())) {
                select.append(" and kssj >= ?");
                try {
                    Date startDate = Util.parseDate(personControlBean.getKssj() + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
                    list.add(startDate);
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)personControlBean.getJssj())) {
                select.append(" and jssj <= ?");
                try {
                    Date endDate = Util.parseDate(personControlBean.getJssj() + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
                    list.add(endDate);
                }
                catch (Exception e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                }
            }
        }
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        log.info(selectCount);
        return this.baseDao.getListByHQL(selectCount, select.toString() + "order by jssj desc", values, page);
    }

    @Override
    public PersonControl save(PersonControl bean) {
        this.baseDao.create(bean);
        return bean;
    }

    @Override
    public void update(PersonControl bean) {
        this.baseDao.update(bean);
    }
}

