/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.report.service.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.report.bean.PersonReportBean;
import com.xdja.pams.report.bean.QueryForm;
import com.xdja.pams.report.bean.ReportDataGrid;
import com.xdja.pams.report.bean.ReportDataGridColumn;
import com.xdja.pams.report.dao.CustomReportDao;
import com.xdja.pams.report.entity.ReplyContent;
import com.xdja.pams.report.entity.RequestContent;
import com.xdja.pams.report.service.CustomReportService;
import com.xdja.pams.report.util.ReplytXmlReader;
import com.xdja.pams.report.util.RequestXmlReader;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRED)
public class CustomReportServiceImpl
implements CustomReportService {
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private CustomReportDao customReportDao;
    @Autowired
    private DepManageService depService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(CustomReportServiceImpl.class);

    @Override
    public ReportDataGrid getReportTittles(QueryForm queryForm) throws Exception {
        int clientWidth;
        ArrayList<ReportDataGridColumn> colums;
        ReportDataGrid dataGrid = new ReportDataGrid();
        String[][] items = this.getReportItems(queryForm.getSearchItemGroups());
        ArrayList<ReportDataGridColumn> columnsList = new ArrayList<ReportDataGridColumn>();
        ArrayList<ReportDataGridColumn> frozenColumnsList = new ArrayList<ReportDataGridColumn>();
        if (items != null && items.length > 0) {
            String searchType;
            colums = new ArrayList<ReportDataGridColumn>();
            clientWidth = 800;
            if (StringUtils.isNotBlank((CharSequence)queryForm.getAppendStr())) {
                clientWidth = Integer.parseInt(queryForm.getAppendStr());
            }
            if ("0".equals(searchType = queryForm.getSearchType())) {
                dataGrid.setPagination(true);
                ReportDataGridColumn depCloum = new ReportDataGridColumn();
                depCloum.setField("DEPNAME");
                depCloum.setTitle(MessageManager.getProMessage(this.message, "report.custom.page.title.depName"));
                depCloum.setWidth("220");
                depCloum.setAlign("left");
                colums.add(depCloum);
                clientWidth -= Integer.parseInt(depCloum.getWidth());
                depCloum = new ReportDataGridColumn();
                depCloum.setField("PERSONDETIL");
                depCloum.setTitle(MessageManager.getProMessage(this.message, "report.custom.page.title.depPerson"));
                depCloum.setWidth("120");
                colums.add(depCloum);
                clientWidth -= Integer.parseInt(depCloum.getWidth());
            } else {
                dataGrid.setPagination(false);
                ReportDataGridColumn userCloum = new ReportDataGridColumn();
                userCloum.setField("NAME");
                userCloum.setTitle(MessageManager.getProMessage(this.message, "report.custom.page.title.personName"));
                colums.add(userCloum);
                clientWidth -= Integer.parseInt(userCloum.getWidth());
                userCloum = new ReportDataGridColumn();
                userCloum.setField("CODE");
                userCloum.setTitle(MessageManager.getProMessage(this.message, "report.custom.page.title.personCode"));
                colums.add(userCloum);
                clientWidth -= Integer.parseInt(userCloum.getWidth());
                userCloum = new ReportDataGridColumn();
                userCloum.setField("MOBILE");
                userCloum.setTitle(MessageManager.getProMessage(this.message, "report.custom.page.title.personMobile"));
                colums.add(userCloum);
                clientWidth -= Integer.parseInt(userCloum.getWidth());
                userCloum = new ReportDataGridColumn();
                userCloum.setField("DEPNAME");
                userCloum.setTitle(MessageManager.getProMessage(this.message, "report.custom.page.title.depName"));
                userCloum.setWidth("120");
                colums.add(userCloum);
                clientWidth -= Integer.parseInt(userCloum.getWidth());
                userCloum = new ReportDataGridColumn();
                userCloum.setField("queryDetail");
                userCloum.setTitle(MessageManager.getProMessage(this.message, "report.custom.page.title.queryDetail"));
                userCloum.setWidth("60");
                colums.add(userCloum);
                clientWidth -= Integer.parseInt(userCloum.getWidth());
            }
            frozenColumnsList.add((ReportDataGridColumn)((Object)colums));
            dataGrid.setFrozenColumns(frozenColumnsList);
            colums = new ArrayList();
            int cloumCount = items.length;
            clientWidth = clientWidth / (cloumCount + 1) > Integer.parseInt(new ReportDataGridColumn().getWidth()) ? clientWidth / (cloumCount + 1) : Integer.parseInt(new ReportDataGridColumn().getWidth());
            for (int i = 0; i < cloumCount; ++i) {
                ReportDataGridColumn cloum = new ReportDataGridColumn();
                cloum.setField(items[i][0]);
                cloum.setTitle(items[i][1]);
                cloum.setWidth("" + clientWidth);
                colums.add(cloum);
            }
        } else {
            throw new Exception(MessageManager.getProMessage(this.message, "report.custom.error.statistics.elementNotExit"));
        }
        ReportDataGridColumn totalCloum = new ReportDataGridColumn();
        totalCloum.setField("TOTAL");
        totalCloum.setTitle(MessageManager.getProMessage(this.message, "report.custom.page.title.totalCount"));
        totalCloum.setWidth("" + clientWidth);
        colums.add(totalCloum);
        columnsList.add((ReportDataGridColumn)((Object)colums));
        dataGrid.setColumns(columnsList);
        return dataGrid;
    }

    @Override
    public String[][] getReportItems(String reportType) throws Exception {
        List<CommonCode> codeSet = this.commonCodePbService.queryByType(reportType);
        String[][] codeValues = new String[][]{};
        if (codeSet == null) {
            return null;
        }
        int size = codeSet.size();
        if (size > 50) {
            throw new Exception("\u7edf\u8ba1\u6307\u6807\u914d\u7f6e\u9519\u8bef\uff1a\u591a\u4f5950\u9879");
        }
        codeValues = new String[size][2];
        for (int i = 0; i < size; ++i) {
            CommonCode code = codeSet.get(i);
            String[] tmp = new String[]{code.getCode().toUpperCase(), code.getName()};
            codeValues[i] = tmp;
        }
        return codeValues;
    }

    @Override
    public List<Map> queryReportDateList(QueryForm queryForm, Page page) throws Exception {
        String searchItemGroups = queryForm.getSearchItemGroups();
        String searchType = queryForm.getSearchType();
        List<Object> rows = new ArrayList();
        String[][] codeValues = this.getReportItems(searchItemGroups);
        if (codeValues == null || codeValues.length < 1) {
            throw new Exception(MessageManager.getProMessage(this.message, "report.custom.error.statistics.elementNotExit"));
        }
        log.info("ReportItems:" + Util.toJsonStr(codeValues));
        rows = "0".equals(searchType) ? this.queryReportDepDateList(queryForm, codeValues, page) : this.queryReportPersonDateList(queryForm, codeValues);
        log.info("rows:" + Util.toJsonStr(rows));
        return rows;
    }

    public List<Map> queryReportDepDateList(QueryForm queryForm, String[][] codeValues, Page page) throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        StringBuffer ywdmStr = new StringBuffer();
        for (String[] str : codeValues) {
            ywdmStr.append(str[0]).append(",");
        }
        String ywdm_czlx = "";
        String jz = "0";
        if (StringUtils.isNotBlank((CharSequence)queryForm.getPolice())) {
            jz = queryForm.getPolice();
        }
        String zwjb = "0";
        if (StringUtils.isNotBlank((CharSequence)queryForm.getPosition())) {
            zwjb = queryForm.getPosition();
        }
        String xjdwbs = "1";
        String depId = "";
        List<Department> depList = this.depService.queryChildDepListByParentId(queryForm, page);
        StringBuffer depListStr = new StringBuffer();
        for (Department dep : depList) {
            depListStr.append(dep.getId()).append(",");
        }
        if (depListStr.indexOf(",") > 0) {
            depId = depListStr.substring(0, depListStr.lastIndexOf(","));
        }
        String operateDateFrom = queryForm.getOperateDateFrom();
        String operateDateTo = queryForm.getOperateDateTo();
        String resString = this.customReportDao.getReportForDepData(depId, operateDateFrom, operateDateTo, ywdmStr.substring(0, ywdmStr.lastIndexOf(",")), ywdm_czlx, jz, zwjb, xjdwbs);
        log.info("resultStr>>" + resString);
        if (resString != null) {
            resString = resString.substring(1, resString.length());
            String[] rowsStr = resString.split(";");
            int cellCount = codeValues.length + 2;
            int[] colSum = new int[cellCount + 1];
            for (String cellsStr : rowsStr) {
                HashMap<String, Object> cells = new HashMap<String, Object>();
                String[] zds = cellsStr.split(",");
                log.info("zds:" + Util.toJsonStr(zds));
                int rowSum = 0;
                cells.put("PERSONDETIL", zds[0]);
                cells.put("DEPNAME", zds[1]);
                for (int i = 2; i < cellCount; ++i) {
                    cells.put(codeValues[i - 2][0], zds[i]);
                    rowSum += Integer.parseInt(zds[i]);
                    int n = i;
                    colSum[n] = colSum[n] + Integer.parseInt(zds[i]);
                }
                cells.put("TOTAL", rowSum);
                int n = cellCount;
                colSum[n] = colSum[n] + rowSum;
                rows.add(cells);
            }
            HashMap<String, Object> cells = new HashMap<String, Object>();
            cells.put("DEPNAME", MessageManager.getProMessage(this.message, "report.custom.page.title.totalCount"));
            cells.put("PERSONDETIL", depId);
            for (int i = 2; i < cellCount; ++i) {
                cells.put(codeValues[i - 2][0], colSum[i]);
            }
            cells.put("TOTAL", colSum[cellCount]);
            rows.add(cells);
        }
        return rows;
    }

    public List<Map> queryReportPersonDateList(QueryForm queryForm, String[][] codeValues) throws Exception {
        String operateDateFrom = queryForm.getOperateDateFrom();
        String operateDateTo = queryForm.getOperateDateTo();
        String ctlDepStr = queryForm.getCtlDepStr();
        String controlPoliceStr = queryForm.getControlPolices();
        StringBuffer ywdmTemp = new StringBuffer();
        StringBuffer sqlZj = new StringBuffer();
        StringBuffer ywdmResult = new StringBuffer();
        StringBuffer sqlCondition = new StringBuffer("");
        for (String[] str : codeValues) {
            ywdmTemp.append(" sum(decode(upper(c_ywdm), '").append(str[0]).append("', n_zs, 0)) ").append(str[0]).append(",");
            ywdmResult.append(" nvl(").append(str[0]).append(",0) ").append(str[0]).append(",");
            sqlZj.append("sum(decode(upper(c_ywdm), '").append(str[0]).append("', n_zs, 0))+");
        }
        if ("1".equals(queryForm.getSearchType())) {
            sqlCondition.append(" and b.code='").append(queryForm.getSearchValue()).append("'");
        } else if ("2".equals(queryForm.getSearchType())) {
            sqlCondition.append(" and b.name='").append(queryForm.getSearchValue()).append("'");
        }
        StringBuffer sqlBuilder = new StringBuffer();
        sqlBuilder.append("select b.name ").append("NAME").append(",b.code ").append("CODE").append(",(select name from t_department where id=b.dep_id) ").append("DEPNAME").append(",b.mobile ").append("MOBILE").append(",");
        sqlBuilder.append(ywdmResult).append("nvl(total,0) ").append("TOTAL").append(" from (select c_jh,").append(ywdmTemp);
        sqlBuilder.append(sqlZj.substring(0, sqlZj.lastIndexOf(","))).append("))").append("TOTAL");
        sqlBuilder.append(" from t_gprs_back_ywtj_day ");
        sqlBuilder.append(" where c_rq>='").append(operateDateFrom.replace("-", "")).append("'");
        sqlBuilder.append(" and c_rq<='").append(operateDateTo.replace("-", "")).append("'");
        sqlBuilder.append(" group by c_jh) a,(");
        sqlBuilder.append(this.prepareSql(ctlDepStr, controlPoliceStr));
        sqlBuilder.append(") b where a.c_jh(+)=b.code " + sqlCondition);
        log.info("\u81ea\u5b9a\u4e49\u56fa\u5b9a\u62a5\u8868\u6309\u4e2a\u4eba\u7edf\u8ba1\u6267\u884c\u7684sql:" + sqlBuilder.toString());
        List resultRows = this.customReportDao.getReportForPersonalData(sqlBuilder.toString());
        return resultRows;
    }

    private String prepareSql(String ctlDepStr, String controlPoliceStr) {
        String[] depIdStrings = ctlDepStr.split(",");
        StringBuffer depIdStr = new StringBuffer("select * from t_person");
        depIdStr.append(" where dep_id in ( select id from t_department connect by prior  id= parent_id start with (");
        for (int i = 0; i < depIdStrings.length; ++i) {
            if (i == 0) {
                depIdStr.append(" id='").append(depIdStrings[i]).append("'");
                continue;
            }
            depIdStr.append(" or id='").append(depIdStrings[i]).append("'");
        }
        depIdStr.append(")) ");
        StringBuffer sb = new StringBuffer();
        if (!"all".equals(controlPoliceStr)) {
            String[] policeIdStrings = controlPoliceStr.split(",");
            if (policeIdStrings != null && policeIdStrings.length > 0) {
                depIdStr.append(" and position in ( ");
                for (String tmp : policeIdStrings) {
                    sb.append(tmp).append(",");
                }
                depIdStr.append(sb.substring(0, sb.lastIndexOf(",")));
                depIdStr.append(")");
            } else {
                depIdStr.append(" and position = 'all' ");
            }
        }
        return depIdStr.toString();
    }

    @Override
    public RequestContent queryRequestContent(String id, String path) {
        String xml = this.customReportDao.getClobOfReqXml(id);
        RequestXmlReader RequestXmlReader2 = new RequestXmlReader(path, id);
        return RequestXmlReader2.getReqContent(xml);
    }

    @Override
    public ReplyContent queryReplyContent(String id) {
        String xml = this.customReportDao.getClobOfReplyXml(id);
        ReplytXmlReader ReplytXmlReader2 = new ReplytXmlReader(xml);
        ReplyContent replyContent = null;
        try {
            replyContent = ReplytXmlReader2.getReplyContent();
        }
        catch (DocumentException e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return replyContent;
    }

    @Override
    public List<PersonReportBean> getGprsBackList(QueryForm queryForm, Page page) {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = Util.parseDate(queryForm.getOperateDateFrom() + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
            endDate = Util.parseDate(queryForm.getOperateDateTo() + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        StringBuilder selectSql = new StringBuilder("select n_id,c_jh, c_sjh, c_dwbm,c_ywlx, d_rq, c_ip from t_gprs_back  t where 1=1 ");
        StringBuilder countSql = new StringBuilder("select count(*) from t_gprs_back  t where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)queryForm.getOperateDateFrom())) {
            selectSql.append(" and t.d_rq  >= ? ");
            countSql.append(" and t.d_rq  >= ? ");
            paramList.add(startDate);
        }
        if (StringUtils.isNotBlank((CharSequence)queryForm.getOperateDateTo())) {
            selectSql.append(" and t.d_rq  <= ? ");
            countSql.append(" and t.d_rq  <= ? ");
            paramList.add(endDate);
        }
        if (StringUtils.isNotBlank((CharSequence)queryForm.getCode())) {
            selectSql.append(" and t.c_jh  =?");
            countSql.append(" and t.c_jh  =?");
            paramList.add(queryForm.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryForm.getName())) {
            selectSql.append(" and t.c_jh  in (select p.code from t_person p where p.name=?)");
            countSql.append(" and t.c_jh  in (select p.code from t_person p where p.name=?)");
            paramList.add(queryForm.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryForm.getPolice())) {
            selectSql.append(" and t.c_jh  in (select code from t_person tp where tp.police=?)");
            countSql.append(" and t.c_jh  in (select code from t_person tp where tp.police=?)");
            paramList.add(queryForm.getPolice());
        }
        if (StringUtils.isNotBlank((CharSequence)queryForm.getPosition())) {
            selectSql.append(" and t.c_jh  in (select code from t_person tp where tp.position=?)");
            countSql.append(" and t.c_jh  in (select code from t_person tp where tp.position=?)");
            paramList.add(queryForm.getPosition());
        }
        if (StringUtils.isNotBlank((CharSequence)queryForm.getDepId())) {
            selectSql.append(" and t.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
            countSql.append(" and  t.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
            paramList.add(queryForm.getDepId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryForm.getSearchItemGroups())) {
            selectSql.append(" and upper(t.c_ywlx) in (" + this.getYwdmForSql(queryForm.getSearchItemGroups()) + ")");
            countSql.append(" and  upper(t.c_ywlx) in (" + this.getYwdmForSql(queryForm.getSearchItemGroups()) + ")");
        }
        return this.customReportDao.getGprsBackInfo(countSql.toString(), selectSql.toString(), paramList.toArray(), page);
    }

    @Override
    public String getYwdmForSql(String ywdmTypeId) {
        String ywdms = "";
        try {
            String[][] ywdmArray = this.getReportItems(ywdmTypeId);
            for (int i = 0; i < ywdmArray.length; ++i) {
                ywdms = ywdms + "'" + ywdmArray[i][0] + "',";
            }
            ywdms = ywdms.substring(0, ywdms.length() - 1);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return ywdms;
    }
}

