/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.report.util;

import com.xdja.pams.report.entity.LoginInfo;
import com.xdja.pams.report.entity.PageInfo;
import com.xdja.pams.report.entity.RelatedQuery;
import com.xdja.pams.report.entity.ReplyContent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ReplytXmlReader {
    private String strXml;

    public ReplytXmlReader(String strXml) {
        this.strXml = strXml;
    }

    private Element getRootElemnet() throws DocumentException {
        Document document = DocumentHelper.parseText((String)this.strXml);
        Element rootElement = document.getRootElement();
        return rootElement;
    }

    public ReplyContent getReplyContent() throws DocumentException {
        ReplyContent replyContent = new ReplyContent();
        if (this.strXml.startsWith("-9")) {
            replyContent.setType("\u9000\u51fa\u64cd\u4f5c\u56de\u590d");
            replyContent.setResultFlag("success");
        } else if (this.strXml.startsWith("0")) {
            replyContent.setType("\u91c7\u96c6\u64cd\u4f5c\u56de\u590d");
            replyContent.setResultFlag("success");
        } else if (this.strXml.startsWith("-1")) {
            replyContent.setType("\u91c7\u96c6\u64cd\u4f5c\u56de\u590d");
            replyContent.setResultFlag("error");
            replyContent.setErrorReason(StringUtils.substring((String)this.strXml, (int)2));
        } else if (this.strXml.startsWith("11") || this.strXml.startsWith("0x00000000")) {
            replyContent.setType("\u4fee\u6539\u5bc6\u7801\u64cd\u4f5c\u56de\u590d");
            replyContent.setResultFlag("success");
        } else if (this.strXml.startsWith("0x13014023")) {
            replyContent.setType("\u4fee\u6539\u5bc6\u7801\u64cd\u4f5c\u56de\u590d");
            replyContent.setResultFlag("error");
        } else if (this.strXml.startsWith("<?xml")) {
            Element rootElement = this.getRootElemnet();
            String title = this.getTitle(rootElement);
            if (StringUtils.isNotBlank((CharSequence)title)) {
                if (title.equals("0")) {
                    replyContent.setType("\u91c7\u96c6\u64cd\u4f5c\u56de\u590d");
                    replyContent.setResultFlag("success");
                } else if (title.equals("-1")) {
                    replyContent.setType("\u91c7\u96c6\u64cd\u4f5c\u56de\u590d");
                    replyContent.setResultFlag("error");
                    replyContent.setErrorReason(this.getResult(rootElement));
                } else {
                    replyContent.setType("\u67e5\u8be2\u64cd\u4f5c\u56de\u590d");
                    replyContent.setResultFlag("success");
                    replyContent.setDataList(this.getData(rootElement));
                    replyContent.setPageInfo(this.getPage(rootElement));
                    replyContent.setRelatedQuery(this.getRelation(rootElement));
                }
            } else {
                replyContent.setType("\u767b\u5f55\u64cd\u4f5c\u56de\u590d");
                replyContent.setLoginInfo(this.getLoginInfo(rootElement));
            }
        }
        return replyContent;
    }

    private LoginInfo getLoginInfo(Element rootElement) {
        String strJH = "";
        String strDWBM = "";
        String strSJH = "";
        String strDLSJ = "";
        Element jhElement = rootElement.element("PoliceNo");
        Element dwbmElement = rootElement.element("UnitsCoding");
        Element sjhElement = rootElement.element("MobileNo");
        Element dlsjElement = rootElement.element("DateTime");
        if (null != jhElement) {
            strJH = jhElement.getText();
        }
        if (null != dwbmElement) {
            strDWBM = dwbmElement.getText();
        }
        if (null != sjhElement) {
            strSJH = sjhElement.getText();
        }
        if (null != dlsjElement) {
            strDLSJ = dlsjElement.getText();
        }
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setCode(strJH);
        loginInfo.setDepCode(strDWBM);
        loginInfo.setLoginTime(strDLSJ);
        loginInfo.setMobile(strSJH);
        return loginInfo;
    }

    private String getTitle(Element rootElement) {
        String strTitle = "";
        Element typeElement = rootElement.element("Type");
        if (null != typeElement) {
            strTitle = typeElement.getText();
        }
        return strTitle;
    }

    private String getResult(Element rootElement) {
        String strResult = "";
        Element typeElement = rootElement.element("Result");
        if (null != typeElement) {
            strResult = typeElement.getText();
        }
        return strResult;
    }

    private Element getItems(Element rootElement) {
        Element items = rootElement.element("Items");
        return items;
    }

    private List<String[]> getData(Element rootElement) {
        Element values = this.getItems(rootElement).element("Values");
        List rowList = values.elements();
        ArrayList<String[]> dataArrayList = new ArrayList<String[]>();
        if (rowList.size() > 2) {
            for (int i = 1; i < rowList.size(); ++i) {
                Element rowElement = (Element)rowList.get(i);
                List dataList = rowElement.elements();
                String[] dataArray = new String[dataList.size()];
                for (int j = 0; j < dataList.size(); ++j) {
                    Element dataElement = (Element)dataList.get(j);
                    dataArray[j] = dataElement.getText();
                }
                dataArrayList.add(dataArray);
            }
        }
        return dataArrayList;
    }

    private List<RelatedQuery> getRelation(Element rootElement) {
        List listRelNode;
        int intListRelNode;
        Element relationElement = this.getItems(rootElement).element("Relation");
        ArrayList<RelatedQuery> relatedlist = new ArrayList<RelatedQuery>();
        if (null != relationElement && (intListRelNode = (listRelNode = relationElement.elements()).size()) > 0) {
            for (int i = 0; i < intListRelNode; ++i) {
                Element relNode = (Element)listRelNode.get(i);
                Element sortElement = relNode.element("Sort");
                Element nameElement = relNode.element("Name");
                Element conditionElement = relNode.element("Condition");
                Element dbSourceElement = relNode.element("DbSource");
                Element alertElement = relNode.element("Alert");
                RelatedQuery relatedQuery = new RelatedQuery();
                relatedQuery.setNodeNumber(i + "");
                if (null != sortElement) {
                    relatedQuery.setRequestType(sortElement.getText());
                }
                if (null != nameElement) {
                    relatedQuery.setRelateName(nameElement.getText());
                }
                if (null != conditionElement) {
                    relatedQuery.setRelateContion(conditionElement.getText());
                }
                if (null != dbSourceElement) {
                    relatedQuery.setDataSource(dbSourceElement.getText());
                }
                if (null != alertElement) {
                    relatedQuery.setAlertInfo(alertElement.getText());
                }
                relatedlist.add(relatedQuery);
            }
        }
        return relatedlist;
    }

    private PageInfo getPage(Element rootElement) {
        PageInfo pageInfo = new PageInfo();
        Element pageElement = this.getItems(rootElement).element("Page");
        if (null != pageElement) {
            Element sizeElement = pageElement.element("Size");
            Element totalLenElement = pageElement.element("TotalLen");
            Element currentLenElement = pageElement.element("CurrentLen");
            Element totalPageElement = pageElement.element("TotalPage");
            Element beginNoElement = pageElement.element("BeginNo");
            Element sourceConditionElement = pageElement.element("SourceCondition");
            Element sourceDbSourceElement = pageElement.element("SourceDbSource");
            if (null != sizeElement) {
                pageInfo.setPageCounts(sizeElement.getText());
            }
            if (null != totalLenElement) {
                pageInfo.setAllCounts(totalLenElement.getText());
            }
            if (null != currentLenElement) {
                pageInfo.setReturnCounts(currentLenElement.getText());
            }
            if (null != totalPageElement) {
                pageInfo.setAllPages(totalPageElement.getText());
            }
            if (null != beginNoElement) {
                pageInfo.setBeginNumber(beginNoElement.getText());
            }
            if (null != sourceConditionElement) {
                pageInfo.setQueryContion(sourceConditionElement.getText());
            }
            if (null != sourceDbSourceElement) {
                pageInfo.setDataSourceId(sourceDbSourceElement.getText());
            }
        }
        return pageInfo;
    }

    public static void main(String[] args) throws DocumentException {
        String strXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><RequestAgent><Type>zhcx_ryzc</Type><Items><Values><Row><Data>c_sfzh</Data><Data>c_xm</Data><Data>c_xb</Data><Data>c_sjly</Data><Data>c_rybh</Data></Row><Row><Data>\u8eab\u4efd\u8bc1\u53f7</Data><Data>\u59d3\u540d</Data><Data>\u6027\u522b</Data><Data>\u6570\u636e\u6765\u6e90</Data><Data>\u4eba\u5458\u7f16\u53f7</Data></Row><Row><Data IsCode=\"0\" CodeValue=\"\">410303194701140515</Data><Data IsCode=\"0\" CodeValue=\"\">\u8d3e\u4e09\u56ed</Data><Data IsCode=\"0\" CodeValue=\"\">1</Data><Data IsCode=\"0\" CodeValue=\"\">A01</Data><Data IsCode=\"0\" CodeValue=\"\">690063</Data></Row></Values><Relation><RelNode><Sort>dxcx_ryzc</Sort><Name>\u4eba\u5458\u7efc\u67e5</Name><Condition><![CDATA[c_sfzh='410303194701140515']]></Condition><DbSource>1</DbSource></RelNode></Relation><Page><Size>5</Size><TotalLen>1</TotalLen><CurrentLen>1</CurrentLen><BeginNo>1</BeginNo><TotalPage>1</TotalPage><SourceCondition><![CDATA[c_sfzh='410303194701140515']]></SourceCondition><SourceDbSource>1</SourceDbSource></Page></Items></RequestAgent>";
        ReplytXmlReader hrnrReader = new ReplytXmlReader(strXml);
        Element rootElement = hrnrReader.getRootElemnet();
        String strTitle = hrnrReader.getTitle(rootElement);
        System.out.println(strTitle);
        ReplyContent replyContent = hrnrReader.getReplyContent();
        for (String[] temp : replyContent.getDataList()) {
            for (String data : temp) {
                System.out.println(data);
            }
        }
        PageInfo pageInfo = replyContent.getPageInfo();
        System.out.println(pageInfo.getAllCounts());
    }
}

