/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.control;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.FtpUpload;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.rptms.bean.QueryReportTimerBean;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.bean.ViewReportConditionBean;
import com.xdja.pams.rptms.entity.FtpInfo;
import com.xdja.pams.rptms.entity.ReportTimer;
import com.xdja.pams.rptms.entity.ReportTimerCondition;
import com.xdja.pams.rptms.service.ReportManagerService;
import com.xdja.pams.rptms.service.TimerReportService;
import com.xdja.pams.rptms.service.ViewReportService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class TimerReportControler
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private TimerReportService timerReportService;
    @Autowired
    private ReportManagerService reportManagerService;
    @Autowired
    private ViewReportService viewReportService;
    @Autowired
    private DepManageService depService;
    private static final Logger log = LoggerFactory.getLogger(TimerReportControler.class);
    private static final String TEXT_STYLE = "width:400px";

    @RequestMapping(value={"/rptms/TimerReportControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error("#\u5b9a\u65f6\u62a5\u8868\u9996\u9875\u5c55\u793a\u5f02\u5e38", (Throwable)e2);
            map.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage()));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/rptms/TimerReportControler/queryTimerReports.do"})
    public void queryTimerReports(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryReportTimerBean queryReportTimerBean, PageParam pageParam) {
        int operateResult = 1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(pageParam.getPage()), Integer.parseInt(pageParam.getRows()));
            queryReportTimerBean.setState("");
            List<QueryReportTimerBean> queryReportTimerBeanList = this.timerReportService.queryTimerReportsList(queryReportTimerBean, page);
            result.put("total", page.getTotal());
            result.put("rows", queryReportTimerBeanList);
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("#\u67e5\u8be2\u5b9a\u65f6\u62a5\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/rptms/TimerReportControler/toAdd.do"})
    public String toAddTimerReport(ModelMap map, PageParam page, String reportId, HttpServletRequest request) {
        log.debug("##########\u5bfc\u5411\u6dfb\u52a0\u5b9a\u65f6\u62a5\u8868\u9875\u9762<\u5f00\u59cb>##########");
        try {
            List<ViewReportConditionBean> viewReportConditionBeanList = this.viewReportService.getReportConditionList(reportId);
            Map paramMap = request.getParameterMap();
            ArrayList<ViewReportConditionBean> newViewReportConditionBeanList = new ArrayList<ViewReportConditionBean>();
            for (ViewReportConditionBean viewReportConditionBean : viewReportConditionBeanList) {
                String defualtValue = "";
                Object[] paramValue = (String[])paramMap.get(viewReportConditionBean.getIdAndNameAttributeValue());
                if (paramValue != null) {
                    String conditionType = viewReportConditionBean.getType();
                    if ("3".equals(conditionType)) {
                        String strArray = Arrays.toString(paramValue).replaceAll(" ", "");
                        defualtValue = strArray.substring(1, strArray.length() - 1);
                    } else if ("4".equals(conditionType)) {
                        viewReportConditionBean.setType("6");
                        viewReportConditionBean.setStyle(TEXT_STYLE);
                        request.getSession().setAttribute(viewReportConditionBean.getIdAndNameAttributeValue(), (Object)"datebox");
                    } else {
                        defualtValue = new String(((String)paramValue[0]).getBytes("iso8859-1"), "utf-8");
                    }
                }
                viewReportConditionBean.setDefaultValue(defualtValue);
                viewReportConditionBean.setName(this.getLongName(viewReportConditionBean.getName()));
                viewReportConditionBean.setIdAndNameAttributeValue(viewReportConditionBean.getIdAndNameAttributeValue() + "_timer");
                log.debug("#<\u62a5\u8868\u53c2\u6570:" + Util.toJsonStr(viewReportConditionBean));
                newViewReportConditionBeanList.add(viewReportConditionBean);
            }
            map.put((Object)"conditionList", newViewReportConditionBeanList);
            ReportBean report = this.reportManagerService.getReportById(reportId);
            this.setOperator(request);
            map.put((Object)"reportId", (Object)reportId);
            map.put((Object)"reportName", (Object)report.getReportName());
        }
        catch (Exception e2) {
            log.error("#\u8f6c\u5411\u5b9a\u65f6\u62a5\u8868\u6dfb\u52a0\u9875\u9762\u5f02\u5e38", (Throwable)e2);
        }
        log.debug("##########\u5bfc\u5411\u6dfb\u52a0\u5b9a\u65f6\u62a5\u8868\u9875\u9762<\u7ed3\u675f>##########");
        return page.getSendUrl();
    }

    @RequestMapping(value={"/rptms/TimerReportControler/add.do"})
    public void addTimerReport(ReportTimer reportTimer, HttpServletRequest request, HttpServletResponse response) {
        log.debug("##########\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        try {
            String save_location = this.scps.getValueByCode("timerReportLocation");
            log.info("#\u62a5\u8868\u5b58\u653e\u8def\u5f84:" + save_location);
            reportTimer.setSaveLocation(save_location);
            reportTimer.setState("1");
            reportTimer.setStartTime(Util.parseDate(reportTimer.getStrStartTime(), "yyyy-MM-dd HH:mm:ss"));
            reportTimer.setCreatorId(this.person.getId());
            reportTimer.getFtpInfo().setCreatorId(this.person.getId());
            if ("2".equals(reportTimer.getHandleType())) {
                FtpInfo ftpInfo = reportTimer.getFtpInfo();
                FtpUpload ftpUpload = new FtpUpload(ftpInfo.getUrl(), ftpInfo.getUsername(), ftpInfo.getPassword(), ftpInfo.getPort(), ftpInfo.getPath());
                ftpUpload.checkFtpInfo();
            }
            String timerReportId = this.timerReportService.addTimerReport(reportTimer);
            QueryReportTimerBean queryReportTimerBean = new QueryReportTimerBean();
            queryReportTimerBean.setId(timerReportId);
            this.timerReportService.startTimerReports(queryReportTimerBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error("#\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
        log.debug("##########\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1<\u7ed3\u675f>##########");
    }

    @RequestMapping(value={"/rptms/TimerReportControler/toEdit.do"})
    public String toEditReportTimer(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, PageParam page) {
        log.info("##########\u8f6c\u5411\u7f16\u8f91\u9875\u9762<\u5f00\u59cb>##########");
        try {
            ArrayList<ViewReportConditionBean> viewReportConditionBeanList = new ArrayList<ViewReportConditionBean>();
            ReportTimer reportTimer = this.timerReportService.queryTimerReportById(id);
            reportTimer.setStrStartTime(Util.getDate("yyyy-MM-dd HH:mm:ss", reportTimer.getStartTime()));
            List<ReportTimerCondition> reportTimerConditionList = reportTimer.getReportTimerConditionList();
            List<ViewReportConditionBean> oldViewReportConditionBeanList = this.viewReportService.getReportConditionList(reportTimer.getReport().getReportId());
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            if (reportTimerConditionList != null && reportTimerConditionList.size() > 0) {
                for (ReportTimerCondition reportTimerCondition : reportTimerConditionList) {
                    String value = reportTimerCondition.getConditionValue();
                    if ("NULL".equals(value)) {
                        value = "";
                    }
                    conditionMap.put(reportTimerCondition.getConditionIdAndName(), value);
                }
            }
            for (ViewReportConditionBean viewReportConditionBean : oldViewReportConditionBeanList) {
                Department dep;
                String defaultValue = viewReportConditionBean.getDefaultValue();
                if (conditionMap.containsKey(viewReportConditionBean.getIdAndNameAttributeValue())) {
                    defaultValue = (String)conditionMap.get(viewReportConditionBean.getIdAndNameAttributeValue());
                }
                viewReportConditionBean.setDefaultValue(defaultValue);
                if ("4".equals(viewReportConditionBean.getType())) {
                    viewReportConditionBean.setType("6");
                    viewReportConditionBean.setStyle(TEXT_STYLE);
                    request.getSession().setAttribute(viewReportConditionBean.getIdAndNameAttributeValue(), (Object)"datebox");
                }
                viewReportConditionBean.setName(this.getLongName(viewReportConditionBean.getName()));
                if ("7".equals(viewReportConditionBean.getType()) && viewReportConditionBean.getDefaultValue() != null && (dep = this.depService.queryDepById(viewReportConditionBean.getDefaultValue())) != null) {
                    viewReportConditionBean.setDepNameValue(dep.getName());
                }
                viewReportConditionBeanList.add(viewReportConditionBean);
            }
            if (reportTimer.getFtpInfo() == null) {
                reportTimer.setFtpInfo(new FtpInfo());
            }
            map.put((Object)"reportTimer", (Object)reportTimer);
            log.info("#<\u62a5\u8868\u53c2\u6570\u4fe1\u606f:" + Util.toJsonStr(viewReportConditionBeanList));
            map.put((Object)"conditionList", viewReportConditionBeanList);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8f6c\u5411\u7f16\u8f91\u5b9a\u65f6\u62a5\u8868\u5f02\u5e38", (Throwable)e2);
        }
        log.info("##########\u8f6c\u5411\u7f16\u8f91\u9875\u9762<\u7ed3\u675f>##########");
        return page.getSendUrl();
    }

    private String getLongName(String name) {
        int STANDARD_LENGTH = 5;
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        for (int i = 0; i < STANDARD_LENGTH - name.length(); ++i) {
            name = "&nbsp;&nbsp;" + name;
        }
        return name;
    }

    @RequestMapping(value={"/rptms/TimerReportControler/update.do"})
    public void updateReportTimer(HttpServletRequest request, HttpServletResponse response, ReportTimer reportTimer) {
        log.info("##########\u5b9a\u65f6\u62a5\u8868\u4fee\u6539<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        try {
            String reportTimerId = reportTimer.getId();
            if ("2".equals(reportTimer.getHandleType())) {
                reportTimer.getFtpInfo().setCreatorId(this.person.getId());
                FtpInfo ftpInfo = reportTimer.getFtpInfo();
                FtpUpload ftpUpload = new FtpUpload(ftpInfo.getUrl(), ftpInfo.getUsername(), ftpInfo.getPassword(), ftpInfo.getPort(), ftpInfo.getPath());
                ftpUpload.checkFtpInfo();
            }
            this.timerReportService.updateTimerReport(reportTimer);
            try {
                QueryReportTimerBean queryReportTimerBean = new QueryReportTimerBean();
                queryReportTimerBean.setId(reportTimerId);
                this.timerReportService.startTimerReports(queryReportTimerBean);
            }
            catch (Exception e2) {
                log.error("$\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8\u5931\u8d25", (Throwable)e2);
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.timerReport.error.startError2"));
            }
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e3) {
            log.error("#\u4fee\u6539\u5b9a\u65f6\u62a5\u8868\u5f02\u5e38", (Throwable)e3);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e3.getMessage());
        }
        log.info("##########\u5b9a\u65f6\u62a5\u8868\u4fee\u6539<\u7ed3\u675f>##########");
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/rptms/TimerReportControler/delete.do"})
    public void deleteTimerReport(HttpServletRequest request, HttpServletResponse response, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            ReportTimer reportTimer = this.timerReportService.queryTimerReportById(id);
            this.timerReportService.deleteReportTimer(reportTimer);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/rptms/TimerReportControler/startOrStop.do"})
    public void startOrStop(HttpServletRequest request, HttpServletResponse response, String id, String state) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.timerReportService.changeState(id, state);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }
}

