/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.rptms.bean.ChartParam;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.bean.ViewReportConditionBean;
import com.xdja.pams.rptms.entity.ReportChart;
import com.xdja.pams.rptms.service.ReportChartService;
import com.xdja.pams.rptms.service.ReportManagerService;
import com.xdja.pams.rptms.service.ReportResultService;
import com.xdja.pams.rptms.service.ReportTemplateManageService;
import com.xdja.pams.rptms.service.ViewReportService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class ViewReportControler
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private ReportTemplateManageService reportTemplateManageService;
    @Autowired
    private ViewReportService viewReportService;
    @Autowired
    private ReportManagerService reportManagerService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private ReportChartService reportChartService;
    private static final Logger log = LoggerFactory.getLogger(ViewReportControler.class);

    @RequestMapping(value={"/rptms/ViewReportControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam pageParam, String reportId) {
        log.debug("##########\u62a5\u8868\u5c55\u793a\u9996\u9875\u9762<\u5f00\u59cb>##########");
        log.info("#>reportId\uff1a" + reportId);
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, pageParam.getMenuId(), pageParam.getParentId());
            sendUrl = this.menuLinkPage;
            List<ViewReportConditionBean> viewReportConditionBeanList = this.viewReportService.getReportConditionList(reportId);
            map.put((Object)"conditionList", viewReportConditionBeanList);
            log.info("#<\u62a5\u8868\u6761\u4ef6\u5217\u8868\uff1a" + Util.toJsonStr(viewReportConditionBeanList));
            map.put((Object)"reportId", (Object)reportId);
            ReportBean reportBean = this.reportManagerService.getReportById(reportId);
            map.put((Object)"report", (Object)reportBean);
        }
        catch (Exception e2) {
            log.error("#\u62a5\u8868\u5c55\u793a\u9996\u9875\u9762\u5c55\u793a\u5931\u8d25", (Throwable)e2);
            map.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage()));
        }
        log.debug("##########\u62a5\u8868\u5c55\u793a\u9996\u9875\u9762<\u7ed3\u675f>##########");
        return sendUrl;
    }

    @RequestMapping(value={"/rptms/ViewReportControler/report.do"})
    public String report(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap madelMap, String reportId, String showChart, String chartType, ChartParam chartParam) {
        log.debug("##########\u62a5\u8868\u5c55\u793a<\u5f00\u59cb>##########");
        log.info("#>\uff1a" + reportId);
        madelMap.put((Object)"time", (Object)new Date().getTime());
        try {
            ReportBean reportBean = this.reportManagerService.getReportById(reportId);
            Page page = null;
            if ("1".equals(reportBean.getFlagPagination())) {
                page = new Page(pageParam.getPage(), pageParam.getRows());
            }
            Map<String, Object> allParams = this.getRequestParams(request);
            log.info("#\u62a5\u8868\u53c2\u6570\u4fe1\u606f>" + allParams);
            ArrayList<Map<String, Object>> returnObject = this.viewReportService.getReportData(reportBean, allParams, page);
            if ("chart".equals(showChart)) {
                ReportChart reportChart = reportBean.getReportChart();
                if ("2".equals(chartType)) {
                    reportChart.setChartType("2");
                }
                String filename = this.reportChartService.createReportChart(reportChart, returnObject, response, chartParam);
                request.setAttribute("filename", (Object)filename);
                request.setAttribute("map", (Object)chartParam.getMap());
                return "rptms/viewreport/default/chart";
            }
            if ("Jasper".equals(reportBean.getReportType())) {
                log.info("#Jasper\u62a5\u8868\u5c55\u793a>>>");
                String jrxmlPath = null;
                if (reportBean.getReportFileId() != null) {
                    jrxmlPath = this.reportTemplateManageService.queryReportTemplateById(reportBean.getReportFileId()).getFileAllPath();
                }
                JasperReport jasperReport = JasperCompileManager.compileReport(jrxmlPath);
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, allParams, (JRDataSource)new JRBeanCollectionDataSource(returnObject));
                response.setContentType("text/html");
                PrintWriter printWriter = response.getWriter();
                JRHtmlExporter exporter = new JRHtmlExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)printWriter);
                request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)("imageServlet?time=" + System.currentTimeMillis() + "&image="));
                exporter.exportReport();
                printWriter.close();
                log.info("#Jasper\u62a5\u8868\u5c55\u793a\u7ed3\u675f<<<");
                return null;
            }
            log.info("#\u67e5\u8be2\u62a5\u8868\u5c55\u793a>>>");
            ArrayList<Map<String, Object>> arrayList = returnObject = returnObject == null ? new ArrayList<Map<String, Object>>() : returnObject;
            if (!returnObject.isEmpty()) {
                String[] stringArray;
                String[] columncode;
                HashMap<String, String> map = new HashMap<String, String>();
                if (StringUtils.isNotBlank((CharSequence)reportBean.getColumnCode()) && StringUtils.isNotBlank((CharSequence)reportBean.getColumnName()) && (columncode = reportBean.getColumnCode().split(",")).length == (stringArray = reportBean.getColumnName().split(",")).length) {
                    for (int i = 0; i < columncode.length; ++i) {
                        map.put(columncode[i], stringArray[i]);
                    }
                }
                log.info("#\u5e26\u7ffb\u8bd1\u5b57\u6bb5>" + map);
                Map keys = (Map)returnObject.get(0);
                Iterator iterator = keys.keySet().iterator();
                ArrayList<Object> list = new ArrayList<Object>();
                String name = null;
                while (iterator.hasNext()) {
                    name = (String)iterator.next();
                    if (map.containsKey(name)) {
                        list.add(map.get(name));
                        continue;
                    }
                    list.add(name);
                }
                if (list.size() > 0) {
                    log.info("#\u5b57\u6bb5\u7ffb\u8bd1<<<");
                    madelMap.put((Object)"title", list);
                } else {
                    log.info("#\u65e0\u7ffb\u8bd1<<<");
                    madelMap.put((Object)"title", keys.keySet());
                }
                ArrayList rows = new ArrayList();
                for (Map map2 : returnObject) {
                    rows.add(map2.values());
                }
                madelMap.put((Object)"rows", rows);
                log.info("#\u67e5\u8be2\u7ed3\u679c\u6570\u636e\uff1a" + rows);
            } else {
                log.info("#\u67e5\u8be2\u65e0\u4fe1\u606f");
                madelMap.put((Object)"title", new ArrayList());
                madelMap.put((Object)"rows", new ArrayList());
            }
            log.info("#\u67e5\u8be2\u62a5\u8868\u5c55\u793a<<<");
            return "rptms/viewreport/default/list";
        }
        catch (Exception e2) {
            log.error("#\u62a5\u8868\u5c55\u793a\u5931\u8d25", (Throwable)e2);
            madelMap.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "rptms.viewreport.error.searchError") + ":" + e2.getMessage()));
            log.debug("##########\u62a5\u8868\u5c55\u793a<\u7ed3\u675f>##########");
            return "rptms/viewreport/default/error";
        }
    }

    @RequestMapping(value={"/rptms/ViewReportControler/subreport.do"})
    public String subReport(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap madelMap, String reportId) {
        log.debug("##########\u5b50\u62a5\u8868\u5c55\u793a\u9996\u9875\u9762<\u5f00\u59cb>##########");
        try {
            ReportBean reportBean = this.reportManagerService.getReportById(reportId);
            madelMap.put((Object)"report", (Object)reportBean);
            Map<String, Object> allParams = this.getRequestParams(request);
            madelMap.put((Object)"paramMap", allParams);
            madelMap.put((Object)"showChart", allParams.get("showChart"));
            madelMap.put((Object)"time", (Object)new Date().getTime());
        }
        catch (Exception e2) {
            log.error("#\u5b50\u62a5\u8868\u9996\u9875\u9762\u5c55\u793a\u5931\u8d25", (Throwable)e2);
            madelMap.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "rptms.viewreport.error.searchError") + ":" + e2.getMessage()));
        }
        log.debug("##########\u5b50\u62a5\u8868\u5c55\u793a\u9996\u9875\u9762<\u7ed3\u675f>##########");
        return "rptms/viewreport/default/subreport";
    }

    @RequestMapping(value={"/rptms/ViewReportControler/expReport.do"})
    public String expReport(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap modelMap, String reportId, String outputType) {
        log.debug("##########\u62a5\u8868\u5bfc\u51fa<\u5f00\u59cb>##########");
        try {
            String[] columnname;
            String[] columncode;
            if (outputType == null) {
                outputType = "html";
            }
            Map<String, Object> allParams = this.getRequestParams(request);
            ReportBean reportBean = this.reportManagerService.getReportById(reportId);
            if ("Jasper".equals(reportBean.getReportType())) {
                log.debug("#Jasper\u62a5\u8868\u5bfc\u51fa");
                CommonCode commonCode = this.commonCodeService.getByCode(outputType, "reportExpType");
                ReportResultService reportResultService = (ReportResultService)BeanUtils.getBean(commonCode.getNote().trim());
                reportResultService.output(modelMap, allParams, reportBean, pageParam, response);
                return null;
            }
            List<Map<String, Object>> returnObject = this.viewReportService.getReportData(reportBean, allParams, null);
            if (returnObject == null || returnObject.size() < 1) {
                throw new RuntimeException("\u7edf\u8ba1\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2");
            }
            log.debug("#\u67e5\u8be2\u62a5\u8868\u6682\u4e0d\u652f\u6301\u5bfc\u51fa");
            HashMap<String, String> map = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)reportBean.getColumnCode()) && StringUtils.isNotBlank((CharSequence)reportBean.getColumnName()) && (columncode = reportBean.getColumnCode().split(",")).length == (columnname = reportBean.getColumnName().split(",")).length) {
                for (int i = 0; i < columncode.length; ++i) {
                    map.put(columncode[i], columnname[i]);
                }
            }
            log.info("#\u5e26\u7ffb\u8bd1\u5b57\u6bb5>" + map);
            Map<String, Object> keys = returnObject.get(0);
            Iterator<String> it = keys.keySet().iterator();
            String name = null;
            ArrayList<Object> heanderNames = new ArrayList<Object>();
            ArrayList<String> rowkeys = new ArrayList<String>();
            while (it.hasNext()) {
                name = it.next();
                if (name.indexOf("$") >= 0 || "CZ".equals(name.toUpperCase())) continue;
                rowkeys.add(name);
                if (map.containsKey(name)) {
                    heanderNames.add(map.get(name));
                    continue;
                }
                heanderNames.add(name);
            }
            for (Map<String, Object> values : returnObject) {
                String[] datakeys;
                for (String key : datakeys = values.keySet().toArray(new String[0])) {
                    if (key.indexOf("$") >= 0 || "CZ".equals(key.toUpperCase())) {
                        values.remove(key);
                        continue;
                    }
                    Object obj = values.get(key);
                    if (obj == null) continue;
                    obj = obj.toString().replaceAll("<([^>]*?)>", "");
                    values.put(key, obj);
                }
            }
            String fileName = Util.toUtf8String(reportBean.getReportName()) + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelUtil.exportExcel(reportBean.getReportName(), (OutputStream)response.getOutputStream(), "001", returnObject, heanderNames.toArray(new String[0]), rowkeys.toArray(new String[0]));
            return null;
        }
        catch (Exception e2) {
            log.error("#\u62a5\u8868\u5bfc\u51fa\u5931\u8d25", (Throwable)e2);
            modelMap.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "rptms.viewreport.error.expError") + ":" + e2.getMessage()));
            ReturnResult rtnResult = new ReturnResult();
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
            log.debug("##########\u62a5\u8868\u5bfc\u51fa<\u7ed3\u675f>##########");
            return null;
        }
    }

    @RequestMapping(value={"/rptms/ViewReportControler/getReportPagination.do"})
    public String getReportPagination(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap modelMap, String reportId, String outputType) {
        log.debug("##########\u62a5\u8868\u81ea\u5b9a\u4e49\u5206\u9875\u67e5\u8be2<\u5f00\u59cb>##########");
        HashMap<String, Integer> rtnMap = new HashMap<String, Integer>();
        try {
            Map<String, Object> allParams = this.getRequestParams(request);
            ReportBean reportBean = this.reportManagerService.getReportById(reportId);
            Page page = null;
            if ("1".equals(reportBean.getFlagPagination())) {
                page = new Page(pageParam.getPage(), pageParam.getRows());
            }
            this.viewReportService.getReportDataPagination(reportBean, allParams, page);
            rtnMap.put("total", page.getTotal());
        }
        catch (Exception e2) {
            log.error("#\u5206\u9875\u5931\u8d25", (Throwable)e2);
            modelMap.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "rptms.viewreport.error.paginationError") + ":" + e2.getMessage()));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnMap));
        log.debug("##########\u62a5\u8868\u81ea\u5b9a\u4e49\u5206\u9875\u67e5\u8be2<\u7ed3\u675f>##########");
        return null;
    }

    private Map<String, Object> getRequestParams(HttpServletRequest request) {
        log.debug("##########\u62a5\u8868\u53c2\u6570\u5c01\u88c5<\u5f00\u59cb>##########");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            Enumeration items = request.getParameterNames();
            Map valueMap = request.getParameterMap();
            String key = "";
            while (items.hasMoreElements()) {
                key = (String)items.nextElement();
                String[] tmp = (String[])valueMap.get(key);
                String value = "";
                if (tmp == null) continue;
                for (String aa : tmp) {
                    value = value + aa + ",";
                }
                if ("category".equals(key)) {
                    value = new String(value.getBytes("ISO8859-1"), "UTF-8");
                }
                value = value.substring(0, value.lastIndexOf(","));
                returnMap.put(key, URLDecoder.decode(value, "utf-8"));
            }
            log.debug("#\u62a5\u8868\u53c2\u6570:" + Util.toJsonStr(returnMap));
        }
        catch (Exception e2) {
            log.error("#\u62a5\u8868\u53c2\u6570\u5c01\u88c5\u5f02\u5e38", (Throwable)e2);
        }
        log.debug("##########\u62a5\u8868\u53c2\u6570\u5c01\u88c5<\u7ed3\u675f>##########");
        return returnMap;
    }

    @RequestMapping(value={"/rptms/ViewReportControler/indexSubReport.do"})
    public String indexSubReport(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, ModelMap madelMap, String reportId, String reportPieId) {
        log.debug("##########\u5b50\u62a5\u8868\u5c55\u793a\u9996\u9875\u9762<\u5f00\u59cb>##########");
        try {
            ReportBean reportBean = this.reportManagerService.getReportById(reportId);
            ReportBean reportBean2 = this.reportManagerService.getReportById(reportPieId);
            Page page = null;
            if ("1".equals(reportBean.getFlagPagination())) {
                page = new Page(pageParam.getPage(), pageParam.getRows());
            }
            Map<String, Object> allParams = this.getRequestParams(request);
            log.info("#\u62a5\u8868\u53c2\u6570\u4fe1\u606f>" + allParams);
            List<Map<String, Object>> returnObject = this.viewReportService.getReportData(reportBean, allParams, page);
            List<Map<String, Object>> returnObject2 = this.viewReportService.getReportData(reportBean2, allParams, page);
            ReportChart reportChart = reportBean.getReportChart();
            ReportChart reportChart2 = reportBean2.getReportChart();
            String barFilename = this.reportChartService.createReportChart(reportChart, returnObject, response);
            String pieFilename = this.reportChartService.createReportChart(reportChart2, returnObject2, response);
            request.setAttribute("barFilename", (Object)barFilename);
            request.setAttribute("pieFilename", (Object)pieFilename);
            return "rptms/viewreport/default/subchart";
        }
        catch (Exception e2) {
            log.error("#\u5b50\u62a5\u8868\u9996\u9875\u9762\u5c55\u793a\u5931\u8d25", (Throwable)e2);
            madelMap.put((Object)"errMsg", (Object)(MessageManager.getProMessage(this.message, "rptms.viewreport.error.searchError") + ":" + e2.getMessage()));
            log.debug("##########\u5b50\u62a5\u8868\u5c55\u793a\u9996\u9875\u9762<\u7ed3\u675f>##########");
            return "rptms/viewreport/default/subreport";
        }
    }
}

