/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.job;

import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.FtpUpload;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.rptms.bean.QueryReportTemplateBean;
import com.xdja.pams.rptms.entity.FtpInfo;
import com.xdja.pams.rptms.entity.Report;
import com.xdja.pams.rptms.entity.ReportTimer;
import com.xdja.pams.rptms.entity.ReportTimerCondition;
import com.xdja.pams.rptms.service.ReportResultService;
import com.xdja.pams.rptms.service.TimerReportService;
import com.xdja.pams.rptms.service.ViewReportUtils;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerReportJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(TimerReportJob.class);

    public void execute(JobExecutionContext jobCtx) {
        log.info("&&&&&&&&&&\u5b9a\u65f6\u4efb\u52a1\u6267\u884c<\u5f00\u59cb>&&&&&&&&&&");
        try {
            String timerTaskId = (String)jobCtx.getMergedJobDataMap().get((Object)"timerTaskId");
            TimerReportService timerReportService = (TimerReportService)BeanUtils.getBean(TimerReportService.class);
            ViewReportUtils viewReportUtils = (ViewReportUtils)BeanUtils.getBean(ViewReportUtils.class);
            CommonCodeService commonCodeService = (CommonCodeService)BeanUtils.getBean(CommonCodeService.class);
            ReportTimer reportTimer = timerReportService.queryTimerReportById(timerTaskId);
            Report report = reportTimer.getReport();
            List<ReportTimerCondition> reportTimerConditionList = reportTimer.getReportTimerConditionList();
            String handleType = reportTimer.getHandleType();
            String saveLocation = reportTimer.getSaveLocation();
            String suffix = reportTimer.getReportForm();
            String fileName = System.currentTimeMillis() + "_" + report.getReportName() + "." + suffix;
            HashMap<String, Object> allParams = new HashMap<String, Object>();
            for (ReportTimerCondition condition : reportTimerConditionList) {
                String conditionValue = condition.getConditionValue();
                if ("sql".equals(condition.getType())) {
                    conditionValue = viewReportUtils.queryForObject(report.getDatasourceId(), conditionValue, String.class, new Object[0]);
                }
                allParams.put(condition.getConditionIdAndName(), conditionValue);
            }
            CommonCode commonCode = commonCodeService.getByCode(suffix, "reportExpType");
            ReportResultService reportResultService = (ReportResultService)BeanUtils.getBean(commonCode.getNote().trim());
            File file = new File(QueryReportTemplateBean.ROOT_PATH + saveLocation + File.separator + fileName);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            log.info("#>\u5b9a\u65f6\u62a5\u8868ID\uff1a" + reportTimer.getId() + ">\u62a5\u8868ID\uff1a" + report.getReportId() + ">\u62a5\u8868\u53c2\u6570\u4fe1\u606f\uff1a" + Util.toJsonStr(allParams));
            reportResultService.output(allParams, report.getReportId(), fileOutputStream);
            fileOutputStream.close();
            log.info("&\u62a5\u8868\u5df2\u751f\u6210\u5230\u672c\u5730\uff1a" + file.getAbsolutePath());
            if ("2".equals(handleType)) {
                FtpInfo ftpInfo = reportTimer.getFtpInfo();
                FtpUpload ftpUpload = new FtpUpload(ftpInfo.getUrl(), ftpInfo.getUsername(), ftpInfo.getPassword(), ftpInfo.getPort(), ftpInfo.getPath());
                FileInputStream inputStream = new FileInputStream(file);
                ftpUpload.upMyFile(fileName, inputStream);
                file.delete();
                log.info("&\u672c\u5730\u62a5\u8868\u6587\u4ef6\u5df2\u5220\u9664");
            }
        }
        catch (Exception e2) {
            log.error("&\u751f\u6210\u5b9a\u65f6\u62a5\u8868\u51fa\u9519", (Throwable)e2);
        }
        log.info("&&&&&&&&&&\u5b9a\u65f6\u4efb\u52a1\u6267\u884c<\u7ed3\u675f>&&&&&&&&&&");
    }
}

