/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.service.impl;

import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.rptms.bean.DatasourceBean;
import com.xdja.pams.rptms.dao.DatasourceManagerDao;
import com.xdja.pams.rptms.entity.Datasource;
import com.xdja.pams.rptms.service.DatasourceMangerService;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class DatasourceServiceManagerImpl
implements DatasourceMangerService {
    @Autowired
    private DatasourceManagerDao datasourceDao;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(DatasourceServiceManagerImpl.class);

    @Override
    public List<DatasourceBean> queryDatasourceList(DatasourceBean datasourceBean, Page page) {
        log.debug("\u6570\u636e\u6e90\u67e5\u8be2.....start....");
        ArrayList<DatasourceBean> datasourceBeanList = new ArrayList<DatasourceBean>();
        List<Datasource> datasourceList = this.datasourceDao.queryConditionList(datasourceBean, page);
        String codeName = "";
        DatasourceBean tmpDatasourceBean = null;
        for (Datasource datasource : datasourceList) {
            tmpDatasourceBean = new DatasourceBean();
            BeanUtils.copyProperties((Object)datasource, (Object)tmpDatasourceBean);
            codeName = this.commonCodePbService.getCodeNameByCode(String.valueOf(tmpDatasourceBean.getDatasourceType()), "datasourceType");
            tmpDatasourceBean.setDatasourceTypeName(codeName);
            datasourceBeanList.add(tmpDatasourceBean);
        }
        log.debug("\u6570\u636e\u6e90\u67e5\u8be2.....end....");
        return datasourceBeanList;
    }

    @Override
    public DatasourceBean getDatasourceById(String datasourceId) {
        DatasourceBean datasourceBean = new DatasourceBean();
        Datasource datasource = this.datasourceDao.getDatasourceById(datasourceId);
        if (datasource == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchDatasourceExit") + ":" + datasourceId);
            return null;
        }
        BeanUtils.copyProperties((Object)datasource, (Object)datasourceBean);
        String codeName = this.commonCodePbService.getCodeNameByCode(String.valueOf(datasourceBean.getDatasourceType()), "datasourceType");
        datasourceBean.setDatasourceTypeName(codeName);
        return datasourceBean;
    }

    @Override
    public DataSource getJdbcDataSourceById(String datasourceId) {
        return null;
    }
}

