/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.service.impl;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.rptms.bean.QueryReportTemplateBean;
import com.xdja.pams.rptms.bean.UploadItemsBean;
import com.xdja.pams.rptms.dao.ReportTemplateManageDao;
import com.xdja.pams.rptms.entity.Report;
import com.xdja.pams.rptms.entity.ReportTemplate;
import com.xdja.pams.rptms.service.ReportTemplateManageService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ReportTemplateManageServiceImpl
implements ReportTemplateManageService {
    @Autowired
    private ReportTemplateManageDao reportTemplateManageDao;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(ReportTemplateManageServiceImpl.class);

    @Override
    public List<QueryReportTemplateBean> queryReportTemplateList(QueryReportTemplateBean queryReportTemplateBean, Page page) {
        List<ReportTemplate> reportTemplateList = this.reportTemplateManageDao.queryReportTemplateListByHql(queryReportTemplateBean, page);
        ArrayList<QueryReportTemplateBean> rtList = new ArrayList<QueryReportTemplateBean>();
        for (ReportTemplate reportTemplate : reportTemplateList) {
            QueryReportTemplateBean reportTemplateBean = new QueryReportTemplateBean();
            reportTemplateBean.setName(reportTemplate.getName());
            reportTemplateBean.setId(reportTemplate.getId());
            reportTemplateBean.setUserName(this.userManageService.queryPersonById(reportTemplate.getCreatorId()).getName());
            reportTemplateBean.setCreateTime(Util.getDate("yyyy-MM-dd HH:mm:ss", reportTemplate.getCreateDate()));
            reportTemplateBean.setFilePath(reportTemplate.getFilePath());
            reportTemplateBean.setNote(reportTemplate.getNote());
            rtList.add(reportTemplateBean);
        }
        return rtList;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public String addTemplate(UploadItemsBean uploadItems, ReportTemplate reportTemplate) {
        log.debug("\u6dfb\u52a0\u6a21\u677f\u65b9\u6cd5addTemplate\u5f00\u59cb...");
        List<MultipartFile> multipartFileList = uploadItems.getFileData();
        for (MultipartFile file : multipartFileList) {
            int timsShareFileMaxSize;
            long fileSize = file.getSize();
            if (fileSize / 0x100000L >= (long)(timsShareFileMaxSize = Integer.parseInt(this.scps.getValueByCode("RPTMSFileMaxSize")))) {
                log.error(MessageManager.getProMessage(this.message, "rptms.templateManage.error.threshold", new String[]{timsShareFileMaxSize + ""}));
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.threshold", new String[]{timsShareFileMaxSize + ""}));
            }
            try {
                InputStream is = file.getInputStream();
                FileOutputStream fos = null;
                File dir = new File(reportTemplate.getFileAllPath().substring(0, reportTemplate.getFileAllPath().lastIndexOf(File.separator)));
                dir.mkdir();
                fos = file.getOriginalFilename().indexOf("jrxml") > 0 ? new FileOutputStream(new File(reportTemplate.getFileAllPath())) : new FileOutputStream(new File(reportTemplate.getPictureAllPath()));
                byte[] temp = new byte[(int)fileSize];
                while (is.read(temp) != -1) {
                    fos.write(temp);
                }
                is.close();
                fos.close();
            }
            catch (Exception e2) {
                log.error(MessageManager.getProMessage(this.message, "rptms.templateManage.error.writeDisk"), (Throwable)e2);
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.writeDisk"));
            }
        }
        return this.reportTemplateManageDao.addReportTemplate(reportTemplate);
    }

    @Override
    public ReportTemplate queryReportTemplateById(String id) {
        return this.reportTemplateManageDao.queryReportTemplateById(id);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateReportTemplate(ReportTemplate reportTemplate) {
        this.reportTemplateManageDao.updateReportTemplate(reportTemplate);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteReportTemplate(ReportTemplate reportTemplate) {
        log.debug("\u5220\u9664\u6a21\u677f\u65b9\u6cd5deleteReportTemplate\u5f00\u59cb...");
        List<Report> reportList = reportTemplate.getReportList();
        if (reportList != null && reportList.size() > 0) {
            log.error(MessageManager.getProMessage(this.message, "rptms.templateManage.error.using"));
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.using"));
        }
        try {
            File pictureFile = new File(reportTemplate.getPictureAllPath());
            pictureFile.delete();
            pictureFile.getParentFile().delete();
            File templateFile = new File(reportTemplate.getFileAllPath());
            templateFile.delete();
            templateFile.getParentFile().delete();
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "rptms.templateManage.error.deleteFile"));
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.deleteFile"));
        }
        this.reportTemplateManageDao.deleteReportTemplate(reportTemplate);
    }

    @Override
    public void validateRt(String filepath) {
        List<ReportTemplate> list = this.reportTemplateManageDao.queryReportTemplateByFilePath(filepath);
        if (list != null && list.size() > 0) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.validatefile"));
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void replaceReportTemplate(UploadItemsBean uploadItemsBean, ReportTemplate reportTemplate, StringBuffer path) {
        log.debug("\u66ff\u6362\u6a21\u677f\u65b9\u6cd5replaceReportTemplate\u5f00\u59cb...");
        File oldfile = new File(reportTemplate.getFileAllPath());
        List<MultipartFile> files = uploadItemsBean.getFileData();
        boolean flag = true;
        if (!oldfile.exists()) {
            try {
                File pictureFile = new File(reportTemplate.getPictureAllPath());
                pictureFile.delete();
                pictureFile.getParentFile().delete();
                File templateFile = new File(reportTemplate.getFileAllPath());
                templateFile.delete();
                templateFile.getParentFile().delete();
            }
            catch (Exception e2) {
                log.error(MessageManager.getProMessage(this.message, "rptms.templateManage.error.deleteFile"));
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.deleteFile"));
            }
            flag = false;
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                String extension = FilenameUtils.getExtension((String)fileName);
                if ("jrxml".equalsIgnoreCase(extension)) {
                    path.append(fileName.substring(0, fileName.lastIndexOf(".")));
                    reportTemplate.setFilePath(path.toString() + File.separator + path.toString().substring(path.toString().lastIndexOf(File.separator) + 1) + "." + extension);
                    continue;
                }
                reportTemplate.setPicturePath(path.toString() + File.separator + path.toString().substring(path.toString().lastIndexOf(File.separator) + 1) + "." + extension);
            }
        }
        this.uploadFile(files, reportTemplate, flag);
        this.reportTemplateManageDao.updateReportTemplate(reportTemplate);
        log.debug("\u66ff\u6362\u6a21\u677f\u65b9\u6cd5replaceReportTemplate\u7ed3\u675f...");
    }

    private void uploadFile(List<MultipartFile> files, ReportTemplate reportTemplate, boolean flag) {
        for (MultipartFile file : files) {
            String fileName = file.getOriginalFilename();
            String extension = FilenameUtils.getExtension((String)fileName);
            String path = "";
            if ("jrxml".equalsIgnoreCase(extension)) {
                if (!fileName.substring(0, fileName.lastIndexOf(".")).matches("^([A-Z]|[a-z])+([a-z]|[A-Z]|[0-9]|_)*([A-Z]|[0-9]|[a-z])$")) {
                    throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.addrtfilenamenotright"));
                }
                path = reportTemplate.getFileAllPath();
            } else {
                path = reportTemplate.getPictureAllPath();
            }
            long fileSize = file.getSize();
            int timsShareFileMaxSize = Integer.parseInt(this.scps.getValueByCode("RPTMSFileMaxSize"));
            if (fileSize / 0x100000L >= (long)timsShareFileMaxSize) {
                log.error(MessageManager.getProMessage(this.message, "rptms.templateManage.error.threshold", new String[]{timsShareFileMaxSize + ""}));
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.threshold", new String[]{timsShareFileMaxSize + ""}));
            }
            if (!flag) {
                File dir = new File(reportTemplate.getFileAllPath().substring(0, reportTemplate.getFileAllPath().lastIndexOf(File.separator)));
                dir.mkdir();
            }
            try {
                InputStream is = file.getInputStream();
                FileOutputStream fos = null;
                fos = new FileOutputStream(new File(path));
                byte[] temp = new byte[(int)fileSize];
                while (is.read(temp) != -1) {
                    fos.write(temp);
                }
                is.close();
                fos.close();
            }
            catch (Exception e2) {
                log.error(MessageManager.getProMessage(this.message, "rptms.templateManage.error.writeDisk"), (Throwable)e2);
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.writeDisk"));
            }
        }
    }
}

