/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.service.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.bean.TimeTaskBean;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.QuartzUtil;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.rptms.bean.QueryReportTimerBean;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.dao.TimerReportDao;
import com.xdja.pams.rptms.entity.FtpInfo;
import com.xdja.pams.rptms.entity.ReportTimer;
import com.xdja.pams.rptms.entity.ReportTimerCondition;
import com.xdja.pams.rptms.service.ReportManagerService;
import com.xdja.pams.rptms.service.TimerReportService;
import com.xdja.pams.rptms.service.ViewReportService;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class TimerReportServiceImpl
implements TimerReportService {
    private static final String JOB_CLASS_PATH = "com.xdja.pams.rptms.job.TimerReportJob";
    private static final String CRON_EVERY_MONTH = "0 10 3 1 * ?";
    @Autowired
    private TimerReportDao timerReportDao;
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private ReportManagerService reportManagerService;
    @Autowired
    private ViewReportService viewReportService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(TimerReportServiceImpl.class);

    @Override
    @Transactional
    public String addTimerReport(ReportTimer reportTimer) {
        log.debug("##########\u4fdd\u5b58\u5b9a\u65f6\u62a5\u8868\u4fe1\u606f<\u5f00\u59cb>##########");
        if ("2".equals(reportTimer.getHandleType())) {
            FtpInfo ftpInfo = reportTimer.getFtpInfo();
            this.baseDao.create(ftpInfo);
            reportTimer.setFtpInfo(ftpInfo);
        } else {
            reportTimer.setFtpInfo(null);
        }
        ReportBean report = this.reportManagerService.getReportById(reportTimer.getReport().getReportId());
        reportTimer.setReport(report);
        String timerReportId = this.timerReportDao.addTimerReport(reportTimer);
        List<ReportTimerCondition> reportTimerConditionList = this.getReportTimerConditionList(reportTimer);
        if (reportTimerConditionList != null && reportTimerConditionList.size() > 0) {
            for (ReportTimerCondition reportTimerCondition : reportTimerConditionList) {
                reportTimerCondition.setReportTimer(reportTimer);
                this.baseDao.create(reportTimerCondition);
            }
        }
        log.debug("##########\u4fdd\u5b58\u5b9a\u65f6\u62a5\u8868\u4fe1\u606f<\u7ed3\u675f>##########");
        return timerReportId;
    }

    @Override
    public List<QueryReportTimerBean> queryTimerReportsList(QueryReportTimerBean queryTimerReportBean, Page page) {
        List<ReportTimer> reportTimerList = this.timerReportDao.queryTimerReportsByHql(queryTimerReportBean, page);
        ArrayList<QueryReportTimerBean> queryReportTimerBeanList = new ArrayList<QueryReportTimerBean>();
        for (ReportTimer reportTimer : reportTimerList) {
            QueryReportTimerBean queryReportTimerBean = new QueryReportTimerBean();
            queryReportTimerBean.setId(reportTimer.getId());
            queryReportTimerBean.setReportName(reportTimer.getReport().getReportName());
            queryReportTimerBean.setStrStartTime(Util.getDate("yyyy-MM-dd HH:mm:ss", reportTimer.getStartTime()));
            queryReportTimerBean.setStartTime(reportTimer.getStartTime());
            queryReportTimerBean.setTimerType(reportTimer.getTimerType());
            queryReportTimerBean.setTimerTypeName(this.commonCodePbService.getCodeNameByCode(reportTimer.getTimerType(), "timerType"));
            queryReportTimerBean.setReportForm(reportTimer.getReportForm());
            try {
                queryReportTimerBean.setNextRunTime(QuartzUtil.getNextFireTime(reportTimer.getId()));
            }
            catch (SchedulerException e2) {
                log.error(MessageManager.getProMessage(this.message, "rptms.timerReport.error.getNextRunTime"), (Throwable)e2);
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.timerReport.error.getNextRunTime"));
            }
            queryReportTimerBean.setStateName(this.commonCodePbService.getCodeNameByCode(reportTimer.getState(), "timerReportState"));
            queryReportTimerBean.setState(reportTimer.getState());
            queryReportTimerBean.setExecuteCycle(reportTimer.getExecuteCycle());
            queryReportTimerBean.setCron(reportTimer.getCron());
            queryReportTimerBeanList.add(queryReportTimerBean);
        }
        return queryReportTimerBeanList;
    }

    @Override
    public void startTimerReports(QueryReportTimerBean queryReportTimerBean) {
        log.debug("$$$$$$$$$$$\u542f\u52a8\u5b9a\u65f6\u62a5\u8868<\u5f00\u59cb>$$$$$$$$$$$");
        List<QueryReportTimerBean> queryReportTimerBeanList = this.queryTimerReportsList(queryReportTimerBean, null);
        ArrayList<TimeTaskBean> timerTaskList = new ArrayList<TimeTaskBean>();
        if (queryReportTimerBeanList == null || queryReportTimerBeanList.size() == 0) {
            log.debug("$\u65e0\u5b9a\u65f6\u62a5\u8868......");
        } else {
            for (QueryReportTimerBean queryReportTimer : queryReportTimerBeanList) {
                TimeTaskBean timerTask = new TimeTaskBean();
                timerTask.setId(queryReportTimer.getId());
                timerTask.setStarttime(queryReportTimer.getStartTime());
                timerTask.setStatus(2);
                timerTask.setName(queryReportTimer.getReportName());
                timerTask.setClasspath(JOB_CLASS_PATH);
                if ("2".equals(queryReportTimer.getTimerType())) {
                    timerTask.setTimerType("2");
                    timerTask.setCron(queryReportTimer.getCron());
                } else {
                    timerTask.setTimerType("1");
                    String executeCycle = queryReportTimer.getExecuteCycle();
                    if ("1".equals(executeCycle)) {
                        timerTask.setInterval(1);
                        timerTask.setFreqtype(3);
                    } else if ("2".equals(executeCycle)) {
                        timerTask.setInterval(24);
                        timerTask.setFreqtype(3);
                    } else if ("3".equals(executeCycle)) {
                        timerTask.setInterval(168);
                        timerTask.setFreqtype(3);
                    } else {
                        timerTask.setTimerType("2");
                        timerTask.setCron(CRON_EVERY_MONTH);
                    }
                }
                timerTaskList.add(timerTask);
            }
            QuartzUtil.startAllJob(timerTaskList);
        }
        log.debug("$$$$$$$$$$$\u542f\u52a8\u5b9a\u65f6\u62a5\u8868<\u7ed3\u675f>$$$$$$$$$$$");
    }

    @Override
    @Transactional
    public void updateTimerReport(ReportTimer reportTimer) {
        log.debug("$$$$$$$$$$$\u66f4\u65b0\u5b9a\u65f6\u62a5\u8868<\u5f00\u59cb>$$$$$$$$$$$");
        String reportTimerId = reportTimer.getId();
        ReportTimer reportTimerOld = this.timerReportDao.queryTimerReportById(reportTimerId);
        try {
            reportTimerOld.setStartTime(Util.parseDate(reportTimer.getStrStartTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        catch (Exception e2) {
            log.error("$\u5b9a\u65f6\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef", (Throwable)e2);
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.timerReport.error.getNextRunTime"));
        }
        reportTimerOld.setTimerType(reportTimer.getTimerType());
        reportTimerOld.setExecuteCycle(reportTimer.getExecuteCycle());
        reportTimerOld.setCron(reportTimer.getCron());
        reportTimerOld.setReportForm(reportTimer.getReportForm());
        reportTimerOld.setHandleType(reportTimer.getHandleType());
        reportTimerOld.setNote(reportTimer.getNote());
        reportTimerOld.setState("1");
        if ("1".equals(reportTimer.getHandleType())) {
            reportTimerOld.setFtpInfo(null);
        } else {
            log.info("$Ftp\u4fe1\u606f\u5c01\u88c5<<<");
            FtpInfo newFtpInfo = reportTimer.getFtpInfo();
            if (reportTimerOld.getFtpInfo() == null) {
                FtpInfo ftpInfo = new FtpInfo();
                ftpInfo.setUrl(newFtpInfo.getUrl());
                ftpInfo.setPort(newFtpInfo.getPort());
                ftpInfo.setUsername(newFtpInfo.getUsername());
                ftpInfo.setPassword(newFtpInfo.getPassword());
                ftpInfo.setPath(newFtpInfo.getPath());
                ftpInfo.setCreatorId(newFtpInfo.getCreatorId());
                this.baseDao.create(ftpInfo);
                reportTimerOld.setFtpInfo(ftpInfo);
            } else {
                reportTimerOld.getFtpInfo().setUrl(newFtpInfo.getUrl());
                reportTimerOld.getFtpInfo().setPort(newFtpInfo.getPort());
                reportTimerOld.getFtpInfo().setUsername(newFtpInfo.getUsername());
                reportTimerOld.getFtpInfo().setPassword(newFtpInfo.getPassword());
                reportTimerOld.getFtpInfo().setPath(newFtpInfo.getPath());
            }
            log.info("#>FTP\u4fe1\u606f:" + Util.toJsonStr(reportTimerOld.getFtpInfo()));
            log.info("$Ftp\u4fe1\u606f\u5c01\u88c5<<<");
        }
        log.info("$\u62a5\u8868\u53c2\u6570\u4fe1\u606f\u5c01\u88c5>>>");
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        List<ReportTimerCondition> reportTimerConditionList = this.getReportTimerConditionList(reportTimer);
        for (ReportTimerCondition reportTimerCondition : reportTimerConditionList) {
            conditionMap.put(reportTimerCondition.getConditionIdAndName(), reportTimerCondition.getConditionValue());
        }
        List<ReportTimerCondition> reportTimerConditionOldList = reportTimerOld.getReportTimerConditionList();
        ArrayList<ReportTimerCondition> reportTimerConditionNewList = new ArrayList<ReportTimerCondition>();
        if (reportTimerConditionOldList != null && reportTimerConditionOldList.size() > 0) {
            for (ReportTimerCondition reportTimerCondition : reportTimerConditionOldList) {
                String conditionValue = (String)conditionMap.get(reportTimerCondition.getConditionIdAndName());
                if (conditionValue != null) {
                    reportTimerCondition.setConditionValue(conditionValue);
                    reportTimerConditionNewList.add(reportTimerCondition);
                }
                conditionMap.remove(reportTimerCondition.getConditionIdAndName());
            }
        }
        for (Map.Entry entry : conditionMap.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            ReportTimerCondition reportTimerCondition = new ReportTimerCondition();
            reportTimerCondition.setReportTimer(reportTimerOld);
            reportTimerCondition.setType("normal");
            reportTimerCondition.setConditionIdAndName(key);
            reportTimerCondition.setConditionValue(val);
            reportTimerConditionNewList.add(reportTimerCondition);
        }
        reportTimerOld.setReportTimerConditionList(reportTimerConditionNewList);
        log.info("$\u62a5\u8868\u53c2\u6570\u4fe1\u606f\u5c01\u88c5<<<");
        this.timerReportDao.updateTimerReport(reportTimerOld);
        log.debug("$$$$$$$$$$$\u66f4\u65b0\u5b9a\u65f6\u62a5\u8868<\u7ed3\u675f>$$$$$$$$$$$");
    }

    @Override
    public ReportTimer queryTimerReportById(String id) {
        return this.timerReportDao.queryTimerReportById(id);
    }

    @Override
    @Transactional
    public void deleteReportTimer(ReportTimer reportTimer) {
        this.timerReportDao.deleteReportTimer(reportTimer);
    }

    @Override
    @Transactional
    public void changeState(String id, String state) {
        log.debug("\u66f4\u6539\u5b9a\u65f6\u62a5\u8868\u72b6\u6001\u65b9\u6cd5changeState\u5f00\u59cb...");
        ReportTimer reportTimer = this.timerReportDao.queryTimerReportById(id);
        if ("1".equals(state)) {
            try {
                QuartzUtil.stopJob(id);
            }
            catch (SchedulerException e2) {
                log.error(MessageManager.getProMessage(this.message, "rptms.timerReport.error.stopError"), (Throwable)e2);
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.timerReport.error.stopError"));
            }
            reportTimer.setState("0");
        } else {
            QueryReportTimerBean queryReportTimerBean = new QueryReportTimerBean();
            queryReportTimerBean.setId(id);
            this.startTimerReports(queryReportTimerBean);
            reportTimer.setState("1");
        }
        this.timerReportDao.updateTimerReport(reportTimer);
    }

    @Override
    public List<ReportTimerCondition> getReportTimerConditionList(ReportTimer reportTimer) {
        String[] conditionValueStrs;
        log.info("$\u62a5\u8868\u53c2\u6570\u5904\u7406>>>");
        ArrayList<ReportTimerCondition> reportTimerConditionList = new ArrayList<ReportTimerCondition>();
        String conditionValues = reportTimer.getConditionValues();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String conditionValue : conditionValueStrs = conditionValues.split("#")) {
            String[] conditionValueArray = conditionValue.split("=");
            if (conditionValueArray.length == 2) {
                String vlue = (String)map.get(conditionValueArray[0]);
                if (null != vlue) {
                    map.put(conditionValueArray[0], vlue + "," + conditionValueArray[1]);
                    continue;
                }
                map.put(conditionValueArray[0], conditionValueArray[1]);
                continue;
            }
            map.put(conditionValueArray[0], "NULL");
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            ReportTimerCondition reportTimerCondition = new ReportTimerCondition();
            String idAndName = key.replaceAll("_timer", "");
            HttpSession session = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getSession();
            String sessionFlag = (String)session.getAttribute(idAndName);
            if ("datebox".equals(sessionFlag)) {
                reportTimerCondition.setType("sql");
            } else {
                reportTimerCondition.setType("normal");
            }
            reportTimerCondition.setConditionIdAndName(idAndName);
            reportTimerCondition.setConditionValue(val);
            reportTimerConditionList.add(reportTimerCondition);
        }
        log.info("$\u62a5\u8868\u53c2\u6570\u5904\u7406<<<");
        return reportTimerConditionList;
    }
}

