/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.CertDownLoadReturn;
import com.xdja.pams.scms.service.CertDownLoadService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class CertDownLoadControl
extends BaseControler {
    @Autowired
    CertDownLoadService certDownLoadService;
    @Autowired
    UserManageService userManageService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(CertDownLoadControl.class);

    @RequestMapping(value={"scms/certdownloadcontrol/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/certdownloadcontrol/query.do"})
    public void query(String code, HttpServletResponse response, HttpServletRequest request) {
        CertDownLoadReturn rtn = new CertDownLoadReturn();
        try {
            Person person = this.userManageService.getUserByCode(code);
            if (person == null) {
                rtn.setFlag("1");
                rtn.setMsg(MessageManager.getProMessage(this.message, "scms.device.certdownload.unfindcode"));
            }
            rtn.setFlag("0");
            rtn.setCode(code);
            rtn.setDepname(person.getDepName());
            rtn.setIdentifier(person.getIdentifier());
            rtn.setName(person.getName());
            rtn.setPolice(person.getPolice());
            rtn.setCertExist(this.certDownLoadService.checkOfflineCert(code));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rtn.setFlag("1");
            rtn.setMsg(MessageManager.getProMessage(this.message, "scms.device.certdownload.error") + ":" + e2.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtn));
    }

    public CertDownLoadService getCertDownLoadService() {
        return this.certDownLoadService;
    }

    public void setCertDownLoadService(CertDownLoadService certDownLoadService) {
        this.certDownLoadService = certDownLoadService;
    }

    public UserManageService getUserManageService() {
        return this.userManageService;
    }

    public void setUserManageService(UserManageService userManageService) {
        this.userManageService = userManageService;
    }

    public ResourceBundleMessageSource getMessage() {
        return this.message;
    }

    public void setMessage(ResourceBundleMessageSource message) {
        this.message = message;
    }
}

