/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.bean.QueryDeviceBean;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.enaas.service.EnaasService;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.CertInAirRtn;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.bean.DInfoCA;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.bean.TerminalBean;
import com.xdja.pams.scms.entity.CertAir;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.DeviceHistory;
import com.xdja.pams.scms.entity.PersonJITInfo;
import com.xdja.pams.scms.entity.PersonKOALInfo;
import com.xdja.pams.scms.entity.TerminalLog;
import com.xdja.pams.scms.service.DeviceHistoryService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.IssuingDoubleCertInAirService;
import com.xdja.pams.scms.service.PersonJITInfoService;
import com.xdja.pams.scms.service.PersonKOALInfoService;
import com.xdja.pams.scms.service.TerminalLogService;
import com.xdja.pams.scms.service.TerminalReportService;
import com.xdja.pams.scms.service.TerminalService;
import com.xdja.pams.scms.util.CertUserInfoTrans;
import com.xdja.pams.scms.util.Variable;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.CardRegisterService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.webservice.client.CommonDClient;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Scope(value="session")
public class DeviceController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(DeviceController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private DeviceHistoryService deviceHistoryService;
    @Autowired
    private CardRegisterService cardRegisterService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TerminalLogService terminalLogService;
    @Autowired
    private TerminalReportService terminalReportService;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private EnaasService enaasService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private TerminalService terminalService;
    @Autowired
    private PersonJITInfoService personJITInfoService;
    @Autowired
    private PersonKOALInfoService personKOALInfoService;
    @Autowired
    private IssuingDoubleCertInAirService issuingDoubleCertInAirService;
    private static String TASK_WRITECARD = "writeCard";
    private static String TASK_OPEN = "writeCard";
    private static String TASK_PAUSE = "writeCard";
    private static final String SPECIEL_STR = ",,";

    @RequestMapping(value={"scms/devicecontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            map.put((Object)"isSupportCertUpdate", (Object)this.systemConfigPbService.getValueByCode("is_support_cert_update"));
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/devicecontroller/query.do"})
    public void query(QueryForm form, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        ArrayList listmap = new ArrayList();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        int operateResult = 0;
        try {
            if (StringUtils.isBlank((CharSequence)form.getDepId())) {
                form.setControlDeps(operator.getControlDeps());
            }
            form.setControlPolice(operator.getControlPolices());
            List<Device> list = this.deviceService.query(form, page);
            for (Device device : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                Person personb = this.userManagerService.queryPersonById(device.getPersonId());
                map.put("id", device.getId());
                map.put("name", Util.cvNameByPersonType(personb.getName(), personb.getPersonType()));
                map.put("code", personb.getCode());
                map.put("depname", personb.getDepartment().getName());
                map.put("identifier", personb.getIdentifier());
                map.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
                CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
                map.put("cardtype", cardtype != null ? cardtype.getName() : "");
                CommonCode usetype = this.commonCodeService.getByCode(device.getUseType(), "useType");
                map.put("usetype", usetype != null ? usetype.getName() : "");
                CommonCode commType = this.commonCodeService.getByCode(device.getCommType(), "2015");
                map.put("commType", commType != null ? commType.getName() : "");
                map.put("devicename", device.getName());
                map.put("personTypeName", this.commonCodePbService.getCodeNameByCode(personb.getPersonType(), "PERSON_TYPE"));
                map.put("videoState", device.getVideoDeviceOpenState());
                map.put("iccid", device.getIccid());
                map.put("revokeIccid", device.getEnaasDesc());
                listmap.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/devicecontroller/getapprovecard.do"})
    public void getApproveCard(HttpServletRequest request, HttpServletResponse response) {
        List<Device> list = this.deviceService.getApproveCard();
        ArrayList listmap = new ArrayList();
        for (Device device : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            PersonBean personb = this.userManagerService.getPersonById(device.getPersonId());
            map.put("code", personb.getCODE());
            map.put("type", device.getType());
            map.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
            listmap.add(map);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(listmap));
    }

    @RequestMapping(value={"scms/devicecontroller/claim.action"})
    public void claim(String taskId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
    }

    @RequestMapping(value={"scms/devicecontroller/openwinmask.do"})
    public void openWinmask(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Util.writeUtf8Text(response, "{'message':'0'}");
    }

    @RequestMapping(value={"scms/devicecontroller/certQuer.do"})
    public void certQuer(String algFlag, String version, String cardtype, String commType, String personType, HttpServletResponse response) {
        String result = "";
        try {
            String gatecert;
            DInfo d = this.systemConfigService.getDInfoByYYS(commType, personType);
            result = !"on".equals(d.getGetGWCertSwitch()) ? "[\"success\",\"getGWCertSwitch off\"]" : ((gatecert = CommonDClient.certQuery(d.getUrl(), version, cardtype, d.getGateCardNO(), algFlag, d.getDevCardNo(), d.getDevPassword())).length() > 3 ? "[\"success\",\"" + gatecert.replaceAll("\r|\n", "") + "\"]" : "[\"" + gatecert + "\",\"" + DInfo.getCertQueryErr(gatecert, version, algFlag) + "\"]");
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            result = "[\"-1\";\"\u83b7\u53d6\u7f51\u5173\u8bc1\u4e66\u5931\u8d25\uff01\"]";
        }
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"scms/devicecontroller/certIssue.do"})
    public void certIssue(String version, String cardtype, String cardno, String pubkey, String admin, String decardno, String password, String personType, boolean isDelayCard, String deviceId, String commType, HttpServletResponse response) {
        String result;
        try {
            DInfo d = this.systemConfigService.getDInfoByYYS(commType, personType);
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
            String sysId = this.systemConfigService.getValueByCode("enaas_sysid");
            if (isDelayCard) {
                String version2 = "2.0";
                String algtype = "admin";
                DInfo dInfo = this.systemConfigService.getDInfoByYYS(commType, personType);
                String cardType = "";
                cardType = DInfo.covCartType(device.getType());
                if ("1".equals(dInfo.getIsSM2())) {
                    version2 = "3.0";
                    algtype = DInfo.covALgType(device.getAlgType());
                }
                String rst = null;
                rst = !"2".equals(personType) && "1".equals(isUseEnaas) ? CommonDClient.certRevokeRA(dInfo.getUrl(), version2, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), sysId) : CommonDClient.certRevoke(dInfo.getUrl(), version2, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword());
                if ("1".equals(rst) || "4".equals(rst) || "15".equals(rst)) {
                    try {
                        TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(device, "1");
                        this.terminalLogService.save(terminalLog);
                        this.terminalReportService.report(terminalLog);
                    }
                    catch (Exception e2) {
                        log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4e0a\u62a5\u5f02\u5e38", (Throwable)e2);
                    }
                } else {
                    String result2 = "[\"-1\",\"" + DInfo.getCertRevoke(rst) + "\"]";
                    Util.writeUtf8Text(response, result2);
                    return;
                }
            }
            log.info("#### sysId=" + sysId + ", user_id=" + device.getEnaasUserId());
            String strKey = null;
            strKey = !"2".equals(personType) && "1".equals(isUseEnaas) ? CommonDClient.certIssueRA(d.getUrl(), version, cardtype, cardno, pubkey, admin, d.getDevCardNo(), d.getDevPassword(), device.getEnaasUserId(), sysId) : CommonDClient.certIssue(d.getUrl(), version, cardtype, cardno, pubkey, admin, d.getDevCardNo(), d.getDevPassword());
            result = "";
            log.debug("\u8fd4\u56de\u8bc1\u4e66\u4fe1\u606f\uff1a" + strKey);
            result = strKey.length() > 10 ? "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(strKey) + "\"]" : "[\"" + strKey + "\",\"" + DInfo.getCertIssueErr(strKey) + "\"]";
        }
        catch (Exception e3) {
            log.error(e3.getMessage(), (Throwable)e3);
            result = "[\"-1\";\"\u83b7\u53d6\u5b89\u5168\u5361\u8bc1\u4e66\u5931\u8d25\uff01\"]";
        }
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"scms/devicecontroller/checkCard.do"})
    public void checkCard(String cardNumber, String deviceId, boolean isDelayCard, HttpServletResponse response) {
        String result = "[\"-1\",\"\u7cfb\u7edf\u5f02\u5e38\"]";
        try {
            boolean flag = false;
            SystemConfig sc = this.systemConfigService.getByCode("isCheckDeivce");
            if (sc != null) {
                try {
                    flag = Boolean.parseBoolean(sc.getValue());
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    flag = false;
                }
            }
            if (!flag || this.cardRegisterService.checkCardNumber(cardNumber, null)) {
                String s;
                Device device = this.deviceService.getByCardNO(cardNumber);
                String string = s = device == null ? null : device.getHardNo();
                if (isDelayCard && !cardNumber.equalsIgnoreCase(s)) {
                    result = "[\"-1\",\"\u5b89\u5168\u5361\u53f7\u4e0d\u4e00\u81f4, \u4e0d\u53ef\u5ef6\u671f\uff01\"]";
                    Util.writeUtf8Text(response, result);
                    return;
                }
                result = device != null && !isDelayCard && "3".equalsIgnoreCase(device.getState()) ? "[\"-1\",\"\u8be5\u5361\u5df2\u5199\u5361\uff01\"]" : (device != null && !device.getId().equals(deviceId) ? "[\"-3\",\"\u8be5\u5361\u4e0d\u5c5e\u4e8e\u6b64\u6301\u5361\u4eba\uff01\"]" : "[\"0\"]");
            } else {
                result = "[\"-2\",\"\u8be5\u5361\u672a\u767b\u8bb0\uff0c\u8bf7\u786e\u8ba4\u8be5\u5361\u5c5e\u4e8e\u672c\u7cfb\u7edf\uff01\"]";
            }
        }
        catch (Exception e3) {
            log.error(e3.getMessage(), (Throwable)e3);
        }
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"scms/devicecontroller/toWriteCard.do"})
    public String toWriteCard(String id, String taskId, boolean isDelayCard, String personType, ModelMap map) {
        Device device = this.deviceService.get((Serializable)((Object)id));
        map.addAttribute("commType", (Object)device.getCommType());
        map.addAttribute("id", (Object)id);
        map.addAttribute("taskId", (Object)taskId);
        map.addAttribute("isDelayCard", (Object)Boolean.toString(isDelayCard));
        map.addAttribute("cardType", (Object)device.getType());
        try {
            DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), personType);
            map.addAttribute("isSM2", (Object)dInfo.getIsSM2());
            map.addAttribute("algType", (Object)dInfo.getAlgType());
            map.addAttribute("isWriteGateCert", (Object)dInfo.getGetGWCertSwitch());
            map.addAttribute("isWritePersonInfo", (Object)dInfo.getIsWritePersonInfo());
            map.addAttribute("useThirdCert", (Object)dInfo.getUseThirdCert());
            map.put((Object)"useThirdCert", (Object)dInfo.getUseThirdCert());
            map.put((Object)"isEmpowerKey", (Object)dInfo.getIsEmpowerKey());
            return "scms/manage/default/writecard_new";
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return "error/error";
        }
    }

    @RequestMapping(value={"scms/devicecontroller/writeCard.do"})
    public void writeCard(Device device, boolean patchcard, String taskId, String personType, Variable var, HttpServletResponse response, HttpServletRequest request) {
        log.info("******\u8c03\u7528\u5199\u5361\u65b9\u6cd5");
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        ReturnResult rr = new ReturnResult();
        int operateResult = 0;
        Person p = null;
        try {
            String certificate;
            Device d = this.deviceService.get((Serializable)((Object)device.getId()));
            p = this.userManagerService.queryPersonById(d.getPersonId());
            d.setIccid(device.getIccid());
            d.setHardNo(device.getHardNo());
            d.setSn(device.getSn());
            d.setAlgType(device.getAlgType());
            d.setState("3");
            d.setWriteCardDate(new Date());
            d.setOpenDate(new Date());
            d.setSn2(device.getSn2());
            String videoNO = d.getVideoDeviceNO();
            if (StringUtils.isBlank((CharSequence)videoNO)) {
                d.setVideoDeviceNO(this.getVideoNO());
                d.setVideoDeviceOpenState("1");
            }
            if (StringUtils.isNotBlank((CharSequence)(certificate = device.getCertificate()))) {
                certificate = certificate.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
            }
            d.setCertificate(certificate);
            String certificate2 = device.getCertificate2();
            if (StringUtils.isNotBlank((CharSequence)certificate2)) {
                certificate2 = certificate2.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
            }
            d.setCertificate2(certificate2);
            CertAir certAir = null;
            try {
                this.deviceService.writecard(d);
                this.issuingDoubleCertInAirService.deleteOldCertAirOfCard(d.getHardNo());
                certAir = this.issuingDoubleCertInAirService.addDeviceAir(d, null, p, null, certificate, "pams");
                DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), p.getPersonType());
                if ("1".equals(dInfo.getUseThirdCert())) {
                    PersonJITInfo pki = this.personJITInfoService.findByPersonId(p.getId(), d.getType());
                    pki.setWriteFlag("1");
                    this.personJITInfoService.update(pki);
                }
                log.info("\u8c03\u7528\u8eab\u4efd\u8ba4\u8bc1\u63a5\u53e3\uff0c\u901a\u77e5\u5199\u5361\u6210\u529f");
                if (!"2".equals(personType)) {
                    this.enaasService.cardNotify(device);
                }
            }
            catch (Exception e1) {
                log.error("\u66f4\u65b0\u6570\u636e\u5e93\u5199\u5361\u72b6\u6001\u5931\u8d25", (Throwable)e1);
                String version = "2.0";
                String algtype = "admin";
                DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), personType);
                String cardType = "";
                cardType = DInfo.covCartType(d.getType());
                if ("1".equals(dInfo.getIsSM2())) {
                    version = "3.0";
                    algtype = DInfo.covALgType(d.getAlgType());
                }
                String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
                if (!"2".equals(personType) && "1".equals(isUseEnaas)) {
                    CommonDClient.certRevokeRA(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), this.systemConfigService.getValueByCode("enaas_sysid"));
                } else {
                    CommonDClient.certRevoke(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword());
                }
                if (certAir != null) {
                    certAir.setState("12");
                    certAir.setDeleteFlag("1");
                    this.issuingDoubleCertInAirService.updateCertAir(certAir);
                }
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
                Util.writeUtf8Text(response, Util.toJsonStr(rr));
                return;
            }
            try {
                TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(d, "0");
                this.terminalLogService.save(terminalLog);
                this.terminalReportService.report(terminalLog);
            }
            catch (Exception e2) {
                log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4e0a\u62a5\u5f02\u5e38", (Throwable)e2);
            }
            try {
                if (patchcard) {
                    DeviceHistory deviceHistory = new DeviceHistory();
                    deviceHistory.setCardNumber(d.getHardNo());
                    deviceHistory.setPatchDate(new Date());
                    deviceHistory.setType(d.getType());
                    deviceHistory.setPersonId(d.getPersonId());
                    deviceHistory.setOperator(person.getCode());
                    deviceHistory.setMobile(d.getMobile().getMobile());
                    this.deviceHistoryService.save(deviceHistory);
                }
            }
            catch (Exception e3) {
                log.error("\u8865\u5361\u8bb0\u5f55\u4fdd\u5b58\u5f02\u5e38", (Throwable)e3);
            }
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e4) {
            log.error(e4.getMessage(), (Throwable)e4);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        String note = "\u7528\u6237" + p.getName() + "[" + p.getCode() + "]\u53d1\u5361\u6210\u529f";
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", note, "", "SCMS0302", "\u5b89\u5168\u5361\u7ba1\u7406-\u5199\u5361");
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    private String getVideoNO() {
        String videoNO = "";
        long nanoTime = System.nanoTime();
        String prefix = this.systemConfigPbService.getValueByCode("video_no_prefix");
        String STR_FORMAT = "00000000000000000000";
        DecimalFormat df = new DecimalFormat(STR_FORMAT);
        videoNO = prefix + df.format(nanoTime);
        return videoNO;
    }

    @RequestMapping(value={"scms/devicecontroller/recoveCertOnWriteCardFail.do"})
    public void recoveCertOnWriteCardFail(Device device, boolean patchcard, String taskId, String personType, Variable var, HttpServletResponse response, HttpServletRequest request) {
        HashMap map = new HashMap();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        ReturnResult rr = new ReturnResult();
        boolean operateResult = false;
        boolean state = false;
        Device d = this.deviceService.get((Serializable)((Object)device.getId()));
        device.setType(d.getType());
        String version = "2.0";
        String algtype = "admin";
        DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), personType);
        String cardType = "";
        cardType = DInfo.covCartType(device.getType());
        if ("1".equals(dInfo.getIsSM2())) {
            version = "3.0";
            algtype = DInfo.covALgType(device.getAlgType());
        }
        String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
        if (!"2".equals(personType) && "1".equals(isUseEnaas)) {
            String i = CommonDClient.certRevokeRA(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), this.systemConfigService.getValueByCode("enaas_sysid"));
        } else {
            String caAlg = "1.0";
            if ("2".equals(device.getAlgType())) {
                caAlg = "2.0";
            }
            if ("1".equals(dInfo.getUseThirdCert())) {
                String rst = CommonDClient.certRevokeRAJit(dInfo.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfo.getDevCardNo(), dInfo.getDevPassword());
                log.debug("\u5409\u5927\u64a4\u9500\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + rst);
            } else {
                String i = CommonDClient.certRevoke(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword());
            }
        }
        this.issuingDoubleCertInAirService.deleteCertAirByCardNo(device.getHardNo(), "1", "12");
    }

    @RequestMapping(value={"scms/devicecontroller/toRevokeCert.do"})
    public String toRevokeCard(String id, String taskId, ModelMap map) {
        map.addAttribute("id", (Object)id);
        return "scms/manage/default/revokeCert";
    }

    @RequestMapping(value={"scms/devicecontroller/revokeCert.do"})
    public void revokeCert(String id, String personType, HttpServletResponse response, HttpServletRequest request) {
        Person p;
        int operateResult;
        ReturnResult rr;
        Person person;
        Operator operator;
        block21: {
            HttpSession session = request.getSession();
            operator = (Operator)session.getAttribute("operator");
            person = operator.getPerson();
            rr = new ReturnResult();
            operateResult = 0;
            p = null;
            try {
                Device device = this.deviceService.get((Serializable)((Object)id));
                p = this.userManagerService.queryPersonById(device.getPersonId());
                String version = "2.0";
                String algtype = "admin";
                DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), personType);
                String cardType = "";
                cardType = DInfo.covCartType(device.getType());
                if ("1".equals(dInfo.getIsSM2())) {
                    version = "3.0";
                    algtype = DInfo.covALgType(device.getAlgType());
                }
                String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
                String rst = null;
                if (!"2".equals(personType) && "1".equals(isUseEnaas)) {
                    rst = CommonDClient.certRevokeRA(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), this.systemConfigService.getValueByCode("enaas_sysid"));
                } else {
                    String caAlg = "1.0";
                    if ("2".equals(device.getAlgType())) {
                        caAlg = "2.0";
                    }
                    if ("1".equals(dInfo.getUseThirdCert())) {
                        cardType = DInfo.covCartTypeJIT(device.getType());
                        rst = CommonDClient.certRevokeRAJit(dInfo.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfo.getDevCardNo(), dInfo.getDevPassword());
                    } else if ("2".equals(dInfo.getUseThirdCert())) {
                        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(id);
                        if (pki == null) {
                            pki = this.personKOALInfoService.findByPerson(p.getId(), device.getType());
                        }
                        rst = CommonDClient.certRevokeRA30(dInfo.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfo.getDevCardNo(), dInfo.getDevPassword(), pki.getKoalId(), "admin");
                    } else if ("3".equals(dInfo.getUseThirdCert())) {
                        Map<String, String> result = this.issuingDoubleCertInAirService.revokeCertSPCA(device);
                        rst = "0".equals(result.get("flag")) ? "1" : result.get("msg");
                    } else {
                        if ("4".equals(device.getType()) && "1".equals(dInfo.getIsEmpowerKey())) {
                            cardType = "2";
                        }
                        rst = CommonDClient.certRevoke(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword());
                    }
                }
                if ("1".equals(rst) || "4".equals(rst) || "15".equals(rst)) {
                    PersonJITInfo pki;
                    TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(device, "1");
                    String hardNo = device.getHardNo();
                    device.setState("11");
                    device.setRevocationDate(new Date());
                    device.setRevokeFlag("1");
                    device.setEnaasDesc(device.getIccid());
                    device.setHardNo("");
                    device.setIccid("");
                    device.setImei("");
                    device.setImsi("");
                    device.setCertificate("");
                    device.setCertificate2("");
                    device.setMobile(null);
                    device.setSn("");
                    device.setSn2("");
                    device.setOriginalHardNo(hardNo);
                    this.deviceService.update(device);
                    this.issuingDoubleCertInAirService.deleteCertAirByCardNo(hardNo, "1", "12");
                    if ("1".equals(dInfo.getUseThirdCert()) && (pki = this.personJITInfoService.findByPersonId(p.getId(), device.getType())) != null) {
                        pki.setWriteFlag("0");
                        pki.setApplyFlag("0");
                        this.personJITInfoService.update(pki);
                    }
                    try {
                        this.terminalLogService.save(terminalLog);
                        this.terminalReportService.report(terminalLog);
                    }
                    catch (Exception e2) {
                        log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4e0a\u62a5\u5f02\u5e38", (Throwable)e2);
                    }
                    if (!"2".equals(personType)) {
                        this.enaasService.personDeleteNotify(device);
                    }
                    rr.setRtnCode("0");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                    operateResult = 1;
                    break block21;
                }
                rr.setRtnCode("1");
                if ("3".equals(dInfo.getUseThirdCert())) {
                    rr.setRtnMsg(rst);
                } else {
                    rr.setRtnMsg(DInfo.getCertRevoke(rst));
                }
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), (Throwable)e3);
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        String note = "\u7528\u6237" + p.getName() + "[" + p.getCode() + "]\u64a4\u5361\u6210\u529f";
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", note, "", "SCMS0303", "\u5b89\u5168\u5361\u7ba1\u7406-\u64a4\u5361");
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/devicecontroller/pause.do"})
    public void pause(String[] ids, HttpServletResponse response, HttpServletRequest request) {
        HashMap map = new HashMap();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        ReturnResult rr = new ReturnResult();
        int operateResult = 0;
        try {
            String state = "4";
            this.deviceService.updateState(state, ids);
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/devicecontroller/resume.do"})
    public void resume(String[] ids, HttpServletResponse response, HttpServletRequest request) {
        HashMap map = new HashMap();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        ReturnResult rr = new ReturnResult();
        int operateResult = 0;
        try {
            String state = "3";
            this.deviceService.updateState(state, ids);
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/devicecontroller/revokeapprove.do"})
    public void revokeApprove(String[] ids, HttpServletResponse response, HttpServletRequest request) {
        HashMap map = new HashMap();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        ReturnResult rr = new ReturnResult();
        int operateResult = 0;
        try {
            String state = "3";
            this.deviceService.revokeApprove(ids);
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/devicecontroller/delayCard.do"})
    public void delayCard(String id, HttpServletResponse response, HttpServletRequest request) {
    }

    @RequestMapping(value={"scms/devicecontroller/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Device device = this.deviceService.get((Serializable)((Object)id));
            HashMap<String, Object> mapdevice = new HashMap<String, Object>();
            PersonBean personb = this.userManagerService.getPersonById(device.getPersonId());
            mapdevice.put("id", device.getId());
            mapdevice.put("name", personb.getNAME());
            mapdevice.put("code", personb.getCODE());
            mapdevice.put("depname", personb.getDEPNAME());
            mapdevice.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
            mapdevice.put("iswrite", device.getWriteCardDate() != null);
            mapdevice.put("devicename", device.getName());
            mapdevice.put("type", device.getType());
            mapdevice.put("typeName", this.commonCodePbService.getCodeNameByCode(device.getType(), "2000"));
            mapdevice.put("personType", personb.getPERSONTYPE());
            mapdevice.put("personTypeName", this.commonCodePbService.getCodeNameByCode(personb.getPERSONTYPE(), "PERSON_TYPE"));
            mapdevice.put("commType", device.getCommType());
            CommonCode codeCommType = this.commonCodeService.getByCode(device.getCommType(), "2015");
            mapdevice.put("commTypeName", codeCommType != null ? codeCommType.getName() : "");
            CommonCode code = this.commonCodeService.getByCode(device.getType(), "2000");
            mapdevice.put("type2", code != null ? code.getName() : "");
            map.put("personInfo", Util.toJsonStr(personb));
            Person personE = this.userManagerService.queryPersonById(device.getPersonId());
            map.put("personStr", this.personInfoStr(personE));
            map.put("flag", "1");
            map.put("message", "");
            map.put("obj", mapdevice);
            DInfoCA dInfoCA = this.systemConfigService.getDInfoCAByYYS(device.getCommType(), personb.getPERSONTYPE());
            DInfoCA dInfoCA1 = new DInfoCA(null, null, null, null, null, dInfoCA.getAlgType(), dInfoCA.getIsSM2(), dInfoCA.getType(), dInfoCA.getIsImsi(), dInfoCA.getGetGWCertSwitch(), dInfoCA.getIsWritePersonInfo(), null);
            dInfoCA1.setUseThirdCert(dInfoCA.getUseThirdCert());
            log.debug("\u9879\u76ee\u6807\u7b7e\uff1a" + dInfoCA.getProTag());
            dInfoCA1.setProTag(DInfo.tagSm3(dInfoCA.getProTag()));
            map.put("dInfo", dInfoCA1);
            Util.writeUtf8Text(response, Util.toJsonStr(map));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put("flag", "0");
            map.put("message", "");
            Util.writeUtf8Text(response, Util.toJsonStr(map));
        }
    }

    private String personInfoStr(Person person) {
        String personStr = "name:" + person.getName() + ",sex:" + person.getSex() + ",code:" + person.getCode() + ",dep_id:" + person.getDepId() + ",dep_code:" + person.getDepartment().getCode() + ",dep_name:" + person.getDepartment().getName() + ",identifier:" + person.getIdentifier() + ",grade:" + person.getGrade() + ",position:" + person.getPosition() + ",comm_type:" + person.getCommType() + ",office_phone:" + person.getOfficePhone() + ",mobile:" + person.getMobile() + ",police:" + person.getPolice();
        return personStr;
    }

    @RequestMapping(value={"scms/devicecontroller/test.do"})
    public void test(String mobile) {
        mobile = "13912347891";
        List<Device> device = this.deviceService.getByMobile(mobile);
        HashMap mapdevice = new HashMap();
        log.info(this.deviceService.isWrite("40288cc8419b08ae01419b08da8e0001") + "");
    }

    public DeviceService getDeviceService() {
        return this.deviceService;
    }

    public void setDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @RequestMapping(value={"scms/devicecontroller/toCardInfo.do"})
    public String toCardInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        map.put((Object)"id", (Object)id);
        String updateMobile = this.systemConfigPbService.getValueByCode("updatemobile");
        boolean ableUpdateMobile = false;
        if ("0".equals(updateMobile)) {
            ableUpdateMobile = true;
        }
        map.put((Object)"ableUpdateMobile", (Object)ableUpdateMobile);
        return "scms/manage/default/cardInfo";
    }

    @RequestMapping(value={"scms/devicecontroller/getCardInfo.do"})
    public void getCardInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ArrayList<QueryDeviceBean> list = null;
        QueryDeviceBean deviceBean = null;
        try {
            Device device = this.deviceService.get((Serializable)((Object)id));
            list = new ArrayList<QueryDeviceBean>();
            if (device != null) {
                deviceBean = new QueryDeviceBean();
                if (!"1".equals(device.getRevokeFlag())) {
                    deviceBean.setCardId(device.getId());
                    deviceBean.setStateName(this.commonCodePbService.getCodeNameByCode(device.getState(), "2001"));
                    deviceBean.setState(device.getState());
                    deviceBean.setType(this.commonCodePbService.getCodeNameByCode(device.getType(), "2000"));
                    deviceBean.setPhone(device.getMobile().getMobile());
                    deviceBean.setBingDingType(device.getBindingState());
                    deviceBean.setImei(device.getImei());
                    deviceBean.setImsi(device.getImsi());
                    String bindingState = device.getBindingState();
                    String bindingStateName = " ";
                    if (StringUtils.isNotBlank((CharSequence)bindingState)) {
                        String[] arrayState = bindingState.split(",");
                        for (int j = 0; j < arrayState.length; ++j) {
                            bindingStateName = bindingStateName + this.commonCodePbService.getCodeNameByCode(arrayState[j], "2013") + ",";
                        }
                        bindingStateName = bindingStateName.substring(0, bindingStateName.length() - 1);
                    }
                    deviceBean.setBingDingTypeName(bindingStateName);
                    deviceBean.setTerminalId(device.getTerminal().getId());
                    deviceBean.setTerminalType(device.getTerminal().getTerminaltype());
                    deviceBean.setTerminalTypeName(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminaltype(), "2020"));
                    deviceBean.setTerminalBrand(device.getTerminal().getTerminalband());
                    deviceBean.setTerminalBrandName(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminalband(), "2021"));
                    deviceBean.setTerminalOs(device.getTerminal().getTerminalos());
                    deviceBean.setTerminalOsName(this.commonCodePbService.getCodeNameByCode(device.getTerminal().getTerminalos(), "2022"));
                    deviceBean.setTerminalName(device.getTerminal().getTerminalname());
                    deviceBean.setTerminalVersion(device.getTerminal().getPoliceAppVersion());
                    deviceBean.setEditFlag(this.userManageService.checkCardCanEdit(device.getState()) + "");
                    deviceBean.setCardName(device.getName());
                    list.add(deviceBean);
                }
            }
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u5361\u4fe1\u606f\u5931\u8d25", (Throwable)e2);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(list));
    }

    @RequestMapping(value={"scms/devicecontroller/saveCardInfo.do"})
    public void saveCardInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, String jsonrows) {
        ReturnResult rtnResult = new ReturnResult();
        HashMap<String, String> imeiMap = new HashMap<String, String>();
        HashMap<String, String> imsiMap = new HashMap<String, String>();
        try {
            int i;
            boolean flag = true;
            QueryDeviceBean[] deviceBeanArray = Util.readValue(jsonrows, QueryDeviceBean[].class);
            for (i = 0; i < deviceBeanArray.length; ++i) {
                Mobile tmpMobile;
                boolean returnIsExist;
                String BingDingTypes = deviceBeanArray[i].getBingDingType();
                if (BingDingTypes != null && BingDingTypes.length() > 1 && BingDingTypes.indexOf("0") > -1) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg("\u5f53\u9009\u62e9\u4e0d\u7ed1\u5b9a\u65f6\uff0c\u4e0d\u80fd\u518d\u9009\u62e9\u5176\u4ed6\u7ed1\u5b9a\u9879");
                    flag = false;
                    break;
                }
                Device oldDevice = this.deviceService.get((Serializable)((Object)deviceBeanArray[i].getCardId()));
                if (StringUtils.isNotEmpty((CharSequence)deviceBeanArray[i].getImei()) && !deviceBeanArray[i].getImei().equals(oldDevice.getImei())) {
                    returnIsExist = this.deviceService.isExistImeiOrImsi(deviceBeanArray[i].getImei(), "imei");
                    if (imeiMap.containsKey(deviceBeanArray[i].getImei()) || returnIsExist) {
                        rtnResult.setRtnCode("1");
                        rtnResult.setRtnMsg("imei:" + deviceBeanArray[i].getImei() + "\u5df2\u5b58\u5728");
                        flag = false;
                        break;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)deviceBeanArray[i].getImsi()) && !deviceBeanArray[i].getImsi().equals(oldDevice.getImsi())) {
                    returnIsExist = this.deviceService.isExistImeiOrImsi(deviceBeanArray[i].getImsi(), "imsi");
                    if (imsiMap.containsKey(deviceBeanArray[i].getImsi()) || returnIsExist) {
                        rtnResult.setRtnCode("1");
                        rtnResult.setRtnMsg("imsi:" + deviceBeanArray[i].getImsi() + "\u5df2\u5b58\u5728");
                        flag = false;
                        break;
                    }
                }
                imeiMap.put(deviceBeanArray[i].getImei(), deviceBeanArray[i].getImei());
                imsiMap.put(deviceBeanArray[i].getImsi(), deviceBeanArray[i].getImsi());
                if (oldDevice.getMobile().getMobile().equals(deviceBeanArray[i].getPhone()) || (tmpMobile = this.userManageService.getMobile(deviceBeanArray[i].getPhone())) == null || tmpMobile.getPerson().getId().equals(oldDevice.getPersonId())) continue;
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
                flag = false;
                break;
            }
            if (flag) {
                for (i = 0; i < deviceBeanArray.length; ++i) {
                    Device oldDevice = this.deviceService.get((Serializable)((Object)deviceBeanArray[i].getCardId()));
                    Mobile tmpMobile = this.userManageService.getMobile(deviceBeanArray[i].getPhone());
                    boolean phoneChange = false;
                    if (!oldDevice.getMobile().getMobile().equals(deviceBeanArray[i].getPhone())) {
                        phoneChange = true;
                        if (tmpMobile != null && tmpMobile.getPerson().getId().equals(oldDevice.getPersonId())) {
                            oldDevice.setMobile(tmpMobile);
                        } else {
                            String oldPhone = oldDevice.getMobile().getMobile();
                            oldDevice.getMobile().setMobile(deviceBeanArray[i].getPhone());
                            Person person = this.userManageService.queryPersonById(oldDevice.getPersonId());
                            String personPhone = person.getMobile();
                            if (StringUtils.isNotBlank((CharSequence)personPhone)) {
                                if ((personPhone = personPhone.replace(oldPhone, deviceBeanArray[i].getPhone())).indexOf(deviceBeanArray[i].getPhone()) < 0) {
                                    personPhone = personPhone + "," + deviceBeanArray[i].getPhone();
                                }
                            } else {
                                personPhone = deviceBeanArray[i].getPhone();
                            }
                            person.setMobile(personPhone);
                            this.userManageService.updateUser(person);
                        }
                    }
                    boolean isReportLog = false;
                    if (phoneChange || this.terminalReportService.jubgeIsReportForDevice(deviceBeanArray[i], oldDevice)) {
                        isReportLog = true;
                    }
                    TerminalBean terminalBean = this.terminalService.getById((Serializable)((Object)deviceBeanArray[i].getTerminalId()));
                    terminalBean.setTerminalband(deviceBeanArray[i].getTerminalBrand());
                    terminalBean.setTerminalname(deviceBeanArray[i].getTerminalName());
                    terminalBean.setTerminalos(deviceBeanArray[i].getTerminalOs());
                    terminalBean.setTerminaltype(deviceBeanArray[i].getTerminalType());
                    this.terminalService.update(terminalBean);
                    oldDevice.setBindingState(deviceBeanArray[i].getBingDingType());
                    oldDevice.setImei(deviceBeanArray[i].getImei());
                    oldDevice.setImsi(deviceBeanArray[i].getImsi());
                    oldDevice.setName(deviceBeanArray[i].getCardName());
                    this.deviceService.update(oldDevice);
                    if (!isReportLog) continue;
                    this.terminalReportService.saveAndReportLogForCardInfoEdit(deviceBeanArray[i]);
                }
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58\u5b89\u5168\u5361\u4fe1\u606f\u5931\u8d25", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"scms/devicecontroller/videoState.do"})
    public void videoState(String id, String state, HttpServletResponse response, HttpServletRequest request) {
        HashMap map = new HashMap();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        ReturnResult rr = new ReturnResult();
        int operateResult = 0;
        try {
            this.deviceService.updateVideoState(id, state);
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/scms/devicecontroller/exportDevice.do"})
    public void exportDevice(QueryForm form, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        int operateResult = 0;
        try {
            if (StringUtils.isBlank((CharSequence)form.getDepId())) {
                form.setControlDeps(operator.getControlDeps());
            }
            form.setControlPolice(operator.getControlPolices());
            List<Device> list = this.deviceService.query(form, page);
            for (Device device : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                Person personb = this.userManagerService.queryPersonById(device.getPersonId());
                map.put("id", device.getId());
                map.put("name", Util.cvNameByPersonType(personb.getName(), personb.getPersonType()));
                map.put("code", personb.getCode());
                map.put("depname", personb.getDepartment().getName());
                map.put("identifier", personb.getIdentifier());
                map.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
                CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
                map.put("cardtype", cardtype != null ? cardtype.getName() : "");
                CommonCode usetype = this.commonCodeService.getByCode(device.getUseType(), "useType");
                map.put("usetype", usetype != null ? usetype.getName() : "");
                CommonCode commType = this.commonCodeService.getByCode(device.getCommType(), "2015");
                map.put("commType", commType != null ? commType.getName() : "");
                map.put("devicename", device.getName());
                map.put("cardid", device.getHardNo());
                listmap.add(map);
            }
            String[] rowkeys = new String[]{"name", "code", "depname", "identifier", "mobile", "cardtype", "usertype", "commType", "cardid"};
            String[] heanderNames = new String[]{"\u59d3\u540d", "\u8b66\u53f7", "\u5355\u4f4d\u540d\u79f0", "\u8eab\u4efd\u8bc1\u53f7", "\u624b\u673a\u53f7", "\u5361\u7c7b\u578b", "\u9002\u7528\u7c7b\u578b", "\u8fd0\u8425\u5546", "\u5361\u786c\u4ef6\u7f16\u53f7"};
            operateResult = 1;
            String fileName = Util.toUtf8String("\u5b89\u5168\u5361\u4fe1\u606f") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelUtil.exportExcel("\u5b89\u5168\u5361\u4fe1\u606f", (OutputStream)response.getOutputStream(), "001", listmap, heanderNames, rowkeys);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"scms/devicecontroller/certApplyJit.do"})
    public void certApplyRAJit(String deviceId, HttpServletResponse response) {
        String result = null;
        try {
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            Person p = this.userManageService.queryPersonById(device.getPersonId());
            DInfo d = this.systemConfigService.getDInfoByYYS(device.getCommType(), p.getPersonType());
            PersonJITInfo pki = this.personJITInfoService.findByPersonId(p.getId(), device.getType());
            String cardType = DInfo.covCartTypeJIT(device.getType());
            String userInfoId = "";
            if (pki != null) {
                if ("1".equals(pki.getWriteFlag())) {
                    result = "[\"-1\",\"\u5b89\u5168\u5361\u7c7b\u578b\u5df2\u7533\u8bf7\uff0c\u9700\u8981\u5148\u64a4\u5361\u624d\u80fd\u518d\u6b21\u7533\u8bf7\uff01\"]";
                    Util.writeUtf8Text(response, result);
                    return;
                }
                if ("1".equals(pki.getApplyFlag())) {
                    result = "[\"success\",\"\u6ce8\u518c\u5409\u5927\u7528\u6237\u6210\u529f\uff01\"]";
                    Util.writeUtf8Text(response, result);
                    return;
                }
                if (pki.getUserInfoId() != null) {
                    userInfoId = pki.getUserInfoId();
                }
            } else {
                String userInfoIdExist = this.personJITInfoService.getUserInfoIdByPersonId(p.getId());
                if (userInfoIdExist != null) {
                    userInfoId = userInfoIdExist;
                }
            }
            String version = "3.0";
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("xingming", p.getName());
            userMap.put("xingbie", p.getSex());
            userMap.put("shenfenzhenghao", p.getIdentifier());
            userMap.put("jingzhong", p.getPolice());
            userMap.put("renzhi", "0001");
            userMap.put("gongzuogangwei", "0803");
            userMap.put("zhiji", p.getPosition());
            userMap.put("organ_id", p.getDepartment().getCode());
            String userInfo = Util.toJsonStr(userMap);
            String caAlg = "1.0";
            if ("2".equals(d.getAlgType())) {
                caAlg = "2.0";
            }
            String rst = CommonDClient.certApplyRAJit(d.getUrl(), version, caAlg, cardType, p.getName(), p.getIdentifier(), p.getDepartment().getCode(), userInfo, userInfoId, d.getDevCardNo(), d.getDevPassword());
            log.debug("\u5409\u5927\u6ce8\u518c\u63a5\u53e3\u8fd4\u56de:" + rst);
            String[] rstArr = rst.split("#");
            if (rstArr[0] != null && rstArr.length >= 2) {
                result = "[\"success\",\"\u6ce8\u518c\u5409\u5927\u7528\u6237\u6210\u529f\uff01\"]";
                if (pki != null) {
                    pki.setAuthCode(rstArr[0]);
                    pki.setRefCode(rstArr[1]);
                    pki.setApplyFlag("1");
                    this.personJITInfoService.update(pki);
                } else {
                    PersonJITInfo jitInfo = new PersonJITInfo();
                    jitInfo.setAuthCode(rstArr[0]);
                    jitInfo.setRefCode(rstArr[1]);
                    if ("".equals(userInfoId) && rstArr.length == 3) {
                        jitInfo.setUserInfoId(rstArr[2]);
                    } else {
                        jitInfo.setUserInfoId(userInfoId);
                    }
                    jitInfo.setPersonId(p.getId());
                    jitInfo.setCreateDate(new Date());
                    jitInfo.setCardType(device.getType());
                    jitInfo.setApplyFlag("1");
                    this.personJITInfoService.save(jitInfo);
                }
            } else if (rstArr[0] != null) {
                result = "[\"" + rstArr[0] + "\",\"" + DInfo.getErrCertApplyRA(rstArr[0]) + "\"]";
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            result = "[\"-1\",\"\u6ce8\u518c\u5409\u5927\u7528\u6237\u5931\u8d25\uff01\"]";
        }
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"scms/devicecontroller/certIssueJIT.do"})
    public void certDownlaodRAJit(String version, String cardtype, String cardno, String pubkey, String admin, String personType, boolean isDelayCard, String deviceId, String commType, HttpServletResponse response) {
        String result;
        String strKey = null;
        try {
            String[] cerArr;
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            Person p = this.userManageService.queryPersonById(device.getPersonId());
            DInfo d = this.systemConfigService.getDInfoByYYS(commType, p.getPersonType());
            PersonJITInfo pki = this.personJITInfoService.findByPersonId(p.getId(), device.getType());
            String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
            String sysId = this.systemConfigService.getValueByCode("enaas_sysid");
            if (isDelayCard) {
                String version2 = "3.0";
                String algtype = "admin";
                DInfo dInfo = this.systemConfigService.getDInfoByYYS(commType, p.getPersonType());
                String cardType = "";
                cardType = DInfo.covCartTypeJIT(device.getType());
                if ("1".equals(dInfo.getIsSM2())) {
                    version2 = "3.0";
                    algtype = DInfo.covALgType(device.getAlgType());
                }
                String caAlg = "1.0";
                if ("2".equals(device.getAlgType())) {
                    caAlg = "2.0";
                }
                String rst = null;
                if (!"2".equals(personType) && "1".equals(isUseEnaas)) {
                    rst = CommonDClient.certRevokeRA(dInfo.getUrl(), version2, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), sysId);
                } else {
                    rst = CommonDClient.certRevokeRAJit(dInfo.getUrl(), "3.0", cardType, cardno, caAlg, dInfo.getDevCardNo(), dInfo.getDevPassword());
                    log.debug("\u5409\u5927\u64a4\u9500\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + rst);
                }
                if ("1".equals(rst) || "4".equals(rst) || "15".equals(rst)) {
                    this.issuingDoubleCertInAirService.deleteCertAirByCardNo(cardno, "1", "12");
                    try {
                        TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(device, "1");
                        this.terminalLogService.save(terminalLog);
                        this.terminalReportService.report(terminalLog);
                    }
                    catch (Exception e2) {
                        log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4e0a\u62a5\u5f02\u5e38", (Throwable)e2);
                    }
                } else {
                    String result2 = "[\"-1\",\"" + DInfo.getCertRevoke(rst) + "\"]";
                    Util.writeUtf8Text(response, result2);
                    return;
                }
            }
            log.info("#### sysId=" + sysId + ", user_id=" + device.getEnaasUserId());
            String caAlg = "1.0";
            if ("2".equals(d.getAlgType())) {
                caAlg = "2.0";
            }
            String certType = "1";
            String certCount = "0" + cardtype + "00";
            strKey = CommonDClient.certDownlaodRAJit(d.getUrl(), "3.0", cardtype, cardno, pubkey, caAlg, pki.getAuthCode(), pki.getRefCode(), p.getName(), p.getIdentifier(), p.getDepartment().getCode(), d.getDevCardNo(), d.getDevPassword());
            log.debug("\u5409\u5927\u83b7\u53d6\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + strKey);
            String str = "-----BEGIN CERTIFICATE-----\nMIICzzCCAnSgAwIBAgIQGSQMzPy7oxHxTMCAGjDcKDAMBggqgRzPVQGDdQUAMEgxCzAJBgNVBAYT\nAkNOMQswCQYDVQQIDAI1MjELMAkGA1UEBwwCMDAxCzAJBgNVBAcMAjAwMRIwEAYDVQQDDAlZREda\nQ0FfU00wHhcNMTcwNTA2MDcwNDI2WhcNMTgwNTA2MDcwNDI2WjBzMQswCQYDVQQGEwJDTjELMAkG\nA1UECAwCNTIxCzAJBgNVBAcMAjAwMQswCQYDVQQHDAIwMDELMAkGA1UECgwCMDAxCzAJBgNVBAsM\nAjAwMQswCQYDVQQLDAIwMDEWMBQGA1UEAwwNdGVzdGRldmljZTAwMzBZMBMGByqGSM49AgEGCCqB\nHM9VAYItA0IABCdwtVvT3G5V1uu/gV4J82HQ7N3h80KV4qBUN3NHcrcnE37RD7zUarHLYYzlMYVQ\nVfaM4FwbXH19belfPdmGrpejggERMIIBDTAdBgNVHQ4EFgQUwG5oF+AJZakUGKgtxYYT4hg+Wo4w\nHwYDVR0jBBgwFoAUN/4ukA5sSNQ3VG9JlAYzIQBWK6kwDAYDVR0TBAUwAwEBADBiBgNVHR8EWzBZ\nMDagNKAypDAwLjELMAkGA1UEBhMCQ04xEDAOBgNVBAsMB0FERDFDUkwxDTALBgNVBAMMBGNybDAw\nH6AdoBuGGWh0dHA6Ly8xMjcuMC4wLjEvY3JsMC5jcmwwCwYDVR0PBAQDAgbAMBIGCCpWmcL0cQAB\nBAYTBDA4MDMwEgYIKlaZwvRxAAQEBhMEMDAwMTAQBggqVpnC9HEAAwQEEwIxOTASBggqVpnC9HEA\nAgQGEwQwMTMxMAwGCCqBHM9VAYN1BQADRwAwRAIgDULbgQ6J0ddz6Rlix/7oUsDN9v0M+njctyN1\nnQbkhWkCIESktYV2MKodciD8Ly8BJaYFYzgWELmyFulFsr+vV+KE\n-----END CERTIFICATE-----#-----BEGIN CERTIFICATE-----\nMIIC0TCCAnSgAwIBAgIQEw8yU3nN1vGfbLSiRpy8YTAMBggqgRzPVQGDdQUAMEgxCzAJBgNVBAYT\nAkNOMQswCQYDVQQIDAI1MjELMAkGA1UEBwwCMDAxCzAJBgNVBAcMAjAwMRIwEAYDVQQDDAlZREda\nQ0FfU00wHhcNMTcwNTA2MDcwNDI2WhcNMTgwNTA2MDcwNDI2WjBzMQswCQYDVQQGEwJDTjELMAkG\nA1UECAwCNTIxCzAJBgNVBAcMAjAwMQswCQYDVQQHDAIwMDELMAkGA1UECgwCMDAxCzAJBgNVBAsM\nAjAwMQswCQYDVQQLDAIwMDEWMBQGA1UEAwwNdGVzdGRldmljZTAwMzBZMBMGByqGSM49AgEGCCqB\nHM9VAYItA0IABOvuUazHGCCG5zfOTpnFvSLYCZz7afYOSQgcqc1fhdFLXh1M0KPNv5Erbn3LphLc\n63t6sq6XuJo2+uQA801EELSjggERMIIBDTALBgNVHQ8EBAMCBDAwHQYDVR0OBBYEFOIq2MBozCCG\nhWlY6WebeRTsTBoQMB8GA1UdIwQYMBaAFDf+LpAObEjUN1RvSZQGMyEAViupMAwGA1UdEwQFMAMB\nAQAwYgYDVR0fBFswWTA2oDSgMqQwMC4xCzAJBgNVBAYTAkNOMRAwDgYDVQQLDAdBREQxQ1JMMQ0w\nCwYDVQQDDARjcmwwMB+gHaAbhhlodHRwOi8vMTI3LjAuMC4xL2NybDAuY3JsMBIGCCpWmcL0cQAB\nBAYTBDA4MDMwEgYIKlaZwvRxAAQEBhMEMDAwMTAQBggqVpnC9HEAAwQEEwIxOTASBggqVpnC9HEA\nAgQGEwQwMTMxMAwGCCqBHM9VAYN1BQADSQAwRgIhAN9oVIHaZMat/l3f2ctDIK8n3rh3gs5tcVVS\n7qGMddXHAiEA0Xs3Z2qZr7FNMT6zwOdev0lYWbdUwr/EeAS8WK+AIfw=\n-----END CERTIFICATE-----#AAAAAQAAAQEAAAEAqSJh331gL994ePuaA0gCaakiYd99YC/feHj7mgNIAmlWg5dVuvMCl28ZIG3m2wepzTl1jtVWj+VflcP1gHQvSQAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOvuUazHGCCG5zfOTpnFvSLYCZz7afYOSQgcqc1fhdFLAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABeHUzQo82/kStufcumEtzre3qyrpe4mjb65ADzTUQQtAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAw2jd/YaBWtBkjqb0wxlvsJGKmeKMxWbHBLtNCXVJNvIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHmNi2u0gwIOqkpvYFsnDTnux18sRIux7WRk4erHIsbzhCa5BeBhpUzvIUvE3EqaDOeFl9OZvwM6n819/+OwbkIAAAAQY5FFKj70GfCNbP3LhMKjug==";
            result = "";
            result = strKey.length() > 10 ? ((cerArr = strKey.split("#")).length >= 3 ? "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + cerArr[0].replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(cerArr[0]) + "\",\"" + cerArr[1].replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(cerArr[1]) + "\",\"" + cerArr[2].replaceAll("\r|\n", "") + "\"]" : "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(strKey) + "\"]") : "[\"" + strKey + "\",\"" + DInfo.certDownlaodRAJitErr(strKey) + "\"]";
        }
        catch (Exception e3) {
            log.error("\u5409\u5927\u83b7\u53d6\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + strKey);
            log.error(e3.getMessage(), (Throwable)e3);
            result = "[\"-1\",\"\u83b7\u53d6\u5b89\u5168\u5361\u8bc1\u4e66\u5931\u8d25\uff01\"]";
        }
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"scms/devicecontroller/revokeCertJIT.do"})
    public void certRevokeRAJit(String id, String personType, HttpServletResponse response, HttpServletRequest request) {
        int operateResult;
        ReturnResult rr;
        Person person;
        Operator operator;
        block10: {
            HttpSession session = request.getSession();
            operator = (Operator)session.getAttribute("operator");
            person = operator.getPerson();
            rr = new ReturnResult();
            operateResult = 0;
            try {
                Device device = this.deviceService.get((Serializable)((Object)id));
                Person p = this.userManageService.queryPersonById(device.getPersonId());
                PersonJITInfo pki = this.personJITInfoService.findByPersonId(p.getId(), device.getType());
                String version = "2.0";
                String algtype = "admin";
                DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), p.getPersonType());
                String cardType = "";
                cardType = DInfo.covCartTypeJIT(device.getType());
                if ("1".equals(dInfo.getIsSM2())) {
                    version = "3.0";
                    algtype = DInfo.covALgType(device.getAlgType());
                }
                String caAlg = "1.0";
                if ("2".equals(device.getAlgType())) {
                    caAlg = "2.0";
                }
                String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
                String rst = null;
                if (!"2".equals(personType) && "1".equals(isUseEnaas)) {
                    rst = CommonDClient.certRevokeRA(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), this.systemConfigService.getValueByCode("enaas_sysid"));
                } else {
                    rst = CommonDClient.certRevokeRAJit(dInfo.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfo.getDevCardNo(), dInfo.getDevPassword());
                    log.debug("\u5409\u5927\u64a4\u9500\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + rst);
                }
                if ("1".equals(rst) || "4".equals(rst) || "15".equals(rst)) {
                    pki.setWriteFlag("0");
                    pki.setApplyFlag("0");
                    this.personJITInfoService.update(pki);
                    TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(device, "1");
                    String hardNo = device.getHardNo();
                    device.setState("11");
                    device.setRevocationDate(new Date());
                    device.setRevokeFlag("1");
                    device.setHardNo("");
                    device.setIccid("");
                    device.setImei("");
                    device.setImsi("");
                    device.setCertificate("");
                    device.setMobile(null);
                    device.setSn("");
                    device.setOriginalHardNo(hardNo);
                    this.deviceService.update(device);
                    this.issuingDoubleCertInAirService.deleteCertAirByCardNo(device.getHardNo(), "1", "12");
                    try {
                        this.terminalLogService.save(terminalLog);
                        this.terminalReportService.report(terminalLog);
                    }
                    catch (Exception e2) {
                        log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4e0a\u62a5\u5f02\u5e38", (Throwable)e2);
                    }
                    if (!"2".equals(personType)) {
                        this.enaasService.personDeleteNotify(device);
                    }
                    rr.setRtnCode("0");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                    operateResult = 1;
                    break block10;
                }
                rr.setRtnCode("1");
                rr.setRtnMsg(DInfo.getCertRevoke(rst));
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), (Throwable)e3);
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/devicecontroller/certApplyRAKR.do"})
    public void certApplyRA30(String deviceId, HttpServletResponse response) {
        String result = null;
        try {
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            Person p = this.userManageService.queryPersonById(device.getPersonId());
            DInfo d = this.systemConfigService.getDInfoByYYS(device.getCommType(), p.getPersonType());
            PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(deviceId);
            if (pki != null && StringUtils.isNotBlank((CharSequence)pki.getKoalId())) {
                result = "[\"success\",\"\u6ce8\u518c\u683c\u5c14\u7528\u6237\u6210\u529f\uff01\"]";
                Util.writeUtf8Text(response, result);
                return;
            }
            String version = "3.0";
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("USER_IDNO", p.getIdentifier());
            userMap.put("USER_NAME", p.getName());
            userMap.put("USER_CREY", "00");
            userMap.put("USER_POTYPE", CertUserInfoTrans.getUserPoType(p.getPolice()));
            userMap.put("CERT_TYPE", CertUserInfoTrans.getCertType(p.getPersonType(), d.getType()));
            userMap.put("USER_POSLEVEL", CertUserInfoTrans.getPosLevel(p.getPosition()));
            userMap.put("USER_POS", CertUserInfoTrans.getPos(p.getGrade(), p.getPosition()));
            userMap.put("USER_WORK", CertUserInfoTrans.getWork());
            userMap.put("USER_ORG_CODE", p.getDepartment().getCode());
            String userInfo = Util.toJsonStr(userMap);
            String caAlg = "1.0";
            if ("2".equals(d.getAlgType())) {
                caAlg = "2.0";
            }
            String rst = CommonDClient.certApplyRA30(d.getUrl(), version, userInfo, caAlg, d.getDevCardNo(), d.getDevPassword());
            log.debug("\u683c\u5c14\u6ce8\u518c\u63a5\u53e3\u8fd4\u56de:" + rst);
            String[] rstArr = rst.split("#");
            if (rstArr[0] != null && rstArr.length >= 1 && "userId".equals(rstArr[0])) {
                result = "[\"success\",\"\u6ce8\u518c\u683c\u5c14\u7528\u6237\u6210\u529f\uff01\"]";
                this.personKOALInfoService.save(p.getId(), deviceId, rstArr[1], "", device.getType());
            } else if (rstArr[0] != null) {
                result = "[\"" + rstArr[0] + "\",\"" + DInfo.getCertApplyRAKR(rstArr[0]) + "\"]";
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            result = "[\"-1\",\"\u6ce8\u518c\u683c\u5c14\u7528\u6237\u5931\u8d25\uff01\"]";
        }
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"scms/devicecontroller/reviewRAKR.do"})
    public void reviewRA30(String deviceId, HttpServletResponse response) {
        String result = null;
        try {
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            Person p = this.userManageService.queryPersonById(device.getPersonId());
            DInfo d = this.systemConfigService.getDInfoByYYS(device.getCommType(), p.getPersonType());
            PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(deviceId);
            if (pki != null && "1".equals(pki.getState())) {
                result = "[\"success\",\"\u5ba1\u6279\u683c\u5c14\u7528\u6237\u6210\u529f\uff01\"]";
                Util.writeUtf8Text(response, result);
                return;
            }
            String version = "3.0";
            String reviewType = "2";
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("", this.person.getCode());
            String userInfo = Util.toJsonStr(userMap);
            String caAlg = "1.0";
            if ("2".equals(d.getAlgType())) {
                caAlg = "2.0";
            }
            String rst = CommonDClient.reviewRA30(d.getUrl(), version, pki.getKoalId(), reviewType, caAlg, d.getDevCardNo(), d.getDevPassword());
            log.debug("\u683c\u5c14\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de:" + rst);
            if ("1".equals(rst)) {
                this.personKOALInfoService.updateState(pki.getId());
                result = "[\"success\",\"\u5ba1\u6279\u683c\u5c14\u7528\u6237\u6210\u529f\uff01\"]";
            } else {
                result = "[\"" + rst + "\",\"" + DInfo.getReviewRAKR(rst) + "\"]";
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            result = "[\"-1\",\"\u683c\u5c14\u5ba1\u6279\u7528\u6237\u5931\u8d25\uff01\"]";
        }
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"scms/devicecontroller/certIssueKR.do"})
    public void certIssueRA30(String version, String cardtype, String cardno, String pubkey, String admin, String decardno, String password, String personType, boolean isDelayCard, String deviceId, String commType, HttpServletResponse response) {
        String result;
        try {
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            Person p = this.userManageService.queryPersonById(device.getPersonId());
            DInfo d = this.systemConfigService.getDInfoByYYS(commType, p.getPersonType());
            PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(deviceId);
            if (pki == null) {
                pki = this.personKOALInfoService.findByPerson(p.getId(), device.getType());
            }
            String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
            String sysId = this.systemConfigService.getValueByCode("enaas_sysid");
            if (isDelayCard) {
                String caAlg = "1.0";
                if ("2".equals(d.getAlgType())) {
                    caAlg = "2.0";
                }
                String rst = null;
                int day = 1825;
                rst = CommonDClient.postponeApplyRA30(d.getUrl(), "3.0", caAlg, d.getDevCardNo(), d.getDevPassword(), pki.getKoalId(), day);
                if (!"1".equals(rst)) {
                    String result2 = "[\"-1\",\"\u7533\u8bf7\u5ef6\u671f\u7528\u6237\u8bc1\u4e66\u5931\u8d25-" + DInfo.getCertRevoke(rst) + "\"]";
                    Util.writeUtf8Text(response, result2);
                    return;
                }
                rst = CommonDClient.postponeReviewRA30(d.getUrl(), "3.0", pki.getKoalId(), caAlg, d.getDevCardNo(), d.getDevPassword());
                if (!"1".equals(rst)) {
                    String result3 = "[\"-1\",\"\u5ef6\u671f\u8bc1\u4e66\u5ba1\u6838\u5931\u8d25-" + DInfo.getCertRevoke(rst) + "\"]";
                    Util.writeUtf8Text(response, result3);
                    return;
                }
            }
            log.info("#### sysId=" + sysId + ", user_id=" + device.getEnaasUserId());
            String strKey = null;
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("USER_IDNO", p.getIdentifier());
            userMap.put("USER_NAME", p.getName());
            userMap.put("USER_ORG_CODE", p.getDepartment().getCode());
            String userInfo = Util.toJsonStr(userMap);
            if (!"2".equals(personType) && "1".equals(isUseEnaas)) {
                strKey = CommonDClient.certIssueRA(d.getUrl(), version, cardtype, cardno, pubkey, admin, d.getDevCardNo(), d.getDevPassword(), device.getEnaasUserId(), sysId);
            } else {
                String caAlg = "1.0";
                if ("2".equals(d.getAlgType())) {
                    caAlg = "2.0";
                }
                strKey = isDelayCard ? CommonDClient.postPoneCertRA30(d.getUrl(), "3.0", cardtype, cardno, caAlg, d.getDevCardNo(), d.getDevPassword(), pki.getKoalId()) : CommonDClient.certIssueRA30New(d.getUrl(), "3.0", cardtype, cardno, pubkey, caAlg, d.getDevCardNo(), d.getDevPassword(), pki.getKoalId(), userInfo);
                log.debug("\u683c\u5c14\u83b7\u53d6\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + strKey);
            }
            result = "";
            if (strKey.length() > 10) {
                String[] cerArr = strKey.split("#");
                if (isDelayCard) {
                    this.issuingDoubleCertInAirService.deleteCertAirByCardNo(cardno, "1", "12");
                }
                result = cerArr.length >= 3 ? "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + cerArr[0].replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(cerArr[0]) + "\",\"" + cerArr[1].replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(cerArr[1]) + "\",\"" + cerArr[2].replaceAll("\r|\n", "") + "\"]" : "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(strKey) + "\"]";
            } else {
                result = "[\"" + strKey + "\",\"" + DInfo.getCertIssueErr(strKey) + "\"]";
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            result = "[\"-1\",\"\u83b7\u53d6\u5b89\u5168\u5361\u8bc1\u4e66\u5931\u8d25\uff01\"]";
        }
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"scms/devicecontroller/revokeCertKR.do"})
    public void revokeCertRA30(String id, String personType, HttpServletResponse response, HttpServletRequest request) {
        int operateResult;
        ReturnResult rr;
        Person person;
        Operator operator;
        block12: {
            HttpSession session = request.getSession();
            operator = (Operator)session.getAttribute("operator");
            person = operator.getPerson();
            rr = new ReturnResult();
            operateResult = 0;
            try {
                Device device = this.deviceService.get((Serializable)((Object)id));
                Person p = this.userManageService.queryPersonById(device.getPersonId());
                PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(id);
                if (pki == null) {
                    pki = this.personKOALInfoService.findByPerson(p.getId(), device.getType());
                }
                String version = "2.0";
                String algtype = "admin";
                DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), p.getPersonType());
                String cardType = "";
                cardType = DInfo.covCartType(device.getType());
                if ("1".equals(dInfo.getIsSM2())) {
                    version = "3.0";
                    algtype = DInfo.covALgType(device.getAlgType());
                }
                String caAlg = "1.0";
                if ("2".equals(device.getAlgType())) {
                    caAlg = "2.0";
                }
                String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
                String rst = null;
                if (!"2".equals(personType) && "1".equals(isUseEnaas)) {
                    rst = CommonDClient.certRevokeRA(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), this.systemConfigService.getValueByCode("enaas_sysid"));
                } else {
                    rst = CommonDClient.certRevokeRA30(dInfo.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfo.getDevCardNo(), dInfo.getDevPassword(), pki.getKoalId(), "admin");
                    log.debug("\u683c\u5c14\u64a4\u9500\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + rst);
                }
                if ("1".equals(rst) || "4".equals(rst) || "15".equals(rst)) {
                    if (pki != null) {
                        this.personKOALInfoService.delete(pki);
                    }
                    TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(device, "1");
                    String hardNo = device.getHardNo();
                    device.setState("11");
                    device.setRevocationDate(new Date());
                    device.setRevokeFlag("1");
                    device.setHardNo("");
                    device.setIccid("");
                    device.setImei("");
                    device.setImsi("");
                    device.setCertificate("");
                    device.setMobile(null);
                    device.setSn("");
                    device.setOriginalHardNo(hardNo);
                    this.deviceService.update(device);
                    this.issuingDoubleCertInAirService.deleteCertAirByCardNo(device.getHardNo(), "1", "12");
                    try {
                        this.terminalLogService.save(terminalLog);
                        this.terminalReportService.report(terminalLog);
                    }
                    catch (Exception e2) {
                        log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4e0a\u62a5\u5f02\u5e38", (Throwable)e2);
                    }
                    if (!"2".equals(personType)) {
                        this.enaasService.personDeleteNotify(device);
                    }
                    rr.setRtnCode("0");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                    operateResult = 1;
                    break block12;
                }
                rr.setRtnCode("1");
                rr.setRtnMsg(DInfo.getCertRevoke(rst));
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), (Throwable)e3);
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/devicecontroller/recoveCertOnWriteCardFailKR.do"})
    public void recoveCertOnWriteCardFailRA30(Device device, boolean patchcard, String taskId, String personType, Variable var, HttpServletResponse response, HttpServletRequest request) {
        HashMap map = new HashMap();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        ReturnResult rr = new ReturnResult();
        boolean operateResult = false;
        boolean state = false;
        Device d = this.deviceService.get((Serializable)((Object)device.getId()));
        Person p = this.userManageService.queryPersonById(device.getPersonId());
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(device.getId());
        if (pki == null) {
            pki = this.personKOALInfoService.findByPerson(p.getId(), device.getType());
        }
        device.setType(d.getType());
        String version = "2.0";
        String algtype = "admin";
        DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), personType);
        String cardType = "";
        cardType = DInfo.covCartType(device.getType());
        if ("1".equals(dInfo.getIsSM2())) {
            version = "3.0";
            algtype = DInfo.covALgType(device.getAlgType());
        }
        String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
        String caAlg = "1.0";
        if ("2".equals(device.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = null;
        if (!"2".equals(personType) && "1".equals(isUseEnaas)) {
            rst = CommonDClient.certRevokeRA(dInfo.getUrl(), version, cardType, device.getHardNo(), algtype, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), this.systemConfigService.getValueByCode("enaas_sysid"));
        } else {
            rst = CommonDClient.certRevokeRA30(dInfo.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfo.getDevCardNo(), dInfo.getDevPassword(), pki.getKoalId(), "admin");
            log.debug("\u683c\u5c14\u64a4\u9500\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + rst);
            if (pki != null) {
                this.personKOALInfoService.delete(pki);
            }
        }
        this.issuingDoubleCertInAirService.deleteCertAirByCardNo(device.getHardNo(), "1", "12");
    }

    @RequestMapping(value={"scms/devicecontroller/applySPCA.do"})
    public void applySPCA(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="cardno") String cardno, HttpServletResponse response) {
        try {
            Map<String, String> applyResult = this.issuingDoubleCertInAirService.applySPCA4Page(deviceId, cardno);
            Util.writeUtf8JSON(response, Util.toJsonStr(applyResult));
        }
        catch (Exception e2) {
            log.error("\u7b80\u6613CA, \u5b9e\u4f53\u8ba4\u8bc1\u9519\u8bef", (Throwable)e2);
        }
    }

    @RequestMapping(value={"scms/devicecontroller/downloadSPCA.do"})
    public void downloadSPCA(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="cardno") String cardno, @RequestParam(value="pubkey", required=false) String pubKey, @RequestParam(value="p10") String p10, @RequestParam(value="isDelayCard") boolean isDelayCard, HttpServletResponse response) {
        try {
            Map<String, String> downloadResult = this.issuingDoubleCertInAirService.downloadCertSPCA(deviceId, pubKey, p10, cardno, isDelayCard, "pams");
            if (downloadResult.get("flag").equals("1")) {
                Util.writeUtf8Text(response, "[\"fail\", \"" + downloadResult.get("msg") + "\"]");
            } else {
                Util.writeUtf8Text(response, downloadResult.get("certs"));
            }
        }
        catch (Exception e2) {
            log.error("\u7b80\u6613CA, \u4e0b\u8f7d\u8bc1\u4e66\u5f02\u5e38", (Throwable)e2);
        }
    }

    @RequestMapping(value={"scms/devicecontroller/revokeSPCA.do"})
    public void revokeSPCA(Device device, HttpServletResponse response) {
        try {
            Map<String, String> revokeResult = this.issuingDoubleCertInAirService.revokeCertSPCA(device);
            Util.writeUtf8JSON(response, Util.toJsonStr(revokeResult));
        }
        catch (Exception e2) {
            log.error("\u7b80\u6613CA, \u64a4\u9500\u8bc1\u4e66\u5f02\u5e38", (Throwable)e2);
        }
    }

    @RequestMapping(value={"scms/devicecontroller/renew.do"})
    public void renewCert(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="pubkey", required=false) String pubkey, @RequestParam(value="p10", required=false) String p10, @RequestParam(value="cardNo") String cardNo, @RequestParam(value="isUpdateKey") String isUpdateKey, HttpServletResponse response) {
        log.debug("deviceId : {}\ncardNo:{} ", (Object)deviceId, (Object)cardNo);
        CertInAirRtn rtn = null;
        try {
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            if (device == null) {
                Util.writeUtf8Text(response, "[\"fail\", \"\u8bbe\u5907\u4e0d\u5b58\u5728\"]");
                return;
            }
            if (device.getHardNo() == null || !device.getHardNo().equals(cardNo)) {
                Util.writeUtf8Text(response, "[\"fail\", \"\u5361\u53f7\u5f02\u5e38\"]");
                return;
            }
            rtn = this.issuingDoubleCertInAirService.renew(device.getHardNo(), pubkey, p10, isUpdateKey, false, "pams");
            if ("0".equals(rtn.getFlag())) {
                Util.writeUtf8Text(response, rtn.getCerts());
            } else {
                Util.writeUtf8Text(response, "[\"fail\", \"" + CertInAirRtn.FLAG_MAP.get(rtn.getFlag()) + "\"]");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            if (rtn != null) {
                Util.writeUtf8Text(response, "[\"fail\", \"" + CertInAirRtn.FLAG_MAP.get(rtn.getFlag()) + "\"]");
            }
            Util.writeUtf8Text(response, "[\"fail\", \"\u7cfb\u7edf\u5f02\u5e38\"]");
        }
    }
}

