/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.CertInAirRtn;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.control.DeviceController;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.IssuingDoubleCertInAirService;
import com.xdja.pams.scms.util.Strings;
import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Scope(value="session")
public class DeviceControllerNew {
    private static final Logger log = LoggerFactory.getLogger(DeviceController.class);
    @Autowired
    private IssuingDoubleCertInAirService issuingDoubleCertInAirService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DeviceService deviceService;

    @RequestMapping(value={"scms/devicecontroller/new/apply.do"})
    public void apply(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="cardNo") String cardNo, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "0");
        try {
            if (Strings.isEmpty(deviceId) || Strings.isEmpty(cardNo)) {
                map.put("msg", "\u53c2\u6570\u5f02\u5e38");
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                return;
            }
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            if (device == null) {
                map.put("msg", "\u5361\u4fe1\u606f\u5f02\u5e38");
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                return;
            }
            Person person = this.userManageService.getPersonByPersonId(device.getPersonId());
            if (person == null) {
                map.put("msg", "\u4eba\u5458\u4fe1\u606f\u5f02\u5e38");
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                return;
            }
            CertInAirRtn rtn = this.issuingDoubleCertInAirService.apply2(device.getType(), cardNo, person.getIdentifier(), device.getMobile().getMobile());
            if (!"0".equals(rtn.getFlag())) {
                map.put("msg", CertInAirRtn.FLAG_MAP.get(rtn.getFlag()));
            } else {
                map.put("flag", "1");
                map.put("msg", "\u5b9e\u4f53\u8ba4\u8bc1\u6210\u529f");
                map.put("dn", DInfo.getDnReqBuf(rtn.getDn()).replaceAll(",", "#"));
            }
        }
        catch (Exception e2) {
            log.error("\u5b9e\u4f53\u8ba4\u8bc1\u5931\u8d25{}", (Object)e2.getMessage(), (Object)e2);
            map.put("msg", "\u5b9e\u4f53\u8ba4\u8bc1\u5931\u8d25");
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/devicecontroller/new/downloadcert.do"})
    public void downloadCert(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="cardNo") String cardNo, @RequestParam(value="pubKey", required=false) String pubKey, @RequestParam(value="p10", required=false) String p10, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "0");
        try {
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            if (device == null) {
                map.put("msg", "\u5361\u4fe1\u606f\u5f02\u5e38");
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                return;
            }
            Person person = this.userManageService.getPersonByPersonId(device.getPersonId());
            if (person == null) {
                map.put("msg", "\u4eba\u5458\u4fe1\u606f\u5f02\u5e38");
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                return;
            }
            CertInAirRtn rtn = this.issuingDoubleCertInAirService.certDownload2(device.getType(), deviceId, cardNo, p10, pubKey, person.getIdentifier(), null, null, device.getMobile().getMobile(), device.getCommType(), device.getTerminal().getTerminalos(), device.getTerminal().getTerminalband(), device.getTerminal().getTerminaltype(), "pams");
            if (!"0".equals(rtn.getFlag())) {
                map.put("msg", CertInAirRtn.FLAG_MAP.get(rtn.getFlag()));
            } else {
                map.put("flag", "1");
                map.put("msg", "\u4e0b\u8f7d\u8bc1\u4e66\u6210\u529f");
                map.put("certs", rtn.getCerts());
            }
        }
        catch (Exception e2) {
            log.error("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25", (Throwable)e2);
            map.put("msg", "\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25");
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/devicecontroller/new/delayCert.do"})
    public void delayCert(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="cardNo") String cardNo, @RequestParam(value="pubKey", required=false) String pubKey, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "0");
        try {
            if (Strings.isEmpty(deviceId) || Strings.isEmpty(cardNo)) {
                map.put("msg", "\u53c2\u6570\u5f02\u5e38");
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                return;
            }
            CertInAirRtn rtn = this.issuingDoubleCertInAirService.delayForPage(deviceId, pubKey, cardNo);
            if (!"0".equals(rtn.getFlag())) {
                map.put("msg", CertInAirRtn.FLAG_MAP.get(rtn.getFlag()));
            } else {
                map.put("flag", "1");
                map.put("msg", "\u8bc1\u4e66\u5ef6\u671f\u6210\u529f");
                map.put("certs", rtn.getCerts().replaceAll("\r|\n", ""));
            }
        }
        catch (Exception e2) {
            log.error("\u8bc1\u4e66\u5ef6\u671f\u5931\u8d25", (Throwable)e2);
            map.put("msg", "\u8bc1\u4e66\u5ef6\u671f\u5931\u8d25");
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/devicecontroller/new/revokeCert.do"})
    public void revokeCert(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="cardNo") String cardNo, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "0");
        try {
            if (Strings.isEmpty(deviceId) || Strings.isEmpty(cardNo)) {
                map.put("msg", "\u53c2\u6570\u5f02\u5e38");
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                return;
            }
            CertInAirRtn rtn = this.issuingDoubleCertInAirService.revokeForPage(deviceId, cardNo);
            if (!"0".equals(rtn.getFlag())) {
                map.put("msg", CertInAirRtn.FLAG_MAP.get(rtn.getFlag()));
            } else {
                map.put("flag", "1");
                map.put("msg", "\u64a4\u9500\u6210\u529f");
            }
        }
        catch (Exception e2) {
            log.error("\u8bc1\u4e66\u64a4\u9500\u5931\u8d25", (Throwable)e2);
            map.put("msg", "\u8bc1\u4e66\u64a4\u9500\u5931\u8d25");
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/devicecontroller/new/renew.do"})
    public void renewCert(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="pubkey", required=false) String pubkey, @RequestParam(value="p10", required=false) String p10, @RequestParam(value="cardNo") String cardNo, @RequestParam(value="isUpdateKey") String isUpdateKey, HttpServletResponse response) {
        log.debug("deviceId : {}\ncardNo:{} ", (Object)deviceId, (Object)cardNo);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "0");
        CertInAirRtn rtn = null;
        try {
            Device device = this.deviceService.get((Serializable)((Object)deviceId));
            if (device == null) {
                map.put("msg", "\u8bbe\u5907\u4e0d\u5b58\u5728");
                Util.writeUtf8Text(response, Util.toJsonStr(map));
                return;
            }
            if (device.getHardNo() == null || !device.getHardNo().equals(cardNo)) {
                map.put("msg", "\u8bbe\u5907\u4e0d\u5b58\u5728");
                Util.writeUtf8Text(response, Util.toJsonStr(map));
                return;
            }
            rtn = this.issuingDoubleCertInAirService.renew(device.getHardNo(), pubkey, p10, isUpdateKey, true, "pams");
            if ("0".equals(rtn.getFlag())) {
                Util.writeUtf8Text(response, rtn.getCerts());
            } else {
                map.put("msg", CertInAirRtn.FLAG_MAP.get(rtn.getFlag()));
                Util.writeUtf8Text(response, Util.toJsonStr(map));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            if (rtn != null) {
                map.put("msg", CertInAirRtn.FLAG_MAP.get(rtn.getFlag()));
                Util.writeUtf8Text(response, Util.toJsonStr(map));
            }
            map.put("msg", "\u7cfb\u7edf\u5f02\u5e38");
            Util.writeUtf8Text(response, Util.toJsonStr(map));
        }
    }
}

