/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.CertAirExt;
import com.xdja.pams.scms.bean.CertInAirForm;
import com.xdja.pams.scms.service.IssuingDoubleCertInAirService;
import com.xdja.pams.scms.util.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class IssuingDoubleCertInAirAdminControl
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(IssuingDoubleCertInAirAdminControl.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private IssuingDoubleCertInAirService issuingDoubleCertInAirService;

    @RequestMapping(value={"scms/issuingCertInAir/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/issuingCertInAir/getList.do"})
    public void getList(HttpServletRequest request, HttpServletResponse response, PageParam pageParam, CertInAirForm form) {
        Page page = new Page(pageParam.getPage(), pageParam.getRows());
        form.setControlDeps(this.getControlDeps(request));
        List<CertAirExt> list = this.issuingDoubleCertInAirService.listCertAir(form, page);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", page.getTotal());
        map.put("rows", list);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/issuingCertInAir/getCertAir.do"})
    public String getCertAir(CertInAirForm form, ModelMap map) {
        CertAirExt ext = this.issuingDoubleCertInAirService.getCertAir(form);
        map.addAttribute("apply", (Object)ext);
        return "scms/certinair/default/applyInfo";
    }

    @RequestMapping(value={"scms/issuingCertInAir/setState.do"})
    public void setState(HttpServletRequest request, HttpServletResponse response, CertInAirForm form) {
        Map<Object, Object> map = new HashMap<String, String>();
        if (form == null || Strings.isEmpty(form.getId()) || Strings.isEmpty(form.getState())) {
            map.put("state", "1");
            map.put("msg", "\u8bf7\u6c42\u5f02\u5e38");
        } else if (form.getReason() != null && form.getReason().length() > 50) {
            map.put("state", "1");
            map.put("msg", "\u8f93\u5165\u7684\u5185\u5bb9\u8fc7\u957f\u4e86");
        } else {
            map = this.issuingDoubleCertInAirService.changeState(form);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }
}

