/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.TerminalPersonBean;
import com.xdja.pams.scms.service.TerminalPersonService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class TerminalGrantController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(TerminalGrantController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private TerminalPersonService terminalPersonService;

    @RequestMapping(value={"scms/terminalgrantcontroller/index"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/terminalgrantcontroller/addPage"})
    public String showAddTerManPage(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, String id) {
        map.put((Object)"terId", (Object)id);
        return "scms/terminalgrant/default/grant";
    }

    @RequestMapping(value={"scms/terminalgrantcontroller/query"})
    public void getTerminalPerson(HttpServletRequest request, HttpServletResponse response, TerminalPersonBean terminalPersonBean, PageParam pageParam) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Page page = new Page();
            page.setRp(Integer.parseInt(pageParam.getRows()));
            page.setPage(Integer.parseInt(pageParam.getPage()));
            List<TerminalPersonBean> terminalPersonList = this.terminalPersonService.getTerminalPerson(terminalPersonBean, page);
            map.put("total", page.getTotal());
            map.put("rows", terminalPersonList);
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/terminalgrantcontroller/save"})
    public void saveTerminalPerson(HttpServletRequest request, HttpServletResponse response, TerminalPersonBean terminalPersonBean) {
        ReturnResult returnResult = new ReturnResult();
        try {
            TerminalPersonBean queryBean = new TerminalPersonBean();
            queryBean.setId(terminalPersonBean.getId());
            List<TerminalPersonBean> terminalPersonBeanList = this.terminalPersonService.getTerminalPerson(queryBean, null);
            if (terminalPersonBeanList.isEmpty()) {
                returnResult.setRtnCode("1");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + "\u65e0\u6cd5\u53d1\u653e\u8be5\u7ec8\u7aef");
            } else {
                TerminalPersonBean updateBean = terminalPersonBeanList.get(0);
                updateBean.setPersonId(terminalPersonBean.getPersonId());
                this.terminalPersonService.update(updateBean);
                returnResult.setRtnCode("0");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(returnResult));
    }

    @RequestMapping(value={"scms/terminalgrantcontroller/update"})
    public void updateTerminalPerson(HttpServletRequest request, HttpServletResponse response, TerminalPersonBean terminalPersonBean) {
        ReturnResult returnResult = new ReturnResult();
        try {
            List<TerminalPersonBean> terminalPersonBeanList = this.terminalPersonService.getTerminalPerson(terminalPersonBean, null);
            if (terminalPersonBeanList.isEmpty()) {
                returnResult.setRtnCode("1");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + "\u4e0d\u5b58\u5728\u8be5\u7ec8\u7aef,\u65e0\u6cd5\u64a4\u9500\u53d1\u653e");
            } else {
                TerminalPersonBean tpb = terminalPersonBeanList.get(0);
                tpb.setPersonId("");
                this.terminalPersonService.update(tpb);
                returnResult.setRtnCode("0");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(returnResult));
    }
}

