/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.TerminalBean;
import com.xdja.pams.scms.service.TerminalService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class TerminalTestController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(TerminalTestController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private TerminalService terminalService;

    @RequestMapping(value={"scms/terminaltestcontroller/index"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/terminaltestcontroller/addPage"})
    public String showAddTerPage(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        return "scms/terminaltest/default/addTestTerminal";
    }

    @RequestMapping(value={"scms/terminaltestcontroller/toEditPage"})
    public String toEditPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String terminalId) {
        TerminalBean terminalBean = new TerminalBean();
        terminalBean.setId(terminalId);
        List<TerminalBean> terminalBeanList = this.terminalService.getTerminal(terminalBean, null);
        if (!terminalBeanList.isEmpty()) {
            TerminalBean tBean = terminalBeanList.get(0);
            map.put((Object)"terminal", (Object)tBean);
        }
        return "scms/terminaltest/default/editTestTerminal";
    }

    @RequestMapping(value={"/scms/terminaltestcontroller/query.do"})
    public void getTerminal(HttpServletRequest request, HttpServletResponse response, TerminalBean terminalBean, PageParam pageParam) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Page page = new Page();
            page.setRp(Integer.parseInt(pageParam.getRows()));
            page.setPage(Integer.parseInt(pageParam.getPage()));
            List<TerminalBean> terminalList = this.terminalService.getTerminal(terminalBean, page);
            map.put("total", page.getTotal());
            map.put("rows", terminalList);
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/terminaltestcontroller/save"})
    public void saveTerminal(HttpServletRequest request, HttpServletResponse response, TerminalBean terminalBean) {
        ReturnResult returnResult = new ReturnResult();
        try {
            this.terminalService.save(terminalBean);
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(returnResult));
    }

    @RequestMapping(value={"scms/terminaltestcontroller/update"})
    public void updateTerminal(HttpServletRequest request, HttpServletResponse response, TerminalBean terminalBean) {
        ReturnResult returnResult = new ReturnResult();
        try {
            this.terminalService.update(terminalBean);
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(returnResult));
    }

    @RequestMapping(value={"scms/terminaltestcontroller/delete"})
    public void deleteTerminal(HttpServletRequest request, HttpServletResponse response, String terminalId) {
        ReturnResult returnResult = new ReturnResult();
        try {
            if (!StringUtils.isEmpty((CharSequence)terminalId)) {
                TerminalBean terminalBean = new TerminalBean();
                terminalBean.setId(terminalId);
                this.terminalService.delete(terminalBean);
                returnResult.setRtnCode("0");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                returnResult.setRtnCode("1");
                returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(returnResult));
    }
}

