/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.bean.TerminalBean;
import com.xdja.pams.scms.dao.TerminalDao;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.service.TerminalService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalServiceImpl
implements TerminalService {
    @Autowired
    private TerminalDao terminalDao;
    @Autowired
    private CommonCodeService commonCodeService;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public TerminalBean save(TerminalBean terminalBean) {
        Terminal terminal = new Terminal();
        BeanUtils.copyProperties((Object)terminalBean, (Object)terminal);
        terminal = this.terminalDao.save(terminal);
        BeanUtils.copyProperties((Object)terminal, (Object)terminalBean);
        return terminalBean;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(TerminalBean terminalBean) {
        Terminal terminal = this.terminalDao.getById((Serializable)((Object)terminalBean.getId()));
        BeanUtils.copyProperties((Object)terminalBean, (Object)terminal);
        this.terminalDao.update(terminal);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(TerminalBean terminalBean) {
        Terminal terminal = new Terminal();
        BeanUtils.copyProperties((Object)terminalBean, (Object)terminal);
        this.terminalDao.delete(terminal);
    }

    public TerminalDao getTerminalDao() {
        return this.terminalDao;
    }

    public void setTerminalDao(TerminalDao terminalDao) {
        this.terminalDao = terminalDao;
    }

    @Override
    public TerminalBean getById(Serializable id) {
        TerminalBean terminalBean = new TerminalBean();
        Terminal terminal = this.terminalDao.getById(id);
        BeanUtils.copyProperties((Object)terminal, (Object)terminalBean);
        return terminalBean;
    }

    @Override
    public List<TerminalBean> getTerminal(TerminalBean terminalBean, Page page) {
        Terminal terminal = new Terminal();
        BeanUtils.copyProperties((Object)terminalBean, (Object)terminal);
        List<Terminal> terminalList = this.terminalDao.getTerminal(terminal, page);
        ArrayList<TerminalBean> terminalBeanList = new ArrayList<TerminalBean>();
        TerminalBean tmb = null;
        for (Terminal tm : terminalList) {
            tmb = new TerminalBean();
            BeanUtils.copyProperties((Object)tm, (Object)tmb);
            CommonCode cardBand = this.commonCodeService.getByCode(tmb.getTerminalband(), "2021");
            tmb.setTerminalband_name(cardBand.getName());
            CommonCode cardOs = this.commonCodeService.getByCode(tmb.getTerminalos(), "2022");
            tmb.setTerminalos_name(cardOs.getName());
            CommonCode cardType = this.commonCodeService.getByCode(tmb.getTerminaltype(), "2020");
            tmb.setTerminaltype_name(cardType.getName());
            CommonCode cardResult = this.commonCodeService.getByCode(tmb.getTestresult(), "testresult");
            tmb.setTestresult_name(cardResult.getName());
            terminalBeanList.add(tmb);
        }
        return terminalBeanList;
    }
}

