/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sms.service.impl;

import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.sms.dao.MessageDao;
import com.xdja.pams.sms.entity.Message;
import com.xdja.pams.sms.service.MessageService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MessageServiceImpl
implements MessageService {
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private ResourceBundleMessageSource message;

    @Override
    public List<Message> query(Message msg, Page page) {
        return this.messageDao.queryPage(msg, page);
    }

    @Override
    public Message save(Message msg) {
        return this.messageDao.save(msg);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(Message msg) {
        this.messageDao.update(msg);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(Serializable id) {
        Message msg = this.messageDao.get(id);
        this.messageDao.delete(msg);
    }

    @Override
    public Message get(Serializable id) {
        return this.messageDao.get(id);
    }

    @Override
    public boolean checkMessage(String mc, String id) {
        Message msg = this.messageDao.getByMc(mc);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            if (msg == null) {
                return false;
            }
            return !msg.getId().equals(id);
        }
        return msg != null;
    }

    @Override
    public List<Map<String, Object>> queryMessageListForSelect(Message msg) {
        Page page = new Page();
        page.setPage(1);
        page.setRp(50);
        List<Message> messageList = this.query(msg, page);
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HashMap<String, String> msgMap0 = new HashMap<String, String>();
        msgMap0.put("id", "");
        msgMap0.put("code", "");
        msgMap0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        listmap.add(msgMap0);
        for (Message message : messageList) {
            HashMap<String, String> messageMap = new HashMap<String, String>();
            messageMap.put("id", message.getId());
            messageMap.put("code", message.getId());
            messageMap.put("name", message.getMc());
            messageMap.put("content", message.getNr());
            listmap.add(messageMap);
        }
        return listmap;
    }

    public MessageDao getMessageDao() {
        return this.messageDao;
    }

    public void setMessageDao(MessageDao messageDao) {
        this.messageDao = messageDao;
    }
}

