/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sso.service.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.PinYin4j;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.sso.bean.SynDepartment;
import com.xdja.pams.sso.bean.SynDevice;
import com.xdja.pams.sso.bean.SynDeviceDblCert;
import com.xdja.pams.sso.bean.SynPerson;
import com.xdja.pams.sso.bean.SynPersonpwd;
import com.xdja.pams.sso.bean.SynQueryParam;
import com.xdja.pams.sso.bean.SynRst;
import com.xdja.pams.sso.service.BasicInfoSynchronizeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class BasicInfoSynchronizeServiceImpl
implements BasicInfoSynchronizeService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DeviceService deviceService;
    private static Logger log = Logger.getLogger(BasicInfoSynchronizeServiceImpl.class);

    @Override
    public SynRst basicInfoSyn(SynQueryParam synQueryParam, String type) {
        SynRst<Object> synRst = new SynRst<Object>();
        if (synQueryParam == null) {
            log.error((Object)"\u4eba\u5458\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror"));
            return synRst;
        }
        String lastTime = synQueryParam.getLastTime();
        String endLastTime = synQueryParam.getEndLastTime();
        String pageNo = synQueryParam.getPageNo();
        String pageSize = synQueryParam.getPageSize();
        synRst.setTime(new Date().getTime());
        int i_pageNo = 0;
        int i_pageSize = 0;
        try {
            i_pageNo = Integer.parseInt(pageNo);
        }
        catch (NumberFormatException e2) {
            log.error((Object)"\u540c\u6b65\u5931\u8d25\uff0c\u9875\u7801\u6709\u8bef\uff0c\u6700\u5c0f\u4e3a1", (Throwable)e2);
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.pageno") + ":" + pageNo);
            return synRst;
        }
        if (i_pageNo < 1) {
            i_pageNo = 1;
        }
        try {
            i_pageSize = Integer.parseInt(pageSize);
        }
        catch (NumberFormatException e3) {
            log.error((Object)e3.getMessage(), (Throwable)e3);
        }
        int i_configPageSize = 0;
        String configPageSize = this.systemConfigService.getValueByCode("syninfo_pagesize");
        try {
            i_configPageSize = Integer.parseInt(configPageSize);
        }
        catch (NumberFormatException e4) {
            log.error((Object)e4.getMessage(), (Throwable)e4);
        }
        if (i_pageSize > i_configPageSize) {
            i_pageSize = i_configPageSize;
        }
        if (i_pageSize < 1) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.pagesize"));
            log.error((Object)"\u540c\u6b65\u5931\u8d25\uff0c\u6bcf\u9875\u6570\u91cf\u914d\u7f6e\u6709\u8bef");
            return synRst;
        }
        Page page = new Page();
        page.setPage(i_pageNo);
        page.setRp(i_pageSize);
        long l_lastTime = 0L;
        long l_endLastTime = 0L;
        try {
            l_lastTime = Long.parseLong(lastTime);
        }
        catch (NumberFormatException e5) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.updatetime") + ":" + lastTime);
            log.error((Object)("\u540c\u6b65\u5931\u8d25\uff0c\u66f4\u65b0\u65f6\u95f4\u6233\u975e\u6570\u5b57\u683c\u5f0f\uff1a" + lastTime), (Throwable)e5);
            return synRst;
        }
        if (StringUtils.isNotBlank((CharSequence)endLastTime)) {
            try {
                l_endLastTime = Long.parseLong(endLastTime);
            }
            catch (NumberFormatException e6) {
                l_endLastTime = 0L;
            }
        }
        if ("0".equals(type)) {
            List<SynPerson> list = this.querySynPerson(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("00".equals(type)) {
            List<SynPersonpwd> list = this.querySynPersonpwd(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
        } else if ("1".equals(type)) {
            List<SynDepartment> list = this.querySynDep(l_lastTime, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("2".equals(type)) {
            List<SynDevice> list = this.querySynDevice(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("4".equals(type)) {
            List<SynDeviceDblCert> list = this.querySynDeviceDblCert(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.datatype"));
        }
        synRst.setResult("0", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.success"));
        return synRst;
    }

    private List<SynPerson> querySynPerson(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonList(synQueryParam, page);
        return this.setPersongList(list);
    }

    private List<SynPerson> querySynPersonWithoutFujing(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonListWithoutFuJing(synQueryParam, page);
        return this.setPersongList(list);
    }

    private List<SynPerson> setPersongList(List<Person> list) {
        ArrayList<SynPerson> synlist = new ArrayList<SynPerson>();
        for (Person person : list) {
            SynPerson synPerson = new SynPerson();
            synPerson.setId(person.getId());
            synPerson.setName(person.getName());
            synPerson.setMobile(person.getMobiledList());
            synPerson.setComm_type(person.getCommType());
            synPerson.setSmobile(person.getsMobile());
            synPerson.setCode(person.getCode());
            synPerson.setIdentifier(person.getIdentifier());
            synPerson.setDep_code(person.getDepartment().getCode());
            synPerson.setDep_id(person.getDepId());
            synPerson.setGrade(person.getGrade());
            synPerson.setPosition(person.getPosition());
            synPerson.setSeq(Long.toString(person.getOrderField()));
            synPerson.setNote(person.getNote());
            synPerson.setN_last_update_time(Long.toString(person.getTimestamp()));
            synPerson.setDelete_flag(person.getFlag());
            synPerson.setSex(person.getSex());
            synPerson.setPolice(person.getPolice());
            synPerson.setOffice_phone(person.getOfficePhone());
            String nbs = null;
            try {
                nbs = person.getNameBriefSpell();
                if (StringUtils.isBlank((CharSequence)nbs)) {
                    nbs = PinYin4j.getNameSimplicityWithPolyphone(person.getName());
                }
            }
            catch (Exception e2) {
                log.error((Object)(person.getId() + ":" + person.getName()), (Throwable)e2);
                throw new RuntimeException(e2);
            }
            synPerson.setName_brief_spell(nbs);
            synPerson.setPersonType(person.getPersonType());
            synPerson.setJxFlag(person.getJxFlag());
            synPerson.setDisplay_flag(person.getDisplayState());
            synlist.add(synPerson);
        }
        return synlist;
    }

    private List<SynPersonpwd> querySynPersonpwdWithoutFujing(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonListWithoutFuJing(synQueryParam, page);
        return this.setPersonpwdList(list);
    }

    private List<SynPersonpwd> querySynPersonpwd(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonList(synQueryParam, page);
        return this.setPersonpwdList(list);
    }

    private List<SynPersonpwd> setPersonpwdList(List<Person> list) {
        ArrayList<SynPersonpwd> synlist = new ArrayList<SynPersonpwd>();
        for (Person person : list) {
            SynPersonpwd synPerson = new SynPersonpwd();
            synPerson.setId(person.getId());
            synPerson.setName(person.getName());
            synPerson.setMobile(person.getMobiledList());
            synPerson.setComm_type(person.getCommType());
            synPerson.setSmobile(person.getsMobile());
            synPerson.setCode(person.getCode());
            synPerson.setIdentifier(person.getIdentifier());
            synPerson.setDep_code(person.getDepartment().getCode());
            synPerson.setDep_id(person.getDepId());
            synPerson.setGrade(person.getGrade());
            synPerson.setPosition(person.getPosition());
            synPerson.setSeq(Long.toString(person.getOrderField()));
            synPerson.setNote(person.getNote());
            synPerson.setN_last_update_time(Long.toString(person.getTimestamp()));
            synPerson.setDelete_flag(person.getFlag());
            synPerson.setSex(person.getSex());
            synPerson.setPolice(person.getPolice());
            synPerson.setOffice_phone(person.getOfficePhone());
            String nbs = person.getNameBriefSpell();
            if (StringUtils.isBlank((CharSequence)nbs)) {
                nbs = PinYin4j.getNameSimplicityWithPolyphone(person.getName());
            }
            synPerson.setName_brief_spell(nbs);
            synPerson.setPersonType(person.getPersonType());
            synPerson.setPassword(person.getPassword());
            synPerson.setJxFlag(person.getJxFlag());
            synlist.add(synPerson);
        }
        return synlist;
    }

    public List<SynDepartment> querySynDep(long lastTime, Page page) {
        List<Department> list = this.depManageService.querySynDepList(lastTime, page);
        ArrayList<SynDepartment> synlist = new ArrayList<SynDepartment>();
        for (Department dep : list) {
            SynDepartment synDep = new SynDepartment();
            synDep.setId(dep.getId());
            synDep.setName(dep.getName());
            synDep.setCode(dep.getCode());
            synDep.setContact(dep.getLinkman());
            synDep.setPhone(dep.getPhone());
            synDep.setGrage(dep.getLevel());
            synDep.setParent_id(dep.getParentID());
            synDep.setSeq(Long.toString(dep.getOrderField()));
            synDep.setDep_abb(dep.getNameAbbr());
            synDep.setNote(dep.getNote());
            synDep.setAmount(Integer.toString(dep.getCount()));
            synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
            synDep.setDelete_flag(dep.getFlag());
            synlist.add(synDep);
        }
        return synlist;
    }

    @Override
    public List<SynDepartment> querySynDep(long lastTime, String rootDepId, Page page) {
        List<Department> list = this.depManageService.querySynDepList(lastTime, rootDepId, page);
        ArrayList<SynDepartment> synlist = new ArrayList<SynDepartment>();
        for (Department dep : list) {
            SynDepartment synDep = new SynDepartment();
            synDep.setId(dep.getId());
            synDep.setName(dep.getName());
            synDep.setCode(dep.getCode());
            synDep.setContact(dep.getLinkman());
            synDep.setPhone(dep.getPhone());
            synDep.setGrage(dep.getLevel());
            synDep.setParent_id(dep.getParentID());
            synDep.setSeq(Long.toString(dep.getOrderField()));
            synDep.setDep_abb(dep.getNameAbbr());
            synDep.setNote(dep.getNote());
            synDep.setAmount(Integer.toString(dep.getCount()));
            synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
            synDep.setDelete_flag(dep.getFlag());
            synlist.add(synDep);
        }
        return synlist;
    }

    public List<SynDevice> querySynDevice(SynQueryParam synQueryParam, Page page) {
        List<Device> list = this.deviceService.querySynDeviceList(synQueryParam, page);
        ArrayList<SynDevice> synList = new ArrayList<SynDevice>();
        for (Device device : list) {
            SynDevice synDevice = new SynDevice();
            synDevice.setId(device.getId());
            synDevice.setCard_id(device.getIccid());
            synDevice.setName(device.getName());
            synDevice.setFlag(device.getFlag());
            synDevice.setState(device.getState());
            synDevice.setType(device.getType());
            synDevice.setImei(device.getImei());
            synDevice.setImsi(device.getImsi());
            synDevice.setLock_state(device.getLockState());
            synDevice.setExamine_date(device.getExamineDate());
            synDevice.setOpen_date(device.getOpenDate());
            synDevice.setPause_date(device.getPauseDate());
            synDevice.setRevocation_date(device.getRevocationDate());
            synDevice.setWrite_card_date(device.getWriteCardDate());
            synDevice.setSn(device.getSn());
            synDevice.setAlg_type(device.getAlgType());
            synDevice.setCertificate(device.getCertificate());
            if (null != device.getMobile()) {
                synDevice.setMobile(device.getMobile().getMobile());
            }
            synDevice.setPerson_id(device.getPersonId());
            synDevice.setN_last_update_time(device.getTimestamp());
            synDevice.setDelete_flag("1".equals(device.getRevokeFlag()) ? "1" : "0");
            synDevice.setUseType(device.getUseType());
            synList.add(synDevice);
        }
        return synList;
    }

    public List<SynDeviceDblCert> querySynDeviceDblCert(SynQueryParam synQueryParam, Page page) {
        List<Device> list = this.deviceService.querySynDeviceList(synQueryParam, page);
        ArrayList<SynDeviceDblCert> synList = new ArrayList<SynDeviceDblCert>();
        for (Device device : list) {
            SynDeviceDblCert synDevice = new SynDeviceDblCert();
            synDevice.setId(device.getId());
            synDevice.setCard_id(device.getIccid());
            synDevice.setName(device.getName());
            synDevice.setFlag(device.getFlag());
            synDevice.setState(device.getState());
            synDevice.setType(device.getType());
            synDevice.setImei(device.getImei());
            synDevice.setImsi(device.getImsi());
            synDevice.setLock_state(device.getLockState());
            synDevice.setExamine_date(device.getExamineDate());
            synDevice.setOpen_date(device.getOpenDate());
            synDevice.setPause_date(device.getPauseDate());
            synDevice.setRevocation_date(device.getRevocationDate());
            synDevice.setWrite_card_date(device.getWriteCardDate());
            synDevice.setSn(device.getSn());
            synDevice.setAlg_type(device.getAlgType());
            synDevice.setCertificate(device.getCertificate());
            if (null != device.getMobile()) {
                synDevice.setMobile(device.getMobile().getMobile());
            }
            synDevice.setPerson_id(device.getPersonId());
            synDevice.setN_last_update_time(device.getTimestamp());
            synDevice.setDelete_flag("1".equals(device.getRevokeFlag()) ? "1" : "0");
            synDevice.setUseType(device.getUseType());
            synDevice.setSn2(device.getSn2());
            synDevice.setCertificate2(device.getCertificate2());
            synList.add(synDevice);
        }
        return synList;
    }

    public UserManageService getUserManageService() {
        return this.userManageService;
    }

    public void setUserManageService(UserManageService userManageService) {
        this.userManageService = userManageService;
    }

    public DepManageService getDepManageService() {
        return this.depManageService;
    }

    public void setDepManageService(DepManageService depManageService) {
        this.depManageService = depManageService;
    }

    public SystemConfigPbService getSystemConfigService() {
        return this.systemConfigService;
    }

    public void setSystemConfigService(SystemConfigPbService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }
}

