/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sxmsapi.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.login.service.LoginService;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.sxmsapi.bean.PCLoginReq;
import com.xdja.pams.sxmsapi.bean.RoleBean;
import com.xdja.pams.sxmsapi.bean.SxmsResult;
import com.xdja.pams.sxmsapi.service.SxmsApiService;
import com.xdja.pams.upms.entity.GprsMenu;
import com.xdja.pams.upms.service.UserPowerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class SxmsApiServiceImpl
implements SxmsApiService {
    private static final Logger log = LoggerFactory.getLogger(SxmsApiServiceImpl.class);
    @Autowired
    private UserManageService userManage;
    @Autowired
    private LoginService loginService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private UserPowerService userPowerService;

    @Override
    public SxmsResult pcLogin(PCLoginReq pcLoginReq) throws Exception {
        SxmsResult rst = new SxmsResult();
        rst.setFlag("1");
        if (StringUtils.isBlank((CharSequence)pcLoginReq.getUsername())) {
            rst.setMessage("\u7528\u6237\u540d\u4e3a\u7a7a\uff01");
            return rst;
        }
        if (StringUtils.isBlank((CharSequence)pcLoginReq.getPassword())) {
            rst.setMessage("\u5bc6\u7801\u4e3a\u7a7a\uff01");
            return rst;
        }
        if (StringUtils.isBlank((CharSequence)pcLoginReq.getPcId())) {
            rst.setMessage("PC\u7aef\u552f\u4e00\u6807\u8bc6\u4e3a\u7a7a\uff01");
            return rst;
        }
        Person person = this.userManage.getUserByCode(pcLoginReq.getUsername());
        if (person == null) {
            rst.setMessage("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01");
            return rst;
        }
        if (!Md5PwdEncoder.getInstance().encodePassword(pcLoginReq.getPassword()).equals(person.getPassword())) {
            rst.setMessage("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01");
            return rst;
        }
        if (this.loginService.judgeIslock(person)) {
            rst.setMessage(MessageManager.getProMessage(this.message, "login.error.msg.lock"));
            return rst;
        }
        if (this.loginService.judgeIslock(person)) {
            rst.setMessage(MessageManager.getProMessage(this.message, "login.error.msg.lock"));
            return rst;
        }
        if (this.loginService.judgeIslock2(person)) {
            rst.setMessage(MessageManager.getProMessage(this.message, "login.error.msg.lock2"));
            return rst;
        }
        person.setPcId(pcLoginReq.getPcId());
        this.userManage.updateClientLoginTime(person);
        this.systemLogService.saveLoginLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), "", 1, "", "", "");
        rst.setFlag("0");
        HashMap<String, Object> personBean = new HashMap<String, Object>();
        personBean.put("id", person.getId());
        personBean.put("code", person.getCode());
        personBean.put("name", person.getName());
        personBean.put("depName", person.getDepartment().getName());
        personBean.put("depId", person.getDepartment().getId());
        personBean.put("depCode", person.getDepartment().getCode());
        personBean.put("positionInput", person.getPositionInput());
        personBean.put("orderField", person.getOrderField());
        personBean.put("mobile", person.getMobile());
        personBean.put("sex", person.getSex());
        personBean.put("identifier", person.getIdentifier());
        Map<String, GprsMenu> gprspower = this.userPowerService.queryPersonTerminalPowerList(person.getId());
        StringBuffer powerStr = new StringBuffer();
        for (GprsMenu code : gprspower.values()) {
            if (!StringUtils.isNotBlank((CharSequence)code.getC_qx()) || !"1".equals(code.getC_zt())) continue;
            powerStr.append(code.getC_qx()).append("#");
        }
        personBean.put("menupower", powerStr.toString());
        rst.setData(personBean);
        rst.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        return rst;
    }

    @Override
    public SxmsResult getUserPower(String id) {
        SxmsResult rst = new SxmsResult();
        ArrayList<RoleBean> list = new ArrayList<RoleBean>();
        Map<String, GprsMenu> gprspower = this.userPowerService.queryPersonTerminalPowerList(id);
        for (GprsMenu code : gprspower.values()) {
            if (!StringUtils.isNotBlank((CharSequence)code.getC_qx())) continue;
            RoleBean roleBean = new RoleBean();
            roleBean.setQx(code.getC_qx());
            roleBean.setPcurl(code.getC_ljdz());
            list.add(roleBean);
        }
        rst.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        rst.setData(list);
        rst.setFlag("0");
        return rst;
    }
}

