/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.bean.DBMonitorBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class DBMonitorController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(DBMonitorController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private BaseDao baseDao;

    @RequestMapping(value={"syms/dbmonitorcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"syms/dbmonitorcontroller/todbmonitor.do"})
    public String dbmonitor() {
        return "syms/monitor/default/dbmonitor";
    }

    @RequestMapping(value={"syms/dbmonitorcontroller/tablespacemonitor.do"})
    public String tablespacemonitor() {
        return "syms/monitor/default/tabsmonitor";
    }

    @RequestMapping(value={"syms/dbmonitorcontroller/dbmonitor.do"})
    public void dbMonitor(String type, HttpServletResponse response, HttpServletRequest request) {
        HttpSession session = request.getSession();
        String sql = "select status as rst,to_char(count(status)) as rst2 from v$session group by status";
        if ("session".equals(type)) {
            sql = "select lower(status) as rst,to_char(count(status)) as rst2 from v$session group by status";
        }
        if ("IO".equals(type)) {
            sql = "select to_char(sum( b.phyrds)) as rst, to_char(sum(b.phywrts)) as rst2 from v$datafile a, v$filestat b where a.file# = b.file# ";
        }
        if ("SGA".equals(type)) {
            sql = "select lower(name) as rst,to_char(value/1000000,'9999') as rst2 from v$sga";
        }
        if ("tabsp".equals(type)) {
            sql = "SELECT  A.TABLESPACE_NAME as rst,to_char((B.BYTES * 100 ) / A.BYTES ,'999') as rst2,to_char((B.BYTES * 100 ) / A.BYTES ,'90.99') as  rst3,to_char(A.BYTES/1024/1024,'99999999') as rst4,to_char(B.BYTES/1024/1024,'99999999') as rst5,to_char(C.BYTES/1024/1024,'99999999') as rst6,to_char((B.BYTES * 100 ) / A.BYTES ,'90.99') as  rst7,to_char((C.BYTES * 100 ) / A.BYTES,'90.99') as  rst8 FROM  SYS.SM$TS_AVAIL A,SYS.SM$TS_USED B,SYS.SM$TS_FREE C  WHERE  A.TABLESPACE_NAME = B.TABLESPACE_NAME  AND  a.tablespace_name=c.tablespace_name order by  A.TABLESPACE_NAME";
        }
        if ("eventwait".equals(type)) {
            sql = "select to_char(sum(decode(wait_Time,0,1,0))) as rst,to_char(count(*)) as rst2 from v$session_Wait";
        }
        if ("online".equals(type)) {
            sql = "select to_char(count(*)) from t_person ";
        }
        List<?> list = this.baseDao.getListBySQL(sql, null, DBMonitorBean.class);
        ArrayList tabs = new ArrayList();
        String active = "";
        String inactive = "";
        String fixed_size = "";
        String variable_size = "";
        String database_buffers = "";
        String redo_buffers = "";
        String phyrds = "";
        String phywrts = "";
        String tabsp = "";
        String waittime = "";
        String events = "";
        String countperson = "";
        int countonline = 0;
        for (DBMonitorBean dbMonitorBean : list) {
            String[] arr = dbMonitorBean.getStringArr();
            if ("active".equals(arr[0])) {
                active = arr[1];
            }
            if ("inactive".equals(arr[0])) {
                inactive = arr[1];
            }
            if ("fixed size".equals(arr[0])) {
                fixed_size = arr[1];
            }
            if ("variable size".equals(arr[0])) {
                variable_size = arr[1];
            }
            if ("database buffers".equals(arr[0])) {
                database_buffers = arr[1];
            }
            if ("redo buffers".equals(arr[0])) {
                redo_buffers = arr[1];
            }
            if ("IO".equals(type)) {
                phyrds = arr[0];
                phywrts = arr[1];
            }
            if ("tabsp".equals(type)) {
                for (int i = 0; i < arr.length; ++i) {
                    tabsp = tabsp + arr[i] + ",";
                }
                if (tabsp.endsWith(",")) {
                    tabsp = tabsp.substring(0, tabsp.length() - 1);
                }
                tabsp = tabsp + "|";
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", arr[0]);
                map.put("usedpercent", arr[2]);
                map.put("total", arr[3]);
                map.put("userd", arr[4]);
                map.put("free", arr[5]);
                tabs.add(map);
            }
            if ("eventwait".equals(type)) {
                waittime = arr[0];
                events = arr[1];
            }
            if (!"online".equals(type)) continue;
            countperson = arr[0];
        }
        String rst = "";
        if ("session".equals(type)) {
            rst = active + "," + inactive;
        }
        if ("IO".equals(type)) {
            String strLastPhyrds = (String)session.getAttribute("lastPhyrds");
            String strLastPhywrts = (String)session.getAttribute("lastPhywrts");
            session.setAttribute("lastPhyrds", (Object)phyrds);
            session.setAttribute("lastPhywrts", (Object)phywrts);
            int iLastPhyrds = 0;
            int iLastPhywrts = 0;
            int iPhyrds = 0;
            int iPhywrts = 0;
            try {
                iLastPhyrds = Integer.parseInt(strLastPhyrds);
                iLastPhywrts = Integer.parseInt(strLastPhywrts);
                iPhyrds = Integer.parseInt(phyrds);
                iPhywrts = Integer.parseInt(phywrts);
                rst = iPhyrds - iLastPhyrds + "," + (iPhywrts - iLastPhywrts);
            }
            catch (Exception e2) {
                rst = "";
            }
        }
        if ("SGA".equals(type)) {
            rst = fixed_size + "," + variable_size + "," + database_buffers + "," + redo_buffers;
        }
        if ("tabsp".equals(type)) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("total", Integer.valueOf(tabs.size()));
            map.put("rows", tabs);
            rst = Util.toJsonStr(map);
        }
        if ("eventwait".equals(type)) {
            rst = waittime + "," + events;
        }
        if ("online".equals(type)) {
            rst = countperson + "," + countonline;
        }
        Util.writeUtf8Text(response, rst);
    }
}

