/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.resource.ResourceBundleMessageSource;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.bean.MessageBean;
import com.xdja.pams.syms.bean.MessageBeans;
import com.xdja.pams.syms.util.SafeProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class ResourceController
extends BaseControler {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ResourceController.class);
    @Autowired
    private ResourceBundleMessageSource message;

    @RequestMapping(value={"/syms/ResourceController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/syms/ResourceController/query.do"})
    public void query(String query, HttpServletResponse response, HttpServletRequest request) {
        ArrayList list = new ArrayList();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try {
            File messageInfoFile = this.getMessageInfoFile();
            SafeProperties properties = new SafeProperties();
            FileInputStream fis = new FileInputStream(messageInfoFile);
            properties.load(fis);
            fis.close();
            List entrys = properties.getContext().getCommentOrEntrys();
            query = StringUtils.trimToNull((String)query);
            for (Object object : entrys) {
                if (!(object instanceof SafeProperties.PropertiesContext.PropertyEntry)) continue;
                SafeProperties.PropertiesContext.PropertyEntry entry = (SafeProperties.PropertiesContext.PropertyEntry)object;
                if (query != null && !entry.getKey().contains(query) && !entry.getValue().contains(query)) continue;
                HashMap<String, String> codeMap = new HashMap<String, String>();
                codeMap.put("name", entry.getKey());
                codeMap.put("value", entry.getValue());
                codeMap.put("editor", "text");
                list.add(codeMap);
            }
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u8d44\u6e90\u6587\u4ef6\u5931\u8d25", (Throwable)e2);
        }
        map.put("total", Integer.valueOf(list.size()));
        map.put("rows", list);
        String json = Util.toJsonStr(map);
        Util.writeUtf8Text(response, json);
    }

    @RequestMapping(value={"/syms/ResourceController/update.do"})
    public void update(MessageBeans code, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            File messageInfoFile = this.getMessageInfoFile();
            SafeProperties properties = new SafeProperties();
            FileInputStream fis = new FileInputStream(messageInfoFile);
            properties.load(fis);
            fis.close();
            List<MessageBean> codes = code.getCodes();
            if (codes != null && !codes.isEmpty()) {
                for (MessageBean msgBean : codes) {
                    properties.setProperty(msgBean.getName(), msgBean.getValue());
                }
            }
            FileOutputStream ops = new FileOutputStream(messageInfoFile);
            properties.store(ops, null);
            ops.close();
            log.info("\u66f4\u65b0\u8d44\u6e90\u6587\u4ef6\uff1a" + messageInfoFile);
            this.message.clearCache();
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u8d44\u6e90\u6587\u4ef6\u5931\u8d25", (Throwable)e2);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        String json = Util.toJsonStr(map);
        Util.writeUtf8JSON(response, json);
    }

    private File getMessageInfoFile() throws URISyntaxException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("messageInfo_zh_CN.properties");
        log.info(String.valueOf(resource));
        File file = new File(resource.toURI());
        return file;
    }
}

