/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.bean.QueryForm;
import com.xdja.pams.syms.dao.CardRegisterDao;
import com.xdja.pams.syms.entity.CardRegister;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CardRegisterDaoImpl
implements CardRegisterDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public CardRegister save(CardRegister cardRegister) {
        this.baseDao.create(cardRegister);
        return cardRegister;
    }

    @Override
    public void update(CardRegister cardRegister) {
        this.baseDao.update(cardRegister);
    }

    @Override
    public void delete(CardRegister cardRegister) {
        this.baseDao.delete(cardRegister);
    }

    @Override
    public CardRegister get(Serializable id) {
        return (CardRegister)this.baseDao.getObjectById(CardRegister.class, id);
    }

    @Override
    public CardRegister getByCardNumber(String cardNumber) {
        String hql = "from CardRegister where cardNumber=? ";
        Object[] obj = new String[]{cardNumber};
        return (CardRegister)this.baseDao.getObjectByHQL(hql, obj);
    }

    @Override
    public List<CardRegister> queryPage(QueryForm form, Page page) throws ParseException {
        StringBuilder select = new StringBuilder("from CardRegister where 1=1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (form != null) {
            if (StringUtils.isNotBlank((CharSequence)form.getCardNumber())) {
                select.append(" and cardNumber like ?");
                list.add("%" + form.getCardNumber() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getStartDate())) {
                select.append(" and produceDate>=?");
                list.add(sdf.parse(form.getStartDate() + " " + " 00:00:00"));
            }
            if (StringUtils.isNotBlank((CharSequence)form.getEndDate())) {
                select.append(" and produceDate<=?");
                list.add(sdf.parse(form.getEndDate() + " " + " 23:59:59"));
            }
        }
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        return this.baseDao.getListByHQL(selectCount, select.toString(), values, page);
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

