/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.dao.LegalIPDao;
import com.xdja.pams.syms.entity.LegalIP;
import com.xdja.pams.syms.service.LegalIPService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class LegalIPServiceImpl
implements LegalIPService {
    @Autowired
    private LegalIPDao legalIPDao;

    @Override
    public List<LegalIP> query(LegalIP legalIP, Page page) {
        return this.legalIPDao.queryPage(legalIP, page);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public LegalIP save(LegalIP legalIP) {
        return this.legalIPDao.save(legalIP);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(LegalIP legalIP) {
        this.legalIPDao.update(legalIP);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(Serializable id) {
        LegalIP legalIP = this.legalIPDao.get(id);
        this.legalIPDao.delete(legalIP);
    }

    @Override
    public LegalIP get(Serializable id) {
        return this.legalIPDao.get(id);
    }

    @Override
    public boolean checkIP(String IP, String id) {
        LegalIP legalIP = this.legalIPDao.getByIP(IP);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            if (legalIP == null) {
                return false;
            }
            return !legalIP.equals(id);
        }
        return legalIP != null;
    }

    public LegalIPDao getLegalIPDao() {
        return this.legalIPDao;
    }

    public void setLegalIPDao(LegalIPDao legalIPDao) {
        this.legalIPDao = legalIPDao;
    }
}

