/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syn.dao.impl;

import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syn.bean.QueryParamPoliceAndMDP;
import com.xdja.pams.syn.dao.PersonMDPDao;
import com.xdja.pams.syn.entity.MDPPerson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PersonMDPDaoImpl
implements PersonMDPDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public MDPPerson save(MDPPerson person) {
        this.baseDao.create(person);
        return person;
    }

    @Override
    public void update(MDPPerson person) {
        this.baseDao.update(person);
    }

    @Override
    public void delete(MDPPerson person) {
        this.baseDao.delete(person);
    }

    @Override
    public MDPPerson getById(String id) {
        return (MDPPerson)this.baseDao.getObjectById(MDPPerson.class, (Serializable)((Object)id));
    }

    @Override
    public MDPPerson getByIdentifier(String identifier) {
        return (MDPPerson)this.baseDao.getObjectByHQL("from MDPPerson where identifier = ? and ifDelete ='0'", new String[]{identifier});
    }

    @Override
    public List<MDPPerson> queryMDPPersonList(QueryParamPoliceAndMDP param, Page page) {
        StringBuffer sb = new StringBuffer("from t_mdp_person p where 1=1");
        ArrayList<String> list = new ArrayList<String>();
        if (param != null) {
            if (StringUtils.isNotBlank((CharSequence)param.getId())) {
                sb.append(" and p.person_id = ?");
                list.add(param.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getDepId())) {
                sb.append(" and p.dep_id = ?");
                list.add(param.getDepId());
            }
            if (param.isContain()) {
                if (StringUtils.isNotBlank((CharSequence)param.getControlDep())) {
                    sb.append(" and p.SERVICE_DEP_ID in ( " + BimsUtil.getChildDepsSql(param.getControlDep()) + " ) ");
                }
            } else if (StringUtils.isNotBlank((CharSequence)param.getControlDep())) {
                String[] depsArray = param.getControlDep().split(",");
                String depIds = "";
                for (String depId : depsArray) {
                    depIds = depIds + "'" + depId + "',";
                }
                depIds = depIds.substring(0, depIds.length() - 1);
                sb.append(" and p.SERVICE_DEP_ID in ( " + depIds + " ) ");
            }
            if (StringUtils.isNotBlank((CharSequence)param.getName())) {
                sb.append(" and p.person_name like ?");
                list.add("%" + param.getName() + "%");
            }
            if (param.getPersonType() != null && param.getPersonType().length() > 0) {
                char[] types;
                StringBuffer typeConditionSB = new StringBuffer();
                for (char type : types = param.getPersonType().toCharArray()) {
                    typeConditionSB.append(" p.person_type = ? or");
                    list.add(new String(new char[]{type}));
                }
                String string2 = typeConditionSB.toString();
                string2 = string2.substring(0, string2.length() - 2);
                sb.append(" and (").append(string2).append(")");
            }
            if (StringUtils.isNotBlank((CharSequence)param.getIdentifier())) {
                sb.append(" and p.identifier = ?");
                list.add(param.getIdentifier());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getVerifyState())) {
                sb.append(" and p.verify_state = ?");
                list.add(param.getVerifyState());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getIfDelete())) {
                sb.append(" and p.if_delete = ?");
                list.add(param.getIfDelete());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getCode())) {
                sb.append(" and p.code = ?");
                list.add(param.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getRoleId())) {
                sb.append(" and p.person_id in (select person_id from t_mdp_person_role r where r.sys_role_id = ?) ");
                list.add(param.getRoleId());
            }
        }
        Object[] values = list.toArray(new String[0]);
        String select = "select p.* " + sb.toString() + " order by p.create_date desc";
        String string = "select count(p.person_id) " + sb.toString();
        return this.baseDao.getListBySQL(string, select, values, page, MDPPerson.class);
    }
}

