/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syn.service.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.bean.Result;
import com.xdja.pams.sso.bean.SynRst;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.syn.bean.DepEnableRstBean;
import com.xdja.pams.syn.bean.MDPPersonAndRole;
import com.xdja.pams.syn.bean.MDPPersonRoleBean;
import com.xdja.pams.syn.bean.QueryParamPoliceAndMDP;
import com.xdja.pams.syn.dao.PersonMDPDao;
import com.xdja.pams.syn.dao.PoliceAndMDPDao;
import com.xdja.pams.syn.entity.MDPAndPolice;
import com.xdja.pams.syn.entity.MDPPerson;
import com.xdja.pams.syn.service.BaseInfoQueryService;
import com.xdja.pams.syn.service.PersonMDPService;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.SysRoleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class PersonMDPServiceImpl
implements PersonMDPService {
    @Autowired
    private PersonMDPDao personMDPDao;
    @Autowired
    private PoliceAndMDPDao policAndMDPDao;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private BaseInfoQueryService baseInfoQueryService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private DepManageService depManageService;
    private static Logger log = Logger.getLogger(PersonMDPServiceImpl.class);

    @Override
    public Result addMDPPerson(QueryParamPoliceAndMDP queryParam) {
        String personJson = queryParam.getPerson();
        Result rst = new Result();
        MDPPersonAndRole personAndRole = null;
        try {
            personAndRole = Util.readValue(personJson, MDPPersonAndRole.class);
        }
        catch (Exception e2) {
            log.error((Object)("\u6dfb\u52a0\u4eba\u5458\u5931\u8d25\uff1a\u4eba\u5458\u4fe1\u606fJSON\u683c\u5f0f\u9519\u8bef" + personJson), (Throwable)e2);
            rst.setFlag("1");
            rst.setMessage(MessageManager.getProMessage(this.message, "syn.paramerror.personjson"));
            return rst;
        }
        String[] roles = personAndRole.getRoles();
        MDPPerson person = new MDPPerson();
        BeanUtils.copyProperties((Object)personAndRole, (Object)person);
        if (roles != null) {
            ArrayList<Role> roleList = new ArrayList<Role>();
            for (String roleId : roles) {
                if (!StringUtils.isNotBlank((CharSequence)roleId)) continue;
                Role role = new Role();
                role.setId(roleId);
                roleList.add(role);
            }
            person.setPersonRoles(roleList);
        }
        this.saveMDPPerson(person);
        rst.setFlag("0");
        rst.setId(person.getId());
        return rst;
    }

    @Override
    public Result updateMDPPerson(QueryParamPoliceAndMDP queryParam) {
        String personJsons = queryParam.getPersons();
        Result rst = new Result();
        ArrayList list = new ArrayList();
        MDPPerson[] persons = null;
        try {
            persons = Util.readValue(personJsons, MDPPerson[].class);
            if (persons == null) {
                log.error((Object)("\u66f4\u65b0\u4eba\u5458\u5931\u8d25\uff1a\u4eba\u5458\u4fe1\u606fJSON\u683c\u5f0f\u9519\u8bef:" + personJsons));
                rst.setFlag("1");
                rst.setMessage(MessageManager.getProMessage(this.message, "syn.paramerror.personjson"));
                return rst;
            }
        }
        catch (Exception e2) {
            log.error((Object)("\u66f4\u65b0\u4eba\u5458\u5931\u8d25\uff1a\u4eba\u5458\u4fe1\u606fJSON\u683c\u5f0f\u9519\u8bef:" + personJsons), (Throwable)e2);
            rst.setFlag("1");
            rst.setMessage(MessageManager.getProMessage(this.message, "syn.paramerror.personjson"));
            return rst;
        }
        for (MDPPerson person : persons) {
            MDPPerson personRes = this.personMDPDao.getById(person.getId());
            String verifyState = person.getVerifyState();
            if ("1".equals(personRes.getPersonType()) && "4".equals(personRes.getVerifyState())) {
                List<Role> roles = personRes.getPersonRoles();
                for (Role role : roles) {
                    if (!"3".equals(role.getId())) continue;
                    verifyState = "1";
                    break;
                }
            }
            if (!personRes.getIdentifier().equals(person.getIdentifier()) && this.checkIdentifierExist(person.getIdentifier())) {
                rst.setFlag("1");
                rst.setMessage(MessageManager.getProMessage(this.message, "syn.person.save.error.identifierexist"));
                return rst;
            }
            personRes.setIdentifier(person.getIdentifier());
            personRes.setMobile(person.getMobile());
            personRes.setName(person.getName());
            personRes.setCode(person.getCode());
            personRes.setVerifyState(verifyState);
            personRes.setMail(person.getMail());
            personRes.setDepId(person.getDepId());
            personRes.setDepName(person.getDepName());
            personRes.setPersonContent(person.getPersonContent());
            personRes.setPersonType(person.getPersonType());
            personRes.setServiceUnitId(person.getServiceUnitId());
            personRes.setVendorsName(person.getVendorsName());
            personRes.setVendorsAddress(person.getVendorsAddress());
            personRes.setVendorsLogoPath(person.getVendorsLogoPath());
            personRes.setVendorsTelno(person.getVendorsTelno());
            if ("0".equals(person.getIfDelete()) || "1".equals(person.getIfDelete())) {
                personRes.setIfDelete(person.getIfDelete());
            }
            if ("1".equals(person.getEnabled()) || "0".equals(person.getEnabled())) {
                personRes.setEnabled(person.getEnabled());
            }
            String[] roleIdArr = person.getRoleIds();
            ArrayList<Role> roleList = new ArrayList<Role>();
            if (roleIdArr != null) {
                for (String roleId : roleIdArr) {
                    if (!StringUtils.isNotBlank((CharSequence)roleId)) continue;
                    Role role = new Role();
                    role.setId(roleId);
                    roleList.add(role);
                }
            }
            personRes.setPersonRoles(roleList);
            this.updateMDPPerson(personRes);
        }
        rst.setFlag("0");
        rst.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        return rst;
    }

    @Override
    @Transactional
    public Result deleteMDPPerson(QueryParamPoliceAndMDP queryParam) {
        String id = queryParam.getPersonId();
        String deleteReason = queryParam.getDeleteReason();
        Result rst = new Result();
        MDPPerson person = this.personMDPDao.getById(id);
        if (person == null) {
            rst.setFlag("1");
            rst.setMessage(MessageManager.getProMessage(this.message, "syn.person.delete.error.notfindperson"));
            return rst;
        }
        person.setIfDelete("1");
        person.setDeleteReason(deleteReason);
        this.updateMDPPerson(person);
        this.deleteMDPDep(person.getDepId());
        rst.setFlag("0");
        rst.setId(person.getId());
        return rst;
    }

    private boolean deleteMDPDep(String depId) {
        if (StringUtils.isBlank((CharSequence)depId)) {
            return true;
        }
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/pmag/register/delDepartment.do?type=json";
        String param = "ifEnabel=0&depId=" + depId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        DepEnableRstBean rstBean = new DepEnableRstBean();
        try {
            String rst = httpRequestUtil.post(mdpUrl, param);
            rstBean = Util.readValue(rst, DepEnableRstBean.class);
        }
        catch (Exception e2) {
            throw new RuntimeException("\u8c03\u7528\u5355\u4f4d\u5220\u9664\u63a5\u53e3\u5931\u8d25");
        }
        if (rstBean == null || !"1".equals(rstBean.getState())) {
            throw new RuntimeException("\u8c03\u7528\u5355\u4f4d\u5220\u9664\u63a5\u53e3\u5931\u8d25");
        }
        return "1".equals(rstBean.getState());
    }

    @Override
    public Result updatePassword(QueryParamPoliceAndMDP queryParam) {
        String personId = queryParam.getPersonId();
        String oldPassword = queryParam.getOldPassword();
        String newPassword = queryParam.getNewPassword();
        Result rst = new Result();
        Md5PwdEncoder md5Util = Md5PwdEncoder.getInstance();
        String password = null;
        MDPPerson person = this.personMDPDao.getById(personId);
        Person police = null;
        if (person != null) {
            password = person.getPassword();
        } else {
            police = this.userManagerService.queryPersonById(personId);
            password = police.getPassword();
        }
        if (person == null && police == null) {
            rst.setFlag("1");
            rst.setMessage(MessageManager.getProMessage(this.message, "syn.person.query.error.notfind"));
            return rst;
        }
        if (oldPassword == null || !password.equals(md5Util.encodePassword(oldPassword))) {
            rst.setFlag("1");
            rst.setMessage(MessageManager.getProMessage(this.message, "syn.person.update.password.error.passwordwrong"));
            return rst;
        }
        if (person != null) {
            person.setPassword(md5Util.encodePassword(newPassword));
            this.updateMDPPerson(person);
        } else {
            police.setPassword(md5Util.encodePassword(newPassword));
            this.userManagerService.updateUser(police);
        }
        rst.setFlag("0");
        rst.setId(personId);
        rst.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        return rst;
    }

    @Override
    public SynRst<MDPAndPolice> queryMDPAndPolice(QueryParamPoliceAndMDP queryParam) {
        QueryParamPoliceAndMDP param = null;
        SynRst<MDPAndPolice> synRst = new SynRst();
        if (StringUtils.isBlank((CharSequence)queryParam.getParam())) {
            param = queryParam;
        } else {
            try {
                param = Util.readValue(queryParam.getParam(), QueryParamPoliceAndMDP.class);
            }
            catch (Exception e2) {
                log.error((Object)("\u67e5\u8be2\u5f02\u5e38\uff0cJSON\u8f6c\u6362\u5bf9\u8c61\u51fa\u9519\uff1a" + queryParam.getParam()), (Throwable)e2);
                synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.person.query.error.paramjsonerror"));
                return synRst;
            }
        }
        synRst = this.queryMDPAndPolice(queryParam.getThirdId(), queryParam.getPageNo(), queryParam.getPageSize(), param);
        return synRst;
    }

    @Override
    public SynRst<MDPAndPolice> queryMDPAndPolice(String thridId, String pageNo, String pageSize, QueryParamPoliceAndMDP param) {
        SynRst<MDPAndPolice> synRst = new SynRst<MDPAndPolice>();
        Page page = new Page();
        int iPageNo = 0;
        int iPageSize = 0;
        try {
            iPageNo = Integer.parseInt(pageNo);
            iPageSize = Integer.parseInt(pageSize);
        }
        catch (NumberFormatException e1) {
            log.error((Object)("\u67e5\u8be2\u5931\u8d25\uff1a\u67e5\u8be2\u9875\u6570\u6216\u6bcf\u9875\u6570\u91cf\u683c\u5f0f\u9519\u8befpageNO:" + pageNo + " pageSize:" + pageSize), (Throwable)e1);
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.person.query.error.pageinfowrong"));
            return synRst;
        }
        if (iPageSize < 1) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.person.query.error.pagesizethanzero"));
            return synRst;
        }
        if (iPageNo < 1) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.person.query.error.pagenothanzero"));
            return synRst;
        }
        int i_configPageSize = 0;
        String configPageSize = this.systemConfigService.getValueByCode("syninfo_pagesize");
        try {
            i_configPageSize = Integer.parseInt(configPageSize);
        }
        catch (NumberFormatException e2) {
            log.error((Object)("\u7cfb\u7edf\u53c2\u6570\u914d\u7f6e-\u6bcf\u9875\u6570\u91cf\u914d\u7f6e\u9519\u8bef:" + configPageSize), (Throwable)e2);
        }
        if (i_configPageSize < 1) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.person.query.error.sysconfpagesizeerror"));
            return synRst;
        }
        if (iPageSize > i_configPageSize) {
            iPageSize = i_configPageSize;
        }
        page.setPage(iPageNo);
        page.setRp(iPageSize);
        List<MDPAndPolice> list = this.policAndMDPDao.querySynMDPPersonList(param, page);
        if (list != null) {
            for (MDPAndPolice p : list) {
                Department dep;
                List<MDPPersonRoleBean> rs = this.queryMDPPersonRole(new String[]{p.getId()});
                if (rs == null) continue;
                String tmp = "";
                for (MDPPersonRoleBean role : rs) {
                    tmp = tmp + role.getRoleId() + ",";
                }
                if (tmp.endsWith(",")) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                }
                p.setPersonRoles(tmp);
                if (p.getServiceUnitId() == null || (dep = this.depManageService.queryDepById(p.getServiceUnitId())) == null) continue;
                p.setServiceUnitName(dep.getName());
            }
        }
        synRst.setCount(page.getTotal());
        synRst.setList(list);
        synRst.setResult("0", MessageManager.getProMessage(this.message, "common.message.operate.success"));
        return synRst;
    }

    @Override
    public void updateMDPPassword(String newPassword, String personId) {
        MDPPerson person = this.personMDPDao.getById(personId);
        person.setPassword(Md5PwdEncoder.getInstance().encodePassword(newPassword));
        this.updateMDPPerson(person);
    }

    @Override
    public boolean checkIdentifier(QueryParamPoliceAndMDP queryParam) {
        String identifier = queryParam.getIdentifier();
        return this.checkIdentifierExist(identifier);
    }

    private boolean checkIdentifierExist(String identifier) {
        MDPAndPolice person = this.policAndMDPDao.getByIdentifierOrCodeIgnoreCase(identifier);
        return person != null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public MDPPerson saveMDPPerson(MDPPerson person) {
        if (this.checkIdentifierExist(person.getIdentifier())) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "syn.person.save.error.identifierexist"));
        }
        if (this.checkIdentifierExist(person.getCode())) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "syn.person.save.error.codeexist"));
        }
        String isCheckIdentifier = this.systemConfigService.getValueByCode("isCheckIdentifier");
        if ("1".equals(isCheckIdentifier)) {
            String name = null;
            try {
                name = this.baseInfoQueryService.queryNameFromQGK(person.getIdentifier());
            }
            catch (Exception e2) {
                log.error((Object)"\u5168\u56fd\u5e93\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u5931\u8d25\uff01");
                throw new RuntimeException(MessageManager.getProMessage(this.message, "syn.person.save.error.queryQGKerror"));
            }
            if (name == null || !name.equals(person.getName())) {
                throw new RuntimeException(MessageManager.getProMessage(this.message, "syn.person.save.error.identifierornamewrong"));
            }
        }
        person.setIdentifier(person.getIdentifier());
        person.setPassword(Md5PwdEncoder.getInstance().encodePassword(person.getPassword()));
        person.setCreateDate(new Date());
        person.setLastUpdateTime(new Date().getTime());
        person.setIfDelete("0");
        person.setEnabled("1");
        this.personMDPDao.save(person);
        return person;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateMDPPerson(MDPPerson person) {
        person.setLastUpdateTime(new Date().getTime());
        this.personMDPDao.update(person);
    }

    @Override
    public void updateMDPPersonVerifyState(String id, String verifyState) {
        MDPPerson person = this.getMDPPersonById(id);
        person.setVerifyState(verifyState);
        person.setOpenDate(new Date());
        this.updateMDPPerson(person);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteMDPPerson(MDPPerson person) {
        this.personMDPDao.delete(person);
    }

    @Override
    public MDPPerson getMDPPersonById(String id) {
        MDPPerson person = this.personMDPDao.getById(id);
        Department dep = null;
        if (person.getServiceUnitId() != null) {
            dep = this.depManageService.queryDepById(person.getServiceUnitId());
        }
        if (dep != null) {
            person.setServiceUnitName(dep.getName());
        }
        return person;
    }

    @Override
    public Result updateMDPPasswordForAdmin(QueryParamPoliceAndMDP queryParam) {
        String newPassword = queryParam.getNewPassword();
        newPassword = this.systemConfigService.getValueByCode("defaultPass");
        String personId = queryParam.getPersonId();
        Result result = new Result();
        this.updateMDPPassword(newPassword, personId);
        result.setFlag("0");
        result.setId(personId);
        result.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.success") + MessageManager.getProMessage(this.message, "syn.updatepassword.initial") + ":" + newPassword);
        return result;
    }

    @Override
    public SynRst<MDPAndPolice> queryMDPAndPoliceByUserName(String userName) {
        SynRst<MDPAndPolice> synRst = new SynRst<MDPAndPolice>();
        MDPAndPolice person = this.policAndMDPDao.getByIdentifierOrCode(userName);
        ArrayList<MDPAndPolice> list = new ArrayList<MDPAndPolice>();
        list.add(person);
        synRst.setList(list);
        synRst.setCount(list.size());
        synRst.setResult("0", MessageManager.getProMessage(this.message, "common.message.operate.success"));
        return synRst;
    }

    @Override
    public SynRst<MDPAndPolice> queryMDPAndPoliceByUserName(QueryParamPoliceAndMDP param) {
        return this.queryMDPAndPoliceByUserName(param.getUserName());
    }

    @Override
    public MDPAndPolice getMDPAndPoliceByIdentifierOrCode(String identifierOrCode) {
        return this.policAndMDPDao.getByIdentifierOrCode(identifierOrCode);
    }

    @Override
    public MDPAndPolice getMDPAndPoliceByIdentifierOrCodeIgnoreCase(String identifierOrCode) {
        return this.policAndMDPDao.getByIdentifierOrCodeIgnoreCase(identifierOrCode);
    }

    @Override
    public List<MDPPerson> queryMDP(QueryParamPoliceAndMDP param, Page page) {
        List<MDPPerson> list = this.personMDPDao.queryMDPPersonList(param, page);
        for (MDPPerson person : list) {
            Department dep = null;
            if (person.getServiceUnitId() != null) {
                dep = this.depManageService.queryDepById(person.getServiceUnitId());
            }
            if (dep == null) continue;
            person.setServiceUnitName(dep.getName());
        }
        return list;
    }

    @Override
    public List<MDPAndPolice> queryMDPAndPolice(QueryParamPoliceAndMDP param, Page page) {
        return this.policAndMDPDao.querySynMDPPersonList(param, page);
    }

    @Override
    public MDPAndPolice getMDPAndPoliceById(String id) {
        return this.policAndMDPDao.getById(id);
    }

    @Override
    public List<MDPPersonRoleBean> queryMDPPersonRole(String[] personIds) {
        return this.policAndMDPDao.queryMDPPersonRole(personIds);
    }

    @Override
    public List<MDPPersonRoleBean> queryMDPAndPoliceRole(String personId) {
        List<MDPPersonRoleBean> roleList = null;
        MDPAndPolice user = this.getMDPAndPoliceById(personId);
        String personType = user.getPersonType();
        if ("2".equals(personType)) {
            roleList = this.policAndMDPDao.queryMDPPoliceRole(personId);
        } else if (!"3".equals(user.getVerifyState())) {
            Role roleYK = this.sysRoleService.queryRoleById("0");
            roleList = new ArrayList<MDPPersonRoleBean>();
            MDPPersonRoleBean rb = new MDPPersonRoleBean();
            rb.setPersonId(personId);
            rb.setRoleId(roleYK.getId());
            rb.setRoleName(roleYK.getName());
            roleList.add(rb);
        } else {
            roleList = this.policAndMDPDao.queryMDPPersonRole(new String[]{personId});
        }
        return roleList;
    }

    @Override
    public void setEnabled(String personId, String enabledStatus) {
        MDPPerson person = this.getMDPPersonById(personId);
        if ("1".equals(enabledStatus)) {
            person.setOpenDate(new Date());
        }
        person.setEnabled(enabledStatus);
        this.updateMDPPerson(person);
    }
}

