/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.synjly.service.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.synjly.bean.DepartmentRsp;
import com.xdja.pams.synjly.bean.JlyDepartmentBean;
import com.xdja.pams.synjly.bean.JlyPersonBean;
import com.xdja.pams.synjly.bean.PersonRsp;
import com.xdja.pams.synjly.dao.JlySynDao;
import com.xdja.pams.synjly.entity.JlyDepartment;
import com.xdja.pams.synjly.entity.JlyPerson;
import com.xdja.pams.synjly.entity.JlySynRecord;
import com.xdja.pams.synjly.util.HttpRequestUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JlySynServiceImpl
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JlySynServiceImpl.class);
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    @Autowired
    JlySynDao dao;
    @Autowired
    DepManageService depManageService;
    @Autowired
    UserManageService userManageService;
    @Autowired
    SystemConfigService systemConfigService;

    public void syn() {
        String url = this.systemConfigService.getValueByCode("SYN_THIRD_JLY_URL");
        try {
            this.synJly(url, "dep");
        }
        catch (Exception e2) {
            log.error("\u91d1\u8fde\u4e91\u5355\u4f4d\u540c\u6b65\u5931\u8d25", (Throwable)e2);
        }
        try {
            this.synJly(url, "person");
        }
        catch (Exception e3) {
            log.error("\u91d1\u8fde\u4e91\u7528\u6237\u540c\u6b65\u5931\u8d25", (Throwable)e3);
        }
        try {
            this.depRelation();
        }
        catch (Exception e4) {
            log.error("\u91d1\u8fde\u4e91\u5355\u4f4d\u5173\u8054\u5931\u8d25", (Throwable)e4);
        }
        try {
            this.personRelation();
        }
        catch (Exception e5) {
            log.error("\u91d1\u8fde\u4e91\u7528\u6237\u5173\u8054\u5931\u8d25", (Throwable)e5);
        }
    }

    private void synJly(String url, String type) {
        String index = "0";
        JlySynRecord depSynRecord = this.dao.getLastSynRecord(type);
        if (depSynRecord != null) {
            index = depSynRecord.getIndex();
        }
        HttpRequestUtil httpReuest = new HttpRequestUtil();
        if ("dep".equals(type)) {
            url = url + "/sync/v1/sync/orgs";
        } else if ("person".equals(type)) {
            url = url + "/sync/v1/sync/users";
        } else {
            return;
        }
        int errTime = 0;
        while (true) {
            try {
                boolean hasMord;
                do {
                    String rst = httpReuest.get(url, "index=" + index);
                    System.out.println("rst:" + rst);
                    hasMord = false;
                    if ("dep".equals(type)) {
                        DepartmentRsp depRsp = Util.readValue(rst, DepartmentRsp.class);
                        index = Long.toString(depRsp.getIndex());
                        this.synDepDataHandle(depRsp);
                        hasMord = depRsp.isHasMoreInfo();
                    }
                    if ("person".equals(type)) {
                        PersonRsp personRsp = Util.readValue(rst, PersonRsp.class);
                        index = Long.toString(personRsp.getIndex());
                        this.synPersonHandle(personRsp);
                        hasMord = personRsp.isHasMoreInfo();
                    }
                    errTime = 0;
                } while (hasMord);
                JlySynRecord record = new JlySynRecord();
                record.setCreateDate(new Date());
                record.setIndex(index);
                record.setType(type);
                this.dao.saveJlySynRecord(record);
            }
            catch (Exception e2) {
                if (++errTime < 10) {
                    log.error("\u91d1\u8fde\u4e91\u5355\u4f4d\u540c\u6b65\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
                } else {
                    log.error("\u91d1\u8fde\u4e91\u5355\u4f4d\u540c\u6b65\u5931\u8d25\uff1a" + e2.getMessage());
                }
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (errTime <= 20) continue;
            }
            break;
        }
    }

    private void synPersonHandle(PersonRsp personRsp) {
        List<JlyPersonBean> list = personRsp.getUserList();
        for (JlyPersonBean personBean : list) {
            if (StringUtils.isBlank((CharSequence)personBean.getUuid())) continue;
            JlyPerson jlyPerson = this.dao.getJlyPersonByUuid(personBean.getUuid());
            if (jlyPerson == null) {
                jlyPerson = new JlyPerson();
                BeanUtils.copyProperties((Object)personBean, (Object)jlyPerson);
                this.dao.saveJlyPerson(jlyPerson);
                continue;
            }
            jlyPerson.setIdentityNo(personBean.getIdentityNo());
            jlyPerson.setPoliceCode(personBean.getPoliceCode());
            jlyPerson.setPhone(personBean.getPhone());
            jlyPerson.setMobile(personBean.getMobile());
            jlyPerson.setDepartment(personBean.getDepartment());
            jlyPerson.setCreateTime(personBean.getCreateTime());
            jlyPerson.setName(personBean.getName());
            jlyPerson.setFlag(personBean.getFlag());
            jlyPerson.setPersonId(null);
            this.dao.updateJlyPerson(jlyPerson);
        }
    }

    private void personRelation() {
        List<JlyPerson> unRelationJlyPerson = this.dao.getUnRelationJlyPerson();
        for (JlyPerson jlyPerson : unRelationJlyPerson) {
            Mobile mobileE;
            List<Mobile> mobiledList;
            Person person = this.userManageService.getUserByIdentifer(jlyPerson.getIdentityNo());
            if ("D".equals(jlyPerson.getFlag())) {
                if (person == null) {
                    jlyPerson.setPersonId("delete");
                    this.dao.updateJlyPerson(jlyPerson);
                    continue;
                }
                this.userManageService.delete(person.getId());
                this.userManageService.deleteNoPersonMobile();
                continue;
            }
            if (person == null) {
                person = new Person();
                person.setCode(jlyPerson.getPoliceCode());
                person.setOfficePhone(jlyPerson.getPhone());
                person.setDepartment(this.getPeronDep(jlyPerson.getDepartment()));
                person.setName(jlyPerson.getName());
                person.setIdentifier(jlyPerson.getIdentityNo());
                person.setPosition("0");
                mobiledList = new ArrayList<Mobile>();
                mobileE = new Mobile();
                mobileE.setMobile(jlyPerson.getMobile());
                mobileE.setPerson(person);
                mobiledList.add(mobileE);
                person.setMobile(jlyPerson.getMobile());
                person.setMobiledList(mobiledList);
                person.setPosition("0");
                person.setSex("0");
                this.userManageService.addUser(person);
                jlyPerson.setPersonId(person.getId());
                this.dao.updateJlyPerson(jlyPerson);
                continue;
            }
            person.setSex("0");
            person.setIdentifier(jlyPerson.getIdentityNo());
            person.setCode(jlyPerson.getPoliceCode());
            person.setOfficePhone(jlyPerson.getPhone());
            person.setDepartment(this.getPeronDep(jlyPerson.getDepartment()));
            person.setName(jlyPerson.getName());
            person.setMobile(jlyPerson.getMobile());
            mobiledList = person.getMobiledList();
            if (mobiledList == null) {
                mobiledList = new ArrayList<Mobile>();
                person.setMobiledList(mobiledList);
            }
            if (mobiledList.isEmpty()) {
                mobileE = new Mobile();
                mobileE.setMobile(jlyPerson.getMobile());
                mobileE.setPerson(person);
                mobiledList.add(mobileE);
            } else {
                Mobile mobile = mobiledList.get(0);
                mobile.setMobile(jlyPerson.getMobile());
            }
            person.setPosition("0");
            this.userManageService.updateUser(person);
            jlyPerson.setPersonId(person.getId());
            this.dao.updateJlyPerson(jlyPerson);
        }
    }

    private Department getPeronDep(String jlyDepId) {
        JlyDepartment jlyDep = this.dao.getJlyDepByUuid(jlyDepId);
        return this.depManageService.queryDepById(jlyDep.getDepId());
    }

    private void synDepDataHandle(DepartmentRsp depRsp) {
        List<JlyDepartmentBean> list = depRsp.getOrgList();
        for (JlyDepartmentBean depBean : list) {
            if (StringUtils.isBlank((CharSequence)depBean.getUuid())) continue;
            JlyDepartment jlyDep = this.dao.getJlyDepByUuid(depBean.getUuid());
            if (jlyDep == null) {
                jlyDep = new JlyDepartment();
                BeanUtils.copyProperties((Object)depBean, (Object)jlyDep);
                this.dao.saveJlyDepartment(jlyDep);
                continue;
            }
            jlyDep.setCode(depBean.getCode());
            jlyDep.setFullName(depBean.getFullName());
            jlyDep.setParentUuid(depBean.getParentUuid());
            jlyDep.setDepId(null);
            jlyDep.setFlag(depBean.getFlag());
            this.dao.updateJlyDepartment(jlyDep);
        }
    }

    private void depRelation() {
        List<JlyDepartment> unRelationJlyDep = this.dao.getUnRelationJlyDep();
        for (JlyDepartment jlyDep : unRelationJlyDep) {
            Department dep = this.depManageService.getDepartmentByCode(jlyDep.getCode());
            if ("D".equals(jlyDep.getFlag())) {
                if (dep != null) {
                    this.depManageService.deleteDepById(dep.getId());
                    continue;
                }
                jlyDep.setDepId("delete");
                this.dao.updateJlyDepartment(jlyDep);
                continue;
            }
            if (dep == null) {
                dep = new Department();
                dep.setCode(jlyDep.getCode());
                dep.setName(jlyDep.getFullName());
                dep.setParentDep(this.getParentDep(jlyDep.getParentUuid()));
                String depId = this.depManageService.addDep(dep);
                jlyDep.setDepId(depId);
            } else {
                jlyDep.setDepId(dep.getId());
                dep.setName(jlyDep.getFullName());
                dep.setParentDep(this.getParentDep(jlyDep.getParentUuid()));
                this.depManageService.updateDep(dep, true);
                jlyDep.setDepId(dep.getId());
            }
            this.dao.updateJlyDepartment(jlyDep);
        }
    }

    private Department getParentDep(String parentUuid) {
        Department dep = null;
        JlyDepartment jlyDep = this.dao.getJlyDepByUuid(parentUuid);
        if (jlyDep == null) {
            return this.getNotParentDep();
        }
        if (jlyDep.getId().equals(parentUuid)) {
            return this.getNotParentDep();
        }
        if ("D".equals(jlyDep.getFlag())) {
            return this.getNotParentDep();
        }
        if (StringUtils.isNotBlank((CharSequence)jlyDep.getDepId())) {
            dep = this.depManageService.queryDepById(jlyDep.getDepId());
            return dep;
        }
        dep = new Department();
        dep.setCode(jlyDep.getCode());
        dep.setName(jlyDep.getFullName());
        dep.setParentDep(this.getParentDep(jlyDep.getParentUuid()));
        String depId = this.depManageService.addDep(dep);
        jlyDep.setDepId(depId);
        this.dao.updateJlyDepartment(jlyDep);
        return dep;
    }

    private Department getNotParentDep() {
        String code = "999999999990";
        Department dep = this.depManageService.getDepartmentByCode(code);
        if (dep == null) {
            dep = new Department();
            dep.setCode(code);
            dep.setName("\u65e0\u4e0a\u7ea7\u5355\u4f4d\u6570\u636e");
            dep.setParentDep(this.depManageService.queryDepById("8888888888"));
            dep.setLevel("2");
            dep.setOrderField(999L);
            this.depManageService.addDep(dep);
        }
        return dep;
    }

    public void destroy() throws Exception {
        this.executorService.shutdownNow();
    }

    public void afterPropertiesSet() throws Exception {
        String startFlag = this.systemConfigService.getValueByCode("SYN_THIRD_START_JLY");
        if (!"0".equals(startFlag)) {
            return;
        }
        log.debug("\u542f\u52a8\u91d1\u8fde\u4e91\u6570\u636e\u540c\u6b65============");
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    JlySynServiceImpl.this.syn();
                    try {
                        Thread.sleep(900000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
    }
}

