/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.tims.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.tims.bean.QueryFileBean;
import com.xdja.pams.tims.dao.FileUploadDao;
import com.xdja.pams.tims.entity.FileEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FileUploadDaoImpl
implements FileUploadDao {
    @Autowired
    private BaseDao baseDao;
    private static final Logger log = LoggerFactory.getLogger(FileUploadDaoImpl.class);

    @Override
    public FileEntity saveFileInfo(FileEntity file) {
        this.baseDao.create(file);
        return file;
    }

    @Override
    public void updateFileInfo(FileEntity file) {
        this.baseDao.update(file);
    }

    @Override
    public void delete(FileEntity file) {
        this.baseDao.delete(file);
    }

    @Override
    public FileEntity getFileEntity(Serializable id) {
        return (FileEntity)this.baseDao.getObjectById(FileEntity.class, id);
    }

    @Override
    public List<QueryFileBean> query(QueryFileBean queryBean, Page page) {
        StringBuilder select = new StringBuilder("from FileEntity where 1=1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (queryBean != null) {
            if (StringUtils.isNotBlank((CharSequence)queryBean.getWjmc())) {
                select.append(" and wjmc like ?");
                list.add("%" + queryBean.getWjmc() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getStartDate())) {
                select.append(" and scsj >= ?");
                try {
                    Date startDate = Util.parseDate(queryBean.getStartDate() + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
                    list.add(startDate);
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getEndDate())) {
                select.append(" and scsj <= ?");
                try {
                    Date endDate = Util.parseDate(queryBean.getEndDate() + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
                    list.add(endDate);
                }
                catch (Exception e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                }
            }
        }
        log.info(select.toString());
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        return this.baseDao.getListByHQL(selectCount, select.toString(), values, page);
    }

    @Override
    public List<FileEntity> queryAll() {
        StringBuilder select = new StringBuilder("from FileEntity where 1=1 ");
        ArrayList list = new ArrayList();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new String[0]);
        }
        return this.baseDao.getListByHQL(select.toString(), values);
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

