/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.control;

import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.upms.bean.QueryRoleBean;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.entity.SysPower;
import com.xdja.pams.upms.service.SysPowerService;
import com.xdja.pams.upms.service.SysRoleService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class SysRoleController
extends BaseControler {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private DepManageService depService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SysPowerService sysPowerService;
    @Autowired
    private SystemLogService systemLogService;
    private static final Logger log = LoggerFactory.getLogger(SysRoleController.class);
    @Autowired
    private ResourceBundleMessageSource message;

    @RequestMapping(value={"/upms/sysRoleController/listSysRole.do"})
    public String listSysRole(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"person_id", (Object)this.person.getId());
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/upms/sysRoleController/querySysRole.do"})
    public void querySysRole(HttpServletRequest request, HttpServletResponse response, PageParam page, QueryRoleBean role) {
        int operateResult = 1;
        try {
            role.setCreator_id(this.person.getId());
            role.setFlag("1");
            Page p = new Page(page.getPage(), page.getRows());
            List<Role> sysRoleList = this.sysRoleService.queryRoleList(role, p);
            ArrayList codelist = new ArrayList();
            for (Role sysrole : sysRoleList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", sysrole.getId());
                map.put("name", sysrole.getName());
                map.put("flag", sysrole.getFlag());
                map.put("type", sysrole.getType());
                map.put("seq", sysrole.getSeq());
                map.put("note", sysrole.getNote());
                Person personname = this.userManageService.queryPersonById(sysrole.getCreator_id());
                if (personname != null) {
                    String creator_name = personname.getName();
                    map.put("creator_name", creator_name);
                } else {
                    map.put("creator_name", "");
                }
                map.put("creator_id", sysrole.getCreator_id());
                codelist.add(map);
            }
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("total", Integer.valueOf(p.getTotal()));
            map.put("rows", codelist);
            Util.writeUtf8Text(response, Util.toJsonStr(map));
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/upms/sysRoleController/del.do"})
    public void del(String id, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            Role r = this.sysRoleService.queryRoleById(id);
            if (r.getPersonSet().size() > 0) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "upms.page.error.role.hasPerson"));
            } else if (r.getGroupSet().size() > 0) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "upms.page.error.role.hasGroup"));
            } else {
                r.setPersonSet(null);
                r.setGroupSet(null);
                r.setSysPowerSet(null);
                this.sysRoleService.deleteRole(r);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/upms/sysRoleController/forwardUpdatePage.do"})
    public String forwardUpdatePage(String id, ModelMap map) {
        map.put((Object)"id", (Object)id);
        return "upms/default/updateSysRole";
    }

    @RequestMapping(value={"/upms/sysRoleController/forwardAddPage.do"})
    public String forwardAddPage(String id, ModelMap map) {
        return "upms/default/addSysRole";
    }

    @RequestMapping(value={"/upms/sysRoleController/forwardPersonRolePage.do"})
    public String forwardPersonRolePage(String id, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        try {
            map.put((Object)"id", (Object)id);
            Role r = this.sysRoleService.queryRoleById(id);
            List<Person> personlist = r.getPersonSet();
            List<Department> depList = r.getDepartmentSet();
            request.setAttribute("depList", depList);
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember1.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
        }
        return "upms/default/sysPersonRole";
    }

    @RequestMapping(value={"/upms/sysRoleController/forwardGroupRolePage.do"})
    public String forwardGroupRolePage(String id, ModelMap map, HttpServletResponse response) {
        Role r = this.sysRoleService.queryRoleById(id);
        map.put((Object)"id", (Object)id);
        List<BimsGroup> grouplist = r.getGroupSet();
        String groupid = "";
        for (BimsGroup code : grouplist) {
            groupid = groupid + code.getId() + ",";
        }
        map.put((Object)"groupid", (Object)groupid);
        String jsonlist = this.sysRoleService.getGroupTreeChild(null, this.person.getId(), this.operator.getControlDeps(), groupid);
        map.put((Object)"treelist", (Object)jsonlist);
        return "upms/default/sysGroupRole";
    }

    @RequestMapping(value={"/upms/sysRoleController/forwardRolePowerPage.do"})
    public String forwardRolePowerPage(String id, ModelMap map, HttpServletResponse response) {
        log.info("forwardRolePowerPage.................");
        Role r = this.sysRoleService.queryRoleById(id);
        map.put((Object)"id", (Object)id);
        List<SysPower> syspower = r.getSysPowerSet();
        HashMap<String, SysPower> sysPowerIdMap = new HashMap<String, SysPower>();
        for (SysPower code : syspower) {
            sysPowerIdMap.put(code.getId(), code);
        }
        SysPower sys = new SysPower();
        sys.setParent_id("-111");
        sys.setStatus("1");
        List<SysPower> sysPowerList = this.sysPowerService.querySysPowerList(sys, null);
        List<Map<String, Object>> treelist = this.buildTree(sysPowerList, sysPowerIdMap);
        String jsonlist = Util.toJsonStr(treelist);
        map.put((Object)"treeJson", (Object)jsonlist);
        return "upms/default/sysRolePower";
    }

    private List<Map<String, Object>> buildTree(List<SysPower> sysPowerList, Map<String, SysPower> sysPowerIdMap) {
        ArrayList<Map<String, Object>> treelist = new ArrayList<Map<String, Object>>();
        if (sysPowerList != null) {
            for (SysPower code : sysPowerList) {
                HashMap<String, Object> maptree = new HashMap<String, Object>();
                maptree.put("id", code.getId());
                maptree.put("text", code.getName());
                SysPower tmp = new SysPower();
                tmp.setStatus("1");
                tmp.setParent_id(code.getId());
                List<SysPower> parentlist = this.sysPowerService.querySysPowerList(tmp, null);
                if (parentlist != null && parentlist.size() > 0) {
                    List<Map<String, Object>> subTreelist = this.buildTree(parentlist, sysPowerIdMap);
                    maptree.put("state", "closed");
                    maptree.put("children", subTreelist);
                } else if (sysPowerIdMap.containsKey(code.getId())) {
                    maptree.put("checked", true);
                }
                treelist.add(maptree);
            }
        }
        return treelist;
    }

    @RequestMapping(value={"/upms/sysRoleController/saveSysRole.do"})
    public void saveSysRole(Role role, HttpServletResponse response, HttpServletRequest request) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            role.setCreator_id(this.person.getId());
            boolean flag = this.sysRoleService.queryRole(role);
            if (!flag) {
                this.sysRoleService.addRole(role);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "upms.page.error.role.exit"));
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/upms/sysRoleController/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        Role role = this.sysRoleService.queryRoleById(id);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", role.getId());
        map.put("name", role.getName());
        map.put("creator_id", role.getCreator_id());
        map.put("flag", role.getFlag());
        map.put("lastflag", role.getName());
        map.put("seq", role.getSeq());
        map.put("note", role.getNote());
        map.put("type", role.getType());
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/upms/sysRoleController/updateSysRole.do"})
    public void updateSysRole(Role role, String lastflag, HttpServletResponse response, HttpServletRequest request) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Role sys = this.sysRoleService.queryRoleById(role.getId());
            sys.setSeq(role.getSeq());
            sys.setName(role.getName());
            sys.setNote(role.getNote());
            sys.setFlag(role.getFlag());
            boolean flag = false;
            if (StringUtils.isNotBlank((CharSequence)lastflag) && !lastflag.equals(sys.getName())) {
                flag = this.sysRoleService.queryRole(role);
            }
            if (flag) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "upms.page.error.role.exit"));
            } else {
                this.sysRoleService.updateRole(sys);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/upms/sysRoleController/getDeptTreeChild.do"})
    public void getDeptTreeChild(String id, String deptid, HttpServletResponse response, HttpServletRequest request) throws IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            String rootId;
            id = rootId = this.getRootId(request);
        }
        Department dep = this.depService.queryDepById(id);
        List<Department> list = dep.getChildDeps();
        ArrayList treelist = new ArrayList();
        for (Department code : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", code.getId());
            map.put("text", code.getName());
            if (StringUtils.isBlank((CharSequence)deptid)) {
                map.put("state", "closed");
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("selectAble", "true");
                attributes.put("name", code.getName());
                map.put("attributes", attributes);
            }
            treelist.add(map);
        }
        String jsonlist = Util.toJsonStr(treelist);
        if (StringUtils.isBlank((CharSequence)id)) {
            jsonlist = "[{\"text\":\"\u5355\u4f4d\u5217\u8868\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/upms/sysRoleController/getPersonTreeChild.do"})
    public void getPersonTreeChild(String id, HttpServletResponse response) throws IOException {
        ArrayList treelist = new ArrayList();
        Department dep = this.depService.queryDepById(id);
        if (dep != null) {
            List<Person> list = dep.getPersonList();
            for (Person code : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", code.getId());
                map.put("text", code.getName());
                treelist.add(map);
            }
        }
        String jsonlist = Util.toJsonStr(treelist);
        if (StringUtils.isBlank((CharSequence)id)) {
            jsonlist = "[{\"text\":\"\u4eba\u5458\u5217\u8868\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/upms/sysRoleController/getRolePowerTreeChild.do"})
    public void getRolePowerTreeChild(String id, String powerid, HttpServletResponse response) throws IOException {
        SysPower sys = new SysPower();
        sys.setStatus("1");
        String[] groupids = powerid.split(",");
        if (StringUtils.isBlank((CharSequence)id)) {
            sys.setParent_id("0");
        } else {
            sys.setParent_id(id);
        }
        List<SysPower> list = this.sysPowerService.querySysPowerList(sys, null);
        ArrayList treelist = new ArrayList();
        for (SysPower code : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            sys = new SysPower();
            sys.setParent_id(code.getId());
            sys.setStatus("1");
            List<SysPower> parentlist = this.sysPowerService.querySysPowerList(sys, null);
            if (parentlist != null) {
                ArrayList treelists = new ArrayList();
                for (SysPower codes : parentlist) {
                    int i;
                    HashMap<String, Object> maps = new HashMap<String, Object>();
                    sys = new SysPower();
                    sys.setParent_id(codes.getId());
                    sys.setStatus("1");
                    List<SysPower> parentlists = this.sysPowerService.querySysPowerList(sys, null);
                    if (parentlists != null) {
                        ArrayList treelistss = new ArrayList();
                        for (SysPower codess : parentlists) {
                            HashMap<String, Object> mapss = new HashMap<String, Object>();
                            mapss.put("id", codess.getId());
                            mapss.put("text", codess.getName());
                            for (int i2 = 0; i2 < groupids.length; ++i2) {
                                if (!codess.getId().equals(groupids[i2])) continue;
                                mapss.put("checked", true);
                            }
                            treelistss.add(mapss);
                            maps.put("children", treelistss);
                        }
                    }
                    for (i = 0; i < groupids.length; ++i) {
                        if (!codes.getId().equals(groupids[i])) continue;
                        maps.put("checked", true);
                    }
                    for (i = 0; i < groupids.length; ++i) {
                        if (!code.getId().equals(groupids[i])) continue;
                        map.put("checked", true);
                    }
                    map.put("id", code.getId());
                    map.put("text", code.getName());
                    map.put("state", "open");
                    maps.put("id", codes.getId());
                    maps.put("text", codes.getName());
                    treelists.add(maps);
                    map.put("children", treelists);
                }
            } else {
                map.put("id", code.getId());
                map.put("text", code.getName());
            }
            treelist.add(map);
        }
        String jsonlist = Util.toJsonStr(treelist);
        jsonlist = "[{\"text\":\"\u6743\u9650\u5217\u8868\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/upms/sysRoleController/updatePersonRole.do"})
    public void updatePersonRole(String id, String personid, String depid, HttpServletResponse response) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        try {
            log.info("get personid:" + personid);
            if (this.person.getId().equals("0") && "40288cef41a15e770141a15e870f0002".equals(id) && !this.judgeIsContain0(personid)) {
                personid = personid + "0,";
            }
            log.info("property personid:" + personid);
            String[] person_id = null;
            if (StringUtils.isNotBlank((CharSequence)personid)) {
                person_id = personid.split(",");
            }
            String[] dep_id = null;
            if (StringUtils.isNotBlank((CharSequence)depid)) {
                dep_id = depid.split(",");
            }
            this.sysRoleService.updatePersonAndDepRoleByRoleid(id, person_id, dep_id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    private boolean judgeIsContain0(String personIds) {
        String[] personIDArray;
        if (null == personIds) {
            return false;
        }
        for (String id : personIDArray = personIds.split(",")) {
            if (!"0".equals(id)) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/upms/sysRoleController/updateGroupRole.do"})
    public void updateGroupRole(String id, String groupid, HttpServletResponse response) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        try {
            log.info("groupid:" + groupid);
            String[] groupid_id = groupid.split(",");
            this.sysRoleService.updateGroupRoleByRoleid(id, groupid_id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/upms/sysRoleController/updateRolePower.do"})
    public void updateRolePower(String id, String powerid, HttpServletResponse response) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        try {
            log.info("powerid:" + powerid);
            String[] power_id = powerid.split(",");
            this.sysRoleService.updateSysRolePowerByRoleid(id, power_id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }
}

