/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.control;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.upms.bean.QueryGprsConfigBean;
import com.xdja.pams.upms.bean.QueryTerminalPowerBean;
import com.xdja.pams.upms.entity.GprsMenu;
import com.xdja.pams.upms.service.TerminalPowerService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class TerminalPowerController
extends BaseControler {
    @Autowired
    private TerminalPowerService terminalPowerService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    private static final Logger log = LoggerFactory.getLogger(TerminalPowerController.class);

    @RequestMapping(value={"/upms/terminalPowerController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u7ba1\u7406\u9996\u9875\u5c55\u793a<\u5f00\u59cb>##########");
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error("#\u7ec8\u7aef\u6a21\u5757\u7ba1\u7406\u9996\u9875\u5c55\u793a\u5f02\u5e38", (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u7ba1\u7406\u9996\u9875\u5c55\u793a<\u7ed3\u675f>##########");
        return sendUrl;
    }

    @RequestMapping(value={"/upms/terminalPowerController/list.do"})
    public void list(HttpServletRequest request, HttpServletResponse response, PageParam page, QueryTerminalPowerBean queryTerminalPowerBean) {
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u67e5\u8be2<\u5f00\u59cb>##########");
        int operateResult = 1;
        String json = "";
        try {
            Page p = new Page(page.getPage(), page.getRows());
            List<GprsMenu> list = this.terminalPowerService.queryTerminalPowerList(queryTerminalPowerBean, p);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", p.getTotal());
            map.put("rows", list);
            json = Util.toJsonStr(map);
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("#\u7ec8\u7aef\u6a21\u5757\u67e5\u8be2\u5f02\u5e38", (Throwable)e2);
            json = "";
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, json);
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u67e5\u8be2<\u7ed3\u675f>##########");
    }

    @RequestMapping(value={"/upms/terminalPowerController/getTree.do"})
    public void getTree(String id, HttpServletResponse response) throws IOException {
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u7ba1\u7406\u6811\u5c55\u793a<\u5f00\u59cb>##########");
        QueryTerminalPowerBean power = new QueryTerminalPowerBean();
        String jsonlist = "";
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                power.setC_fjcd("0");
            } else {
                power.setC_fjcd(id);
            }
            List<GprsMenu> sysPowerList = this.terminalPowerService.queryTerminalPowerList(power, null);
            HashMap<String, GprsMenu> sysPowerIdMap = new HashMap<String, GprsMenu>();
            List<Map<String, Object>> treelist = this.buildTree(sysPowerList, sysPowerIdMap);
            jsonlist = Util.toJsonStr(treelist);
            String modules = MessageManager.getProMessage(this.message, "upms.page.info.modules");
            if (StringUtils.isBlank((CharSequence)id)) {
                jsonlist = "[{\"selectAble\":\"true\",\"text\":\"" + modules + "\",\"id\":\"0\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
            }
        }
        catch (Exception e2) {
            log.error("#\u7ec8\u7aef\u6a21\u5757\u7ba1\u7406\u6811\u5c55\u793a\u5f02\u5e38", (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u7ba1\u7406\u6811\u5c55\u793a<\u7ed3\u675f>##########");
    }

    private List<Map<String, Object>> buildTree(List<GprsMenu> sysPowerList, Map<String, GprsMenu> sysPowerIdMap) {
        ArrayList<Map<String, Object>> treelist = new ArrayList<Map<String, Object>>();
        try {
            if (sysPowerList != null) {
                for (GprsMenu code : sysPowerList) {
                    HashMap<String, Object> maptree = new HashMap<String, Object>();
                    maptree.put("id", code.getN_id());
                    maptree.put("text", code.getC_mc());
                    QueryTerminalPowerBean power = new QueryTerminalPowerBean();
                    power.setC_fjcd(code.getN_id());
                    List<GprsMenu> parentlist = this.terminalPowerService.queryTerminalPowerList(power, null);
                    if (parentlist != null && parentlist.size() > 0) {
                        List<Map<String, Object>> subTreelist = this.buildTree(parentlist, sysPowerIdMap);
                        maptree.put("state", "closed");
                        maptree.put("children", subTreelist);
                    }
                    treelist.add(maptree);
                }
            }
        }
        catch (Exception e2) {
            log.error("#\u7ec8\u7aef\u6a21\u5757\u7ba1\u7406\u6811\u5c01\u88c5\u5f02\u5e38", (Throwable)e2);
        }
        return treelist;
    }

    @RequestMapping(value={"/upms/terminalPowerController/forwardUpdatePage.do"})
    public String forwardUpdatePage(String id, ModelMap map) {
        try {
            map.put((Object)"id", (Object)id);
            QueryTerminalPowerBean bean = this.terminalPowerService.queryById(id);
            map.put((Object)"pid", (Object)bean.getC_fjcd());
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
        }
        return "upms/terminalpower/default/update";
    }

    @RequestMapping(value={"/upms/terminalPowerController/forwardAddPage.do"})
    public String forwardAddPage(String pid, ModelMap map) {
        try {
            QueryTerminalPowerBean menu;
            if (StringUtils.isNotBlank((CharSequence)pid) && !"0".equals(pid) && (menu = this.terminalPowerService.queryById(pid)) == null) {
                throw new Exception("\u975e\u6cd5\u7684\u53c2\u6570\u8bf7\u6c42");
            }
            map.put((Object)"pid", (Object)pid);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return "upms/terminalpower/default/add";
    }

    @RequestMapping(value={"/upms/terminalPowerController/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        QueryTerminalPowerBean bean = new QueryTerminalPowerBean();
        try {
            bean = this.terminalPowerService.queryById(id);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(bean));
    }

    @RequestMapping(value={"/upms/terminalPowerController/updateStatus.do"})
    public void updateStatus(QueryTerminalPowerBean bean, HttpServletResponse response, HttpServletRequest request) {
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u72b6\u6001\u4fee\u6539<\u5f00\u59cb>##########");
        int operateResult = 1;
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.terminalPowerService.updateStatus(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error("#\u7ec8\u7aef\u6a21\u5757\u72b6\u6001\u4fee\u6539\u5f02\u5e38", (Throwable)e2);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u72b6\u6001\u4fee\u6539<\u7ed3\u675f>##########");
    }

    @RequestMapping(value={"/upms/terminalPowerController/update.do"})
    public void update(QueryTerminalPowerBean bean, HttpServletResponse response, HttpServletRequest request) {
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u4fee\u6539<\u5f00\u59cb>##########");
        int operateResult = 1;
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.terminalPowerService.update(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error("#\u7ec8\u7aef\u6a21\u5757\u4fee\u6539\u5f02\u5e38", (Throwable)e2);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u4fee\u6539<\u7ed3\u675f>##########");
    }

    @RequestMapping(value={"/upms/terminalPowerController/save.do"})
    public void save(QueryTerminalPowerBean bean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u6dfb\u52a0<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            this.terminalPowerService.save(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error("#\u7ec8\u7aef\u6a21\u5757\u6dfb\u52a0\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
            operateResult = 0;
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u6dfb\u52a0<\u5f00\u59cb>##########");
    }

    @RequestMapping(value={"/upms/terminalPowerController/del.do"})
    public void del(String id, HttpServletResponse response, HttpServletRequest request) {
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u5220\u9664<\u5f00\u59cb>##########");
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            QueryTerminalPowerBean bean = new QueryTerminalPowerBean();
            bean.setN_id(id);
            this.terminalPowerService.delete(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.debug("#\u7ec8\u7aef\u6a21\u5757\u5220\u9664\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
            operateResult = 0;
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        log.debug("##########\u7ec8\u7aef\u6a21\u5757\u5220\u9664<\u7ed3\u675f>##########");
    }

    @RequestMapping(value={"/upms/terminalPowerController/queryByQqlb.do"})
    public void queryByQqlb(String q, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (StringUtils.isBlank((CharSequence)q)) {
                map.put("total", "0");
                map.put("rows", new ArrayList());
            } else {
                Page page = new Page();
                page.setPage(1);
                page.setRp(20);
                List<QueryGprsConfigBean> list = this.terminalPowerService.queryGprsConfigByQqlb(q.trim(), page);
                ArrayList listmap = new ArrayList();
                for (QueryGprsConfigBean qgcbean : list) {
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("name", qgcbean.getC_ZWMC());
                    map1.put("qqlb", qgcbean.getC_QQLB());
                    map1.put("qx", qgcbean.getC_QX());
                    listmap.add(map1);
                }
                map.put("total", listmap.size());
                map.put("rows", listmap);
            }
        }
        catch (Exception e2) {
            log.error("\u6839\u636e\u8bf7\u6c42\u7c7b\u522b\u67e5\u8be2\u7ec8\u7aef\u6743\u9650\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }
}

