/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.control;

import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.GroupManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.upms.bean.QueryRoleBean;
import com.xdja.pams.upms.bean.QueryTerminalPowerBean;
import com.xdja.pams.upms.entity.GprsMenu;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.SysRoleService;
import com.xdja.pams.upms.service.TerminalPowerService;
import com.xdja.pams.upms.service.TerminalRoleService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class TerminalRoleController
extends BaseControler {
    @Autowired
    private TerminalRoleService terminalRoleService;
    @Autowired
    private DepManageService depService;
    @Autowired
    private GroupManageService groupManageService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private TerminalPowerService terminalPowerService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SysRoleService sysRoleService;
    private static final Logger log = LoggerFactory.getLogger(TerminalRoleController.class);
    @Autowired
    private ResourceBundleMessageSource message;

    @RequestMapping(value={"/upms/terminalRoleController/listSysRole.do"})
    public String listSysRole(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"person_id", (Object)this.person.getId());
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/upms/terminalRoleController/querySysRole.do"})
    public void querySysRole(HttpServletRequest request, HttpServletResponse response, PageParam page, QueryRoleBean role) {
        int operateResult = 1;
        try {
            role.setCreator_id(this.person.getId());
            role.setFlag("1");
            Page p = new Page(page.getPage(), page.getRows());
            List<Role> sysRoleList = this.terminalRoleService.queryRoleList(role, p);
            ArrayList codelist = new ArrayList();
            for (Role sysrole : sysRoleList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", sysrole.getId());
                map.put("name", sysrole.getName());
                map.put("flag", sysrole.getFlag());
                map.put("type", sysrole.getType());
                map.put("seq", sysrole.getSeq());
                map.put("note", sysrole.getNote());
                Person personname = this.userManageService.queryPersonById(sysrole.getCreator_id());
                if (personname != null) {
                    String creator_name = personname.getName();
                    map.put("creator_name", creator_name);
                } else {
                    map.put("creator_name", "");
                }
                map.put("creator_id", sysrole.getCreator_id());
                codelist.add(map);
            }
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("total", Integer.valueOf(p.getTotal()));
            map.put("rows", codelist);
            Util.writeUtf8Text(response, Util.toJsonStr(map));
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/upms/terminalRoleController/del.do"})
    public void del(String id, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 1;
        ReturnResult rtnResult = new ReturnResult();
        try {
            Role r = this.terminalRoleService.queryRoleById(id);
            if (r.getPersonSet().size() > 0) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "upms.page.error.role.hasPerson"));
            } else if (r.getGroupSet().size() > 0) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "upms.page.error.role.hasGroup"));
            } else {
                r.setPersonSet(null);
                r.setGroupSet(null);
                r.setGprsMenuSet(null);
                this.terminalRoleService.deleteRole(r);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/upms/terminalRoleController/forwardUpdatePage.do"})
    public String forwardUpdatePage(String id, ModelMap map) {
        map.put((Object)"id", (Object)id);
        return "upms/default/updateTerminalRole";
    }

    @RequestMapping(value={"/upms/terminalRoleController/forwardAddPage.do"})
    public String forwardAddPage(String id, ModelMap map) {
        return "upms/default/addTerminalRole";
    }

    @RequestMapping(value={"/upms/terminalRoleController/forwardPersonRolePage.do"})
    public String forwardPersonRolePage(String id, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        try {
            map.put((Object)"id", (Object)id);
            Role r = this.terminalRoleService.queryRoleById(id);
            List<Person> personlist = r.getPersonSet();
            List<Department> depList = r.getDepartmentSet();
            request.setAttribute("depList", depList);
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember1.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return "upms/default/terminalPersonRole";
    }

    @RequestMapping(value={"/upms/terminalRoleController/forwardGroupRolePage.do"})
    public String forwardGroupRolePage(String id, ModelMap map, HttpServletResponse response) {
        try {
            Role r = this.terminalRoleService.queryRoleById(id);
            map.put((Object)"id", (Object)id);
            List<BimsGroup> grouplist = r.getGroupSet();
            String groupid = "";
            for (BimsGroup code : grouplist) {
                groupid = groupid + code.getId() + ",";
            }
            map.put((Object)"groupid", (Object)groupid);
            String jsonlist = this.sysRoleService.getGroupTreeChild(null, this.person.getId(), this.operator.getControlDeps(), groupid);
            map.put((Object)"treelist", (Object)jsonlist);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return "upms/default/terminalGroupRole";
    }

    @RequestMapping(value={"/upms/terminalRoleController/forwardRolePowerPage.do"})
    public String forwardRolePowerPage(String id, ModelMap map, HttpServletResponse response) {
        log.info("forwardRolePowerPage.................");
        try {
            Role r = this.terminalRoleService.queryRoleById(id);
            map.put((Object)"id", (Object)id);
            List<GprsMenu> terminalpower = r.getGprsMenuSet();
            HashMap<String, GprsMenu> sysPowerIdMap = new HashMap<String, GprsMenu>();
            for (GprsMenu code : terminalpower) {
                sysPowerIdMap.put(code.getN_id(), code);
            }
            QueryTerminalPowerBean power = new QueryTerminalPowerBean();
            power.setC_fjcd("0");
            power.setC_zt("1");
            List<GprsMenu> sysPowerList = this.terminalPowerService.queryTerminalPowerList(power, null);
            List<Map<String, Object>> treelist = this.buildTree(sysPowerList, sysPowerIdMap);
            String jsonlist = Util.toJsonStr(treelist);
            jsonlist = "[{\"text\":\"\u6743\u9650\u5217\u8868\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
            map.put((Object)"treeJson", (Object)jsonlist);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return "upms/default/terminalRolePower";
    }

    private List<Map<String, Object>> buildTree(List<GprsMenu> sysPowerList, Map<String, GprsMenu> sysPowerIdMap) {
        ArrayList<Map<String, Object>> treelist = new ArrayList<Map<String, Object>>();
        try {
            if (sysPowerList != null) {
                for (GprsMenu code : sysPowerList) {
                    HashMap<String, Object> maptree = new HashMap<String, Object>();
                    maptree.put("id", code.getN_id());
                    maptree.put("text", code.getC_mc());
                    QueryTerminalPowerBean power = new QueryTerminalPowerBean();
                    power.setC_zt("1");
                    power.setC_fjcd(code.getN_id());
                    List<GprsMenu> parentlist = this.terminalPowerService.queryTerminalPowerList(power, null);
                    if (parentlist != null && parentlist.size() > 0) {
                        List<Map<String, Object>> subTreelist = this.buildTree(parentlist, sysPowerIdMap);
                        maptree.put("state", "closed");
                        maptree.put("children", subTreelist);
                    } else if (sysPowerIdMap.containsKey(code.getN_id())) {
                        log.info("checked:true");
                        maptree.put("checked", true);
                    }
                    treelist.add(maptree);
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return treelist;
    }

    @RequestMapping(value={"/upms/terminalRoleController/saveSysRole.do"})
    public void saveSysRole(Role role, HttpServletResponse response, HttpServletRequest request) throws IOException {
        int operateResult = 1;
        ReturnResult rtnResult = new ReturnResult();
        try {
            role.setCreator_id(this.person.getId());
            boolean flag = this.terminalRoleService.queryRole(role);
            if (!flag) {
                this.terminalRoleService.addRole(role);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "upms.page.error.role.exit"));
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/upms/terminalRoleController/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Role role = this.terminalRoleService.queryRoleById(id);
            map.put("id", role.getId());
            map.put("name", role.getName());
            map.put("creator_id", role.getCreator_id());
            map.put("lastflag", role.getName());
            map.put("flag", role.getFlag());
            map.put("seq", role.getSeq());
            map.put("note", role.getNote());
            map.put("type", role.getType());
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/upms/terminalRoleController/updateSysRole.do"})
    public void updateSysRole(Role role, String lastflag, HttpServletResponse response) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Role sys = this.terminalRoleService.queryRoleById(role.getId());
            sys.setSeq(role.getSeq());
            sys.setName(role.getName());
            sys.setNote(role.getNote());
            sys.setFlag(role.getFlag());
            boolean flag = false;
            if (StringUtils.isNotBlank((CharSequence)lastflag) && !lastflag.equals(sys.getName())) {
                flag = this.sysRoleService.queryRole(role);
            }
            if (flag) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "upms.page.error.role.exit"));
            } else {
                this.terminalRoleService.updateRole(sys);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/upms/terminalRoleController/getDeptTreeChild.do"})
    public void getDeptTreeChild(String id, String deptid, HttpServletResponse response, HttpServletRequest request) throws IOException {
        String jsonlist = "";
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                String rootId;
                id = rootId = this.getRootId(request);
            }
            Department dep = this.depService.queryDepById(id);
            List<Department> list = dep.getChildDeps();
            ArrayList treelist = new ArrayList();
            for (Department code : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", code.getId());
                map.put("text", code.getName());
                if (StringUtils.isBlank((CharSequence)deptid)) {
                    map.put("state", "closed");
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("selectAble", "true");
                    attributes.put("name", code.getName());
                    map.put("attributes", attributes);
                }
                treelist.add(map);
            }
            jsonlist = Util.toJsonStr(treelist);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            jsonlist = "[{\"text\":\"\u5355\u4f4d\u5217\u8868\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/upms/terminalRoleController/getPersonTreeChild.do"})
    public void getPersonTreeChild(String id, HttpServletResponse response) throws IOException {
        String jsonlist = "";
        try {
            ArrayList treelist = new ArrayList();
            Department dep = this.depService.queryDepById(id);
            if (dep != null) {
                List<Person> list = dep.getPersonList();
                for (Person code : list) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", code.getId());
                    map.put("text", code.getName());
                    treelist.add(map);
                }
            }
            jsonlist = Util.toJsonStr(treelist);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            jsonlist = "[{\"text\":\"\u4eba\u5458\u5217\u8868\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/upms/terminalRoleController/getRolePowerTreeChild.do"})
    public void getRolePowerTreeChild(String id, String powerid, HttpServletResponse response) throws IOException {
        String jsonlist = "";
        try {
            QueryTerminalPowerBean power = new QueryTerminalPowerBean();
            if (StringUtils.isBlank((CharSequence)id)) {
                power.setC_fjcd("0");
            } else {
                power.setC_fjcd(id);
            }
            List<GprsMenu> list = this.terminalPowerService.queryTerminalPowerList(power, null);
            ArrayList treelist = new ArrayList();
            for (GprsMenu code : list) {
                HashMap<String, Object> maptree = new HashMap<String, Object>();
                maptree.put("id", code.getN_id());
                maptree.put("text", code.getC_mc());
                if (StringUtils.isBlank((CharSequence)id)) {
                    maptree.put("state", "closed");
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("selectAble", "true");
                    attributes.put("pid", code.getC_fjcd());
                    attributes.put("name", code.getC_mc());
                    maptree.put("attributes", attributes);
                }
                String[] groupids = powerid.split(",");
                for (int i = 0; i < groupids.length; ++i) {
                    if (!code.getN_id().equals(groupids[i])) continue;
                    maptree.put("checked", true);
                }
                treelist.add(maptree);
            }
            jsonlist = Util.toJsonStr(treelist);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            jsonlist = "[{\"text\":\"\u6743\u9650\u5217\u8868\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/upms/terminalRoleController/updatePersonRole.do"})
    public void updatePersonRole(String id, String personid, String depid, HttpServletResponse response) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        try {
            log.info("personid:" + personid);
            String[] person_id = null;
            if (StringUtils.isNotBlank((CharSequence)personid)) {
                person_id = personid.split(",");
            }
            String[] dep_id = null;
            if (StringUtils.isNotBlank((CharSequence)depid)) {
                dep_id = depid.split(",");
            }
            this.terminalRoleService.updatePersonAndDepRoleByRoleid(id, person_id, dep_id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/upms/terminalRoleController/updateGroupRole.do"})
    public void updateGroupRole(String id, String groupid, HttpServletResponse response) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        try {
            log.info("groupid:" + groupid);
            String[] groupid_id = groupid.split(",");
            this.terminalRoleService.updateGroupRoleByRoleid(id, groupid_id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/upms/terminalRoleController/updateRolePower.do"})
    public void updateRolePower(String id, String powerid, HttpServletResponse response) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        try {
            log.info("powerid:" + powerid);
            String[] power_id = powerid.split(",");
            this.terminalRoleService.updateTerminalRolePowerByRoleid(id, power_id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }
}

