/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.service.impl;

import com.xdja.pams.bims.bean.QueryGroupBean;
import com.xdja.pams.bims.dao.BimsGroupDao;
import com.xdja.pams.bims.dao.DepartmentDao;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.GroupManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.upms.bean.QueryRoleBean;
import com.xdja.pams.upms.dao.SysPowerDao;
import com.xdja.pams.upms.dao.SysRoleDao;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.entity.SysPower;
import com.xdja.pams.upms.service.SysRoleService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleServiceImpl
implements SysRoleService {
    @Autowired
    private SysRoleDao sysRoleDao;
    @Autowired
    private PersonDao personDao;
    @Autowired
    private SysPowerDao sysPowerDao;
    @Autowired
    private BimsGroupDao bimsGroupDao;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private GroupManageService groupManageService;

    @Override
    public Role queryRoleById(String roleid) {
        return this.sysRoleDao.queryRoleById(roleid);
    }

    @Override
    public List<Role> queryRoleList(Role role, Page page) {
        return this.sysRoleDao.queryRoleList(role, page);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Role addRole(Role role) {
        return this.sysRoleDao.addRole(role);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateRole(Role role) {
        this.sysRoleDao.updateRole(role);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteRole(Role role) {
        this.sysRoleDao.deleteRole(role);
    }

    @Override
    public List<SysPower> querySysRolePower(Role role) {
        Role p = this.sysRoleDao.queryRoleById(role.getId());
        return p.getSysPowerSet();
    }

    @Override
    public List<Role> querySysRoleList() {
        return this.sysRoleDao.querySysRoleList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updatePersonRoleByRoleid(String role_id, String[] person_id) {
        Role r = this.sysRoleDao.queryRoleById(role_id);
        r.setPersonSet(null);
        this.sysRoleDao.updateRole(r);
        ArrayList<Person> personList = new ArrayList<Person>();
        for (int i = 0; i < person_id.length; ++i) {
            Person p = this.personDao.queryPersonById(person_id[i]);
            personList.add(p);
        }
        r.setPersonSet(personList);
        this.sysRoleDao.updateRole(r);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updatePersonAndDepRoleByRoleid(String role_id, String[] person_id, String[] dep_id) {
        Role r = this.sysRoleDao.queryRoleById(role_id);
        r.setPersonSet(null);
        r.setDepartmentSet(null);
        this.sysRoleDao.updateRole(r);
        ArrayList<Person> personList = new ArrayList<Person>();
        if (person_id != null) {
            for (int i = 0; i < person_id.length; ++i) {
                Person p = this.personDao.queryPersonById(person_id[i]);
                personList.add(p);
            }
        }
        ArrayList<Department> depList = new ArrayList<Department>();
        if (dep_id != null) {
            for (int i = 0; i < dep_id.length; ++i) {
                Department d = this.departmentDao.queryDepartmentById(dep_id[i]);
                depList.add(d);
            }
        }
        r.setPersonSet(personList);
        r.setDepartmentSet(depList);
        this.sysRoleDao.updateRole(r);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateGroupRoleByRoleid(String role_id, String[] group_id) {
        Role r = this.sysRoleDao.queryRoleById(role_id);
        r.setGroupSet(null);
        this.sysRoleDao.updateRole(r);
        ArrayList<BimsGroup> groupList = new ArrayList<BimsGroup>();
        for (int i = 0; i < group_id.length; ++i) {
            BimsGroup g = this.bimsGroupDao.queryGroupById(group_id[i]);
            groupList.add(g);
        }
        r.setGroupSet(groupList);
        this.sysRoleDao.updateRole(r);
    }

    @Override
    public List<Person> queryPersonListByRole(Role role) {
        Role p = this.sysRoleDao.queryRoleById(role.getId());
        return p.getPersonSet();
    }

    @Override
    public List<BimsGroup> queryGroupListByRole(Role role) {
        Role p = this.sysRoleDao.queryRoleById(role.getId());
        return p.getGroupSet();
    }

    @Override
    public List<SysPower> querySysPowerList() {
        return this.sysPowerDao.querySysPowerList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateSysRolePowerByRoleid(String roleid, String[] powerid) {
        Role r = this.sysRoleDao.queryRoleById(roleid);
        r.setSysPowerSet(null);
        this.sysRoleDao.updateRole(r);
        ArrayList<SysPower> sysPowerList = new ArrayList<SysPower>();
        for (int i = 0; i < powerid.length; ++i) {
            SysPower p = this.sysPowerDao.queryById(powerid[i]);
            sysPowerList.add(p);
        }
        r.setSysPowerSet(sysPowerList);
        this.sysRoleDao.updateRole(r);
    }

    @Override
    public List<Role> queryRoleList(QueryRoleBean queryrolebean, Page page) {
        return this.sysRoleDao.queryRoleList(queryrolebean, page);
    }

    @Override
    public List<Role> queryDefaultRoleList() {
        return this.sysRoleDao.queryDefaultRoleList();
    }

    @Override
    public boolean queryRole(Role role) {
        return this.sysRoleDao.queryRole(role);
    }

    @Override
    public String getGroupTreeChild(String id, String personId, String controlDesps, String groupid) {
        String jsonlist = "";
        QueryGroupBean queryGroupBean = new QueryGroupBean();
        queryGroupBean.setCreatorID(personId);
        queryGroupBean.setType("1");
        List<BimsGroup> list = this.groupManageService.queryGroupList(queryGroupBean, controlDesps, null);
        ArrayList treelist = new ArrayList();
        for (BimsGroup code : list) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", code.getId());
            map1.put("text", code.getName() + "-" + code.getDepartment().getName());
            String[] groupids = groupid.split(",");
            for (int i = 0; i < groupids.length; ++i) {
                if (!code.getId().equals(groupids[i])) continue;
                map1.put("checked", true);
            }
            treelist.add(map1);
        }
        jsonlist = Util.toJsonStr(treelist);
        if (StringUtils.isBlank((CharSequence)id)) {
            jsonlist = "[{\"text\":\"\u5206\u7ec4\u5217\u8868\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        }
        return jsonlist;
    }
}

