/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.service.impl;

import com.xdja.pams.bims.dao.BimsGroupDao;
import com.xdja.pams.bims.dao.DepartmentDao;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.upms.bean.QueryRoleBean;
import com.xdja.pams.upms.dao.TerminalPowerDao;
import com.xdja.pams.upms.dao.TerminalRoleDao;
import com.xdja.pams.upms.entity.GprsMenu;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.TerminalRoleService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalRoleServiceImpl
implements TerminalRoleService {
    @Autowired
    private TerminalRoleDao terminalRoleDao;
    @Autowired
    private TerminalPowerDao terminalPowerDao;
    @Autowired
    private PersonDao personDao;
    @Autowired
    private BimsGroupDao bimsGroupDao;
    @Autowired
    private DepartmentDao departmentDao;

    @Override
    public Role queryRoleById(String roleid) {
        return this.terminalRoleDao.queryRoleById(roleid);
    }

    @Override
    public List<Role> queryRoleList(Role role, Page page) {
        return this.terminalRoleDao.queryRoleList(role, page);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Role addRole(Role role) {
        return this.terminalRoleDao.addRole(role);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateRole(Role role) {
        this.terminalRoleDao.updateRole(role);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteRole(Role role) {
        this.terminalRoleDao.deleteRole(role);
    }

    @Override
    public List<GprsMenu> queryTerminalRolePower(Role role) {
        Role p = this.terminalRoleDao.queryRoleById(role.getId());
        return p.getGprsMenuSet();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updatePersonRoleByRoleid(String role_id, String[] person_id) {
        Role r = this.terminalRoleDao.queryRoleById(role_id);
        r.setPersonSet(null);
        this.terminalRoleDao.updateRole(r);
        ArrayList<Person> personList = new ArrayList<Person>();
        for (int i = 0; i < person_id.length; ++i) {
            Person p = this.personDao.queryPersonById(person_id[i]);
            personList.add(p);
        }
        r.setPersonSet(personList);
        this.terminalRoleDao.updateRole(r);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updatePersonAndDepRoleByRoleid(String role_id, String[] person_id, String[] dep_id) {
        Role r = this.terminalRoleDao.queryRoleById(role_id);
        r.setPersonSet(null);
        r.setDepartmentSet(null);
        this.terminalRoleDao.updateRole(r);
        ArrayList<Person> personList = new ArrayList<Person>();
        if (person_id != null) {
            for (int i = 0; i < person_id.length; ++i) {
                Person p = this.personDao.queryPersonById(person_id[i]);
                personList.add(p);
            }
        }
        ArrayList<Department> depList = new ArrayList<Department>();
        if (dep_id != null) {
            for (int i = 0; i < dep_id.length; ++i) {
                Department d = this.departmentDao.queryDepartmentById(dep_id[i]);
                depList.add(d);
            }
        }
        r.setPersonSet(personList);
        r.setDepartmentSet(depList);
        this.terminalRoleDao.updateRole(r);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateGroupRoleByRoleid(String role_id, String[] group_id) {
        Role r = this.terminalRoleDao.queryRoleById(role_id);
        r.setGroupSet(null);
        this.terminalRoleDao.updateRole(r);
        ArrayList<BimsGroup> groupList = new ArrayList<BimsGroup>();
        for (int i = 0; i < group_id.length; ++i) {
            BimsGroup g = this.bimsGroupDao.queryGroupById(group_id[i]);
            groupList.add(g);
        }
        r.setGroupSet(groupList);
        this.terminalRoleDao.updateRole(r);
    }

    @Override
    public List<Person> queryPersonListByRole(Role role) {
        Role p = this.terminalRoleDao.queryRoleById(role.getId());
        return p.getPersonSet();
    }

    @Override
    public List<BimsGroup> queryGroupListByRole(Role role) {
        Role p = this.terminalRoleDao.queryRoleById(role.getId());
        return p.getGroupSet();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateTerminalRolePowerByRoleid(String roleid, String[] powerid) {
        Role r = this.terminalRoleDao.queryRoleById(roleid);
        r.setGprsMenuSet(null);
        this.terminalRoleDao.updateRole(r);
        ArrayList<GprsMenu> terminalPowerList = new ArrayList<GprsMenu>();
        for (int i = 0; i < powerid.length; ++i) {
            GprsMenu p = this.terminalPowerDao.queryById(powerid[i]);
            terminalPowerList.add(p);
        }
        r.setGprsMenuSet(terminalPowerList);
        this.terminalRoleDao.updateRole(r);
    }

    @Override
    public List<GprsMenu> queryTerminalPowerList() {
        return this.terminalPowerDao.querySysPowerList();
    }

    @Override
    public List<Role> queryRoleList(QueryRoleBean role, Page page) {
        return this.terminalRoleDao.queryRoleList(role, page);
    }

    @Override
    public boolean queryRole(Role role) {
        return this.terminalRoleDao.queryRole(role);
    }
}

