/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.wfms.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowUtils {
    private static Logger logger = LoggerFactory.getLogger(WorkflowUtils.class);

    public static String parseToZhType(String type) {
        HashMap<String, String> types = new HashMap<String, String>();
        types.put("userTask", "\u7528\u6237\u4efb\u52a1");
        types.put("serviceTask", "\u7cfb\u7edf\u4efb\u52a1");
        types.put("startEvent", "\u5f00\u59cb\u8282\u70b9");
        types.put("endEvent", "\u7ed3\u675f\u8282\u70b9");
        types.put("exclusiveGateway", "\u6761\u4ef6\u5224\u65ad\u8282\u70b9(\u7cfb\u7edf\u81ea\u52a8\u6839\u636e\u6761\u4ef6\u5904\u7406)");
        types.put("inclusiveGateway", "\u5e76\u884c\u5904\u7406\u4efb\u52a1");
        types.put("callActivity", "\u5b50\u6d41\u7a0b");
        return types.get(type) == null ? type : (String)types.get(type);
    }

    public static String exportDiagramToFile(RepositoryService repositoryService, ProcessDefinition processDefinition, String exportDir) throws IOException {
        File file;
        String diagramResourceName = processDefinition.getDiagramResourceName();
        String key = processDefinition.getKey();
        int version = processDefinition.getVersion();
        String diagramPath = "";
        InputStream resourceAsStream = repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), diagramResourceName);
        byte[] b = new byte[resourceAsStream.available()];
        int len = -1;
        resourceAsStream.read(b, 0, b.length);
        String diagramDir = exportDir + "/" + key + "/" + version;
        File diagramDirFile = new File(diagramDir);
        if (!diagramDirFile.exists()) {
            diagramDirFile.mkdirs();
        }
        if ((file = new File(diagramPath = diagramDir + "/" + diagramResourceName)).exists()) {
            logger.debug("diagram exist, ignore... : {}", (Object)diagramPath);
            return diagramPath;
        }
        file.createNewFile();
        logger.debug("export diagram to : {}", (Object)diagramPath);
        FileUtils.writeByteArrayToFile((File)file, (byte[])b, (boolean)true);
        return diagramPath;
    }
}

