/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.wfms.control;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.wfms.entity.Group;
import com.xdja.pams.wfms.service.WorkflowManagerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class WorkflowGroupControler
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(WorkflowGroupControler.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private WorkflowManagerService wms;
    @Autowired
    private SystemLogService systemLogService;

    @RequestMapping(value={"/wfms/workflowGroupControler/workflowGroupManager.do"})
    public String workflowGroupManager(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/wfms/workflowGroupControler/showAddGroupPage.do"})
    public String showAddGroupPage(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = null;
        try {
            sendUrl = page.getSendUrl();
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/wfms/workflowGroupControler/getWorkflowGroupList.do"})
    public void getWorkflowGroupList(Group group, PageParam page, HttpServletRequest request, HttpServletResponse response) {
        int operateResult = 1;
        String jsonStr = "";
        ArrayList<Group> rtnList = null;
        try {
            Page p = new Page(page.getPage(), page.getRows());
            List<Group> tmpList = this.wms.getWorkflowGroupList(group, p);
            if (tmpList != null) {
                rtnList = new ArrayList<Group>();
                for (Group g : tmpList) {
                    Group newGroup = new Group();
                    newGroup.setId(g.getId());
                    newGroup.setName(g.getName());
                    newGroup.setType(g.getType());
                    rtnList.add(newGroup);
                }
            }
            HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
            rtnMap.put("total", Integer.valueOf(p.getTotal()));
            rtnMap.put("rows", rtnList == null ? new ArrayList<Group>() : rtnList);
            jsonStr = Util.toJsonStr(rtnMap);
        }
        catch (Exception e1) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u6d41\u7a0b\u7ec4\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            jsonStr = "";
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, jsonStr);
    }

    @RequestMapping(value={"/wfms/workflowGroupControler/addWfg.do"})
    public void addWfg(HttpServletRequest request, HttpServletResponse response, Group group) {
        ReturnResult rr = new ReturnResult();
        int operateResult = 1;
        try {
            if (group != null) {
                group.setType("security-role");
                this.wms.addWorkflowGroup(group);
                rr.setRtnCode("0");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (DataIntegrityViolationException e1) {
            log.error("\u6dfb\u52a0\u6d41\u7a0b\u7ec4\u51fa\u73b0\u91cd\u590d\u7684\u6d41\u7a0b\u7ec4CODE");
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "wfms.error.addGroup"));
        }
        catch (Exception e2) {
            log.error("\u6dfb\u52a0\u6d41\u7a0b\u7ec4\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e2);
            operateResult = 0;
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/wfms/workflowGroupControler/deleteWfg.do"})
    public void deleteWfg(HttpServletRequest request, HttpServletResponse response, String workflowGroupId) {
        ReturnResult rr = new ReturnResult();
        int operateResult = 1;
        try {
            if (!Util.varCheckEmp(workflowGroupId)) {
                this.wms.deleteWorkflowGroup(workflowGroupId);
                rr.setRtnCode("0");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u5220\u9664\u6d41\u7a0b\u7ec4\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e2);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/wfms/workflowGroupControler/addGroupUser.do"})
    public void addGroupUser(HttpServletRequest request, HttpServletResponse response, String selectId, String depId, String groupId) {
        ReturnResult rr = new ReturnResult();
        try {
            if (!Util.varCheckEmp(groupId)) {
                this.wms.addGroupUserAndDep(selectId, depId, groupId);
                rr.setRtnCode("0");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (Exception e2) {
            log.error("\u4fee\u6539\u6d41\u7a0b\u7ec4\u4eba\u5458\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e2);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/wfms/workflowGroupControler/getGroupUserList.do"})
    public String getGroupUserList(HttpServletRequest request, HttpServletResponse response, String workflowGroupId) {
        String sendUrl = null;
        try {
            if (!Util.varCheckEmp(workflowGroupId)) {
                List<Person> userList = this.wms.getGroupUserListAsPerson(workflowGroupId);
                List<Department> depList = this.wms.getWorkflowGroupById(workflowGroupId).getActIdDeps();
                request.setAttribute("depList", depList);
                request.setAttribute("personList", userList);
                request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember1.do").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u6307\u5b9a\u5206\u7ec4\u7684\u4eba\u5458\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e2);
            sendUrl = "error/error";
        }
        return sendUrl;
    }
}

