/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.accredit.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.tims.bean.AppNoticeBean;
import com.xdja.pams.tims.service.MsgPushService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.accredit.bean.AppUseAreaAccredit;
import pams.function.mdp.accredit.bean.ReturnObj;
import pams.function.mdp.accredit.service.AccreditService;
import pams.function.mdp.app.bean.AppBean;
import pams.function.mdp.app.service.AppManagerService;
import pams.function.mdp.syms.service.MdpSystemConfigService;

@Controller
@Scope(value="session")
public class AccreditControler
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    AccreditService accreditService;
    @Autowired
    CommonCodeService commonCodeService;
    @Autowired
    AppManagerService appManagerService;
    @Autowired
    MsgPushService sendAppNotice;
    @Autowired
    MdpSystemConfigService mdpSystemConfigService;
    private static final Logger log = LoggerFactory.getLogger(AccreditControler.class);

    @RequestMapping(value={"/accredit/AccreditControler/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        String fastdfsUrl = "";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL");
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        return sendUrl;
    }

    @RequestMapping(value={"/accredit/AccreditControler/forwardPersonRolePage.do"})
    public String forwardPersonRolePage(String appId, String isTmp, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        try {
            List<Person> personlist = null;
            personlist = "1".equals(isTmp) ? this.accreditService.getUseAppTmp(appId) : this.accreditService.getUseApp(appId);
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMemberNew.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
        }
        return "accredit/default/ddd";
    }

    @RequestMapping(value={"/accredit/AccreditControler/add.do"})
    public void add(HttpServletRequest request, HttpServletResponse response, ModelMap map, AppUseAreaAccredit appUseAreaAccredit) {
        ReturnResult rtnResult = new ReturnResult();
        boolean operateResult = true;
        String result = "";
        try {
            result = this.accreditService.addUseApp(appUseAreaAccredit);
            ReturnObj returnObj = Util.readValue(result, ReturnObj.class);
            if (null != returnObj && returnObj.getFlag().equals("0")) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (Exception e2) {
            operateResult = false;
            log.error("\u4fdd\u5b58\u6388\u6743\u5931\u8d25\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/accredit/AccreditControler/querAppList.do"})
    public void queryAppList(HttpServletRequest request, HttpServletResponse response, ModelMap map, String type, String code, String name, PageParam pageParam, String id) {
        int operateResult = 1;
        this.setOperator(request);
        String AppListStr = "";
        try {
            AppListStr = this.accreditService.queryAppList(type, pageParam.getRows(), pageParam.getPage(), code, name, id);
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
            AppListStr = "{\"total\": 0,\"rows\": []}";
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, AppListStr);
    }

    @RequestMapping(value={"/accredit/AccreditControler/queryGroup.do"})
    public void query(HttpServletResponse response, String appId) {
        ArrayList listmap = new ArrayList();
        List<Object> personlist = new ArrayList();
        List<CommonCode> list = this.commonCodeService.queryByTypeId("40288cde4b541981014b543c56c00046");
        try {
            personlist = this.accreditService.getUseApp(appId);
            listmap = new ArrayList();
            for (Person person : personlist) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", person.getId());
                map.put("name", person.getName());
                map.put("code", person.getCode());
                map.put("flag", person.getFlag());
                for (CommonCode commonCode : list) {
                    if (!person.getFlag().equals(commonCode.getCode())) continue;
                    map.put("group", commonCode.getName());
                    break;
                }
                listmap.add(map);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(personlist.size()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/accredit/AccreditControler/sendAppNotice.do"})
    public void sendAppNotice(HttpServletRequest request, HttpServletResponse response, ModelMap map, String appId) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        this.setOperator(request);
        String AppListStr = "";
        try {
            AppNoticeBean appNoticeBean = new AppNoticeBean();
            AppBean appBean = this.appManagerService.getAppManager(appId);
            String sendContent = "\u5e94\u7528\u540d\u79f0\u4e3a\uff1a" + appBean.getAppName() + "\u5347\u7ea7\u5ba1\u6838\u5df2\u901a\u8fc7\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7248\u672c\u5e94\u7528\u5305\uff01";
            appNoticeBean.setAppId(appId);
            appNoticeBean.setAppName(appBean.getAppName());
            appNoticeBean.setPackageName(appBean.getAppPackage());
            appNoticeBean.setMsg(sendContent);
            sendContent = "\u5e94\u7528\u540d\u79f0\u4e3a\uff1a" + appBean.getAppName() + "\u5df2\u4e0a\u7ebf\uff0c\u8bf7\u4e0b\u8f7d\u4f7f\u7528\uff01";
            this.sendAppNotice.sendAddAppNotice(appNoticeBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "accredit.app.pushmsg.err"));
            log.error("\u5e94\u7528\u6388\u6743\u540e\u63a8\u9001\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }
}

