/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.control;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pams.function.mdp.app.bean.AppCommentQueryBean;
import pams.function.mdp.app.bean.AppCommentReplyBean;
import pams.function.mdp.app.bean.AppCommentReplyQueryBean;
import pams.function.mdp.app.bean.PageBean;
import pams.function.mdp.app.service.CommentManagerService;

@Controller
@Scope(value="session")
public class AppCommentManagerController
extends BaseControler {
    private static Logger logger = LoggerFactory.getLogger(AppCommentManagerController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private CommentManagerService commentManagerService;

    @RequestMapping(value={"/app/AppCommentManagerController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            modelMap.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/app/AppCommentManagerController/getCommonList.do"})
    public void getCommentList(AppCommentQueryBean queryBean, HttpServletResponse response) {
        try {
            String ret = this.commentManagerService.getCommentList(queryBean);
            Util.writeUtf8Text(response, ret);
        }
        catch (Exception e2) {
            logger.error("\u83b7\u53d6\u5e94\u7528\u8bc4\u8bba\u5217\u8868\u5931\u8d25" + e2.getMessage());
        }
    }

    @RequestMapping(value={"/app/AppCommentManagerController/getCommentDetail.do"})
    public String getDetailById(@RequestParam(value="arId") String arId, ModelMap modelMap) {
        JSONObject comment = this.commentManagerService.getCommentDetail(arId);
        modelMap.put((Object)"comment", (Object)comment);
        return "app/commentManager/default/detail";
    }

    @RequestMapping(value={"/app/AppCommentManagerController/getReplyList.do"})
    public void getReplyListByArId(AppCommentReplyQueryBean queryBean, HttpServletResponse response) {
        try {
            String ret = this.commentManagerService.getCommentReplyList(queryBean);
            Util.writeUtf8Text(response, ret);
        }
        catch (Exception e2) {
            logger.error(e2.getMessage());
        }
    }

    @RequestMapping(value={"/app/AppCommentManagerController/addReply.do"}, method={RequestMethod.POST})
    public void addComment(AppCommentReplyBean appCommentReplyBean, HttpServletRequest request, HttpServletResponse response) {
        String retMessage;
        try {
            appCommentReplyBean.setArrReplyerId(this.person.getId());
            PageBean pageBean = this.commentManagerService.addReply(appCommentReplyBean);
            retMessage = "0".equals(pageBean.getState()) ? pageBean.getData().toString() : "\u56de\u590d\u6210\u529f";
        }
        catch (Exception e2) {
            logger.error("\u56de\u590d\u5931\u8d25" + e2.getMessage());
            retMessage = "\u56de\u590d\u5931\u8d25";
        }
        Util.writeUtf8Text(response, retMessage);
    }

    @RequestMapping(value={"/app/AppCommentManagerController/removeComment.do"})
    public void removeComment(@RequestParam(value="arId") String arId, HttpServletRequest request, HttpServletResponse response) {
        String retMessage;
        try {
            PageBean pageBean = this.commentManagerService.deleteCommentById(arId, this.person.getId());
            retMessage = "0".equals(pageBean.getState()) ? pageBean.getData().toString() : "\u5220\u9664\u6210\u529f";
        }
        catch (Exception e2) {
            logger.error("\u5220\u9664\u5931\u8d25:" + e2.getMessage());
            retMessage = "\u5220\u9664\u5931\u8d25";
        }
        Util.writeUtf8Text(response, retMessage);
    }

    @RequestMapping(value={"/app/AppCommentManagerController/removeReply.do"})
    public void removeReplyByRid(@RequestParam(value="arrId") String arrId, HttpServletRequest request, HttpServletResponse response) {
        String retMessage;
        try {
            PageBean pageBean = this.commentManagerService.deleteReplyById(arrId, this.person.getId());
            retMessage = "0".equals(pageBean.getState()) ? pageBean.getData().toString() : "\u5220\u9664\u6210\u529f";
        }
        catch (Exception e2) {
            logger.error("\u5220\u9664\u5931\u8d25:" + e2.getMessage());
            retMessage = "\u5220\u9664\u5931\u8d25";
        }
        Util.writeUtf8Text(response, retMessage);
    }
}

