/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.ImageHepler;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.mdp.app.bean.AppTypeBean;
import pams.function.mdp.app.bean.PageBean;
import pams.function.mdp.app.service.AppTypeManagerService;

@Controller
@Scope(value="session")
public class AppTypeControler
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    AppTypeManagerService appTypeManagerService;
    private static final Logger log = LoggerFactory.getLogger(AppTypeControler.class);

    @RequestMapping(value={"/app/AppTypeControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        String fastdfsUrl = "";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        return sendUrl;
    }

    @RequestMapping(value={"/app/AppTypeControler/queryAppTypeList.do"})
    public void queryUseList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, AppTypeBean appTypeBean) {
        int operateResult = 1;
        this.setOperator(request);
        String resultJson = null;
        try {
            Page p = new Page(page.getPage(), page.getRows());
            resultJson = this.appTypeManagerService.queryList(appTypeBean, page);
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5e94\u7528\u5206\u7c7b\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, resultJson);
    }

    @RequestMapping(value={"/app/AppTypeControler/addTypeWeb.do"})
    public String addTypeWeb(String appId, ModelMap map, HttpServletRequest request, HttpServletResponse response, String appTypeId) {
        AppTypeBean appTypeBean = new AppTypeBean();
        appTypeBean.setAppTypeId(appTypeId);
        if (!Util.varCheckEmp(appTypeId)) {
            try {
                appTypeBean = this.appTypeManagerService.getAppType(appTypeBean);
            }
            catch (Exception e2) {
                log.error("\u6839\u636e\u697c\u5b87\u7f16\u53f7\u83b7\u53d6\u697c\u5b87\u4fe1\u606f\u5f02\u5e38", (Throwable)e2);
            }
        }
        map.put((Object)"appTypeBean", (Object)appTypeBean);
        map.put((Object)"person", (Object)this.person);
        return "app/appType/default/addType";
    }

    @RequestMapping(value={"/app/AppTypeControler/saveAddType.do"})
    public void saveAddType(ModelMap map, HttpServletRequest request, HttpServletResponse response, AppTypeBean appTypeBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            appTypeBean.setCreateUserId(this.person.getId());
            appTypeBean.setCreateUserName(this.person.getName());
            PageBean pageBean = this.appTypeManagerService.addAppType(appTypeBean, request);
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58\u5e94\u7528\u5206\u7c7b\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/app/AppTypeControler/updateAppType.do"})
    public void updateAppType(ModelMap map, HttpServletRequest request, HttpServletResponse response, AppTypeBean appTypeBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            appTypeBean.setCreateUserId(this.person.getId());
            appTypeBean.setCreateUserName(this.person.getName());
            PageBean pageBean = this.appTypeManagerService.updateAppType(appTypeBean, request);
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58\u5e94\u7528\u5206\u7c7b\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/app/AppTypeControler/deleteAddType.do"})
    public void deleteAddType(ModelMap map, HttpServletRequest request, HttpServletResponse response, AppTypeBean appTypeBean, String id) {
        ReturnResult rtnResult = new ReturnResult();
        System.out.println(appTypeBean.getBase64Logo());
        int operateResult = 0;
        try {
            appTypeBean.setAppTypeId(id);
            PageBean pageBean = this.appTypeManagerService.deleteAppType(appTypeBean);
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58\u5e94\u7528\u5206\u7c7b\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/app/AppTypeControler/toImpGra.do"})
    public String toImpGra(ModelMap model, HttpServletRequest request) {
        model.put((Object)"picUrl", (Object)"/download/api_pressed.png");
        return "app/appType/default/uploadimage";
    }

    @RequestMapping(value={"/app/AppTypeControler/toCutImg.do"})
    public String toCutImg(ModelMap model, HttpServletRequest request) {
        return "app/appType/default/cutimg";
    }

    @RequestMapping(value={"/app/AppTypeControler/saveSubGra2.do"})
    public void saveSubGra2(int imageWidth, int imageHeight, int cutTop, int cutLeft, int dropWidth, int dropHeight, String picture, ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)picture)) {
            model.put((Object)"msg", (Object)"\u8bfb\u53d6\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u60a8\u5148\u4e0a\u4f20\u56fe\u7247");
        } else {
            String classPath = this.systemConfigService.getValueByCode("logoPath");
            String path = request.getSession().getServletContext().getRealPath("/") + classPath;
            String picType = picture.substring(picture.lastIndexOf("."));
            String datetime = Util.getDate("yyyyMMdd", new Date());
            Random random = new Random();
            String newPictureName = datetime + String.valueOf(random.nextInt()).substring(1, 5) + picType;
            String oldPicture = request.getSession().getServletContext().getRealPath("/") + picture;
            Rectangle rec = new Rectangle(cutLeft, cutTop, dropWidth, dropHeight);
            File dir = new File(path + "/logo");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(path + "/logo/" + newPictureName);
            try {
                File oldFile = new File(oldPicture);
                AppTypeControler.saveSubImage(oldFile, file, imageWidth, imageHeight, rec);
                if (oldFile.exists()) {
                    oldFile.delete();
                }
                map.put("picUrl", "/" + classPath + "/logo/" + newPictureName);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            catch (RasterFormatException rfe) {
                // empty catch block
            }
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/app/AppTypeControler/impGra.do"})
    public String impGra(@RequestParam MultipartFile fuPhoto, ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        String filename = fuPhoto.getOriginalFilename();
        if (!StringUtils.isEmpty((CharSequence)filename)) {
            if (filename.length() > 100) {
                model.put((Object)"msg", (Object)"\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100\u4f4d\uff0c\u8bf7\u60a8\u91cd\u547d\u540d");
            } else if (".jpg".equals(filename.substring(filename.lastIndexOf("."))) || ".png".equals(filename.substring(filename.lastIndexOf("."))) || ".gif".equals(filename.substring(filename.lastIndexOf(".")))) {
                String datetime = Util.getDate("yyyyMMdd", new Date());
                Random random = new Random();
                String newFileName = datetime + String.valueOf(random.nextInt()).substring(1, 5) + filename.substring(filename.lastIndexOf("."));
                String realPath = request.getSession().getServletContext().getRealPath("/");
                String classPath = "/" + this.systemConfigService.getValueByCode("logoPath");
                String path = realPath + classPath + "/" + newFileName;
                File uploadFile = new File(path);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)fuPhoto.getInputStream(), (File)uploadFile);
                    BufferedImage bufferedImage = ImageIO.read(new File(path));
                    int width = bufferedImage.getWidth();
                    int height = bufferedImage.getHeight();
                    model.put((Object)"picUrl", (Object)(classPath + "/" + newFileName));
                    model.put((Object)"width", (Object)width);
                    model.put((Object)"height", (Object)height);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            } else {
                model.put((Object)"msg", (Object)"\u4e0a\u4f20\u56fe\u7247\u683c\u5f0f\u4e0d\u5339\u914d");
            }
        }
        return "app/appType/default/cutimg";
    }

    private static void saveSubImage(File srcImageFile, File descDir, int width, int height, Rectangle rect) throws IOException {
        ImageHepler.cut(srcImageFile, descDir, width, height, rect);
    }
}

