/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.service.impl;

import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.File;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.mdp.app.bean.AppTypeBean;
import pams.function.mdp.app.bean.PageBean;
import pams.function.mdp.app.dao.AppManagerDao;
import pams.function.mdp.app.service.AppTypeManagerService;
import pams.function.mdp.app.util.BASE64DecoderUtil;

@Service
public class AppTypeManagerServiceImpl
implements AppTypeManagerService {
    @Autowired
    private AppManagerDao appManagerDao;
    @Autowired
    SystemConfigService systemConfigService;

    @Override
    public String queryList(AppTypeBean appTypeBean, PageParam page) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appTypeServiceControl/queryAppTypelist.do?type=json";
        String param = "ifEnable=1&rows=" + page.getRows() + "&page=" + page.getPage();
        if (!Util.varCheckEmp(appTypeBean.getTypeName())) {
            param = param + "&queryKey=" + appTypeBean.getTypeName();
        }
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        result = result.replace("data", "rows");
        return result;
    }

    @Override
    public PageBean addAppType(AppTypeBean appTypeBean, HttpServletRequest request) throws Exception {
        String result = "";
        String oldPicture = request.getSession().getServletContext().getRealPath("/") + appTypeBean.getLogoPath();
        String imgBase64 = BASE64DecoderUtil.image2String(new File(oldPicture));
        String logoSuffix = appTypeBean.getLogoPath().split("\\.")[1];
        appTypeBean.setBase64Logo(URLEncoder.encode(imgBase64, "utf-8"));
        appTypeBean.setLogoSuffix(logoSuffix);
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appTypeServiceControl/saveAppType.do?type=json";
        String param = "typeName=" + appTypeBean.getTypeName() + "&typeSequence=" + appTypeBean.getTypeSequence() + "&typeDescription=" + appTypeBean.getTypeDescription() + "&createUserId=" + appTypeBean.getCreateUserId() + "&createUserName=" + appTypeBean.getCreateUserName() + "&Base64Logo=" + appTypeBean.getBase64Logo() + "&logoSuffix=" + appTypeBean.getLogoSuffix();
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = httpRequestUtil.post(url, param);
        PageBean pageBean = (PageBean)Util.readValue(result, PageBean.class, Object.class);
        return pageBean;
    }

    @Override
    public PageBean updateAppType(AppTypeBean appTypeBean, HttpServletRequest request) throws Exception {
        String result = "";
        if (appTypeBean.getLogoPath() == null || appTypeBean.getLogoPath().length() < 1 || appTypeBean.getLogoPath().indexOf("app_type_picture") > -1) {
            appTypeBean.setBase64Logo("");
        } else {
            String oldPicture = request.getSession().getServletContext().getRealPath("/") + appTypeBean.getLogoPath();
            String imgBase64 = BASE64DecoderUtil.image2String(new File(oldPicture));
            String logoSuffix = appTypeBean.getLogoPath().split("\\.")[1];
            appTypeBean.setBase64Logo(URLEncoder.encode(imgBase64, "utf-8"));
            appTypeBean.setLogoSuffix(logoSuffix);
        }
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appTypeServiceControl/updateAppType.do?type=json";
        String param = "typeName=" + appTypeBean.getTypeName() + "&typeSequence=" + appTypeBean.getTypeSequence() + "&typeDescription=" + appTypeBean.getTypeDescription() + "&createUserId=" + appTypeBean.getCreateUserId() + "&createUserName=" + appTypeBean.getCreateUserName() + "&Base64Logo=" + appTypeBean.getBase64Logo() + "&logoSuffix=" + appTypeBean.getLogoSuffix() + "&appTypeId=" + appTypeBean.getAppTypeId();
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = httpRequestUtil.post(url, param);
        PageBean pageBean = (PageBean)Util.readValue(result, PageBean.class, Object.class);
        return pageBean;
    }

    @Override
    public PageBean deleteAppType(AppTypeBean appTypeBean) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appTypeServiceControl/deleteAppType.do?type=json";
        String param = "appTypeId=" + appTypeBean.getAppTypeId() + "&ifEnable=" + appTypeBean.getTypeStatus();
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue(result, PageBean.class, Object.class);
        return pageBean;
    }

    @Override
    public AppTypeBean getAppType(AppTypeBean appTypeBean) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appTypeServiceControl/getAppTypeById.do?type=json";
        String param = "appTypeId=" + appTypeBean.getAppTypeId();
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue(result, PageBean.class, AppTypeBean.class);
        AppTypeBean getAppTypeBean = (AppTypeBean)pageBean.getData();
        getAppTypeBean.setLogoPath(getAppTypeBean.getTypeLogoFilePath());
        return getAppTypeBean;
    }
}

