/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.feedback.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.feedback.bean.ExceptionBean;
import pams.function.mdp.feedback.bean.QueryExceptionBean;
import pams.function.mdp.feedback.service.FeedbackService;

@Controller
@Scope(value="session")
public class FeedbackManagerControler
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private FeedbackService feedbackService;
    private static final Logger log = LoggerFactory.getLogger(FeedbackManagerControler.class);

    @RequestMapping(value={"/feedback/feedbackManagerController/toListException.do"})
    public String toListException(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/feedback/feedbackManagerController/listException.do"})
    public void listException(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, QueryExceptionBean queryExceptionBean) {
        int operateResult = 1;
        this.setOperator(request);
        String resultJson = "";
        try {
            resultJson = this.feedbackService.listException(queryExceptionBean);
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u4e3b\u52a8\u4e0a\u62a5\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, resultJson);
    }

    @RequestMapping(value={"/feedback/feedbackManagerController/toExceptionDetail.do"})
    public String toExceptionDetail(HttpServletRequest request, HttpServletResponse response, ModelMap map, String exceptionId) {
        ExceptionBean bean = new ExceptionBean();
        try {
            bean = this.feedbackService.getExceptionById(exceptionId);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u4e3b\u52a8\u4e0a\u62a5\u8be6\u60c5\u5f02\u5e38", (Throwable)e2);
        }
        map.put((Object)"exceptionBean", (Object)bean);
        return "mdp/feedbackManager/default/exceptionDetail";
    }
}

