/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.syms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.bean.MdpJsonRst;
import com.xdja.pams.syms.bean.MdpSysConfigType;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.syms.service.MdpSystemConfigService;

@Controller
@Scope(value="session")
public class MdpSysConfigController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(MdpSysConfigController.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private MdpSystemConfigService mdpSystemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;

    @RequestMapping(value={"syms/mdpsysconfigcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            SystemConfig sysCfgTheme = this.systemConfigService.getByCode("systemTheme");
            if (sysCfgTheme != null) {
                map.put((Object)"sysCfgTheme", (Object)sysCfgTheme);
            }
            String theme = this.operator.getPerson().getTheme();
            map.put((Object)"theme", (Object)theme);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"syms/mdpsysconfigcontroller/add.do"})
    public String add() {
        return "syms/mdpsysconfig/default/add";
    }

    @RequestMapping(value={"syms/mdpsysconfigcontroller/addType.do"})
    public String addType() {
        return "syms/mdpsysconfig/default/addType";
    }

    @RequestMapping(value={"syms/mdpsysconfigcontroller/query.do"})
    public void query(HttpServletResponse response, String name) {
        MdpJsonRst rst = this.mdpSystemConfigService.getByName(name);
        Util.writeUtf8JSON(response, Util.toJsonStr(rst.getData()));
    }

    @RequestMapping(value={"syms/mdpsysconfigcontroller/getType.do"})
    public void getType(HttpServletResponse response, String configType) {
        List<MdpSysConfigType> list = this.mdpSystemConfigService.getByType(null);
        ArrayList listmap = new ArrayList();
        for (MdpSysConfigType pSC : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", pSC.getId());
            map.put("name", pSC.getName());
            listmap.add(map);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(listmap));
    }

    @RequestMapping(value={"syms/mdpsysconfigcontroller/update.do"})
    public void update(SystemConfig systemConfig, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SystemConfig oldConfig = this.mdpSystemConfigService.getById(systemConfig.getId());
            oldConfig.setCode(systemConfig.getCode());
            oldConfig.setName(systemConfig.getName());
            oldConfig.setNote(systemConfig.getNote());
            oldConfig.setValue(systemConfig.getValue());
            this.mdpSystemConfigService.update(oldConfig);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/mdpsysconfigcontroller/updateValue.do"})
    public void updateValue(String id, String value, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.mdpSystemConfigService.update(id, value);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail") + e2.getMessage());
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/mdpsysconfigcontroller/save.do"})
    public void save(SystemConfig systemConfig, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        SystemConfig sc = this.mdpSystemConfigService.getByCode(systemConfig.getCode());
        if (sc != null) {
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "sysconfig.message.save.codeerr"));
            Util.writeUtf8JSON(response, Util.toJsonStr(map));
            return;
        }
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        try {
            this.mdpSystemConfigService.save(systemConfig);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            Util.writeUtf8JSON(response, Util.toJsonStr(map));
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }
}

