/*
 * Decompiled with CFR 0.152.
 */
package ueditor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import sun.misc.BASE64Decoder;

public class Uploader {
    private String url = "";
    private String fileName = "";
    private String state = "";
    private String type = "";
    private String originalName = "";
    private String size = "";
    private HttpServletRequest request = null;
    private String title = "";
    private String savePath = "upload";
    private String[] allowFiles = new String[]{".rar", ".doc", ".docx", ".zip", ".pdf", ".txt", ".swf", ".wmv", ".gif", ".png", ".jpg", ".jpeg", ".bmp"};
    private int maxSize = 10000;
    private HashMap<String, String> errorInfo = new HashMap();

    public Uploader(HttpServletRequest request) {
        this.request = request;
        HashMap<String, String> tmp = this.errorInfo;
        tmp.put("SUCCESS", "SUCCESS");
        tmp.put("NOFILE", "\u672a\u5305\u542b\u6587\u4ef6\u4e0a\u4f20\u57df");
        tmp.put("TYPE", "\u4e0d\u5141\u8bb8\u7684\u6587\u4ef6\u683c\u5f0f");
        tmp.put("SIZE", "\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236");
        tmp.put("ENTYPE", "\u8bf7\u6c42\u7c7b\u578bENTYPE\u9519\u8bef");
        tmp.put("REQUEST", "\u4e0a\u4f20\u8bf7\u6c42\u5f02\u5e38");
        tmp.put("IO", "IO\u5f02\u5e38");
        tmp.put("DIR", "\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        tmp.put("UNKNOWN", "\u672a\u77e5\u9519\u8bef");
    }

    public void upload() throws Exception {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)this.request);
        if (!isMultipart) {
            this.state = this.errorInfo.get("NOFILE");
            return;
        }
        DiskFileItemFactory dff = new DiskFileItemFactory();
        String savePath = this.getFolder(this.savePath);
        dff.setRepository(new File(savePath));
        try {
            ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)dff);
            sfu.setSizeMax((long)(this.maxSize * 1024));
            sfu.setHeaderEncoding("utf-8");
            FileItemIterator fii = sfu.getItemIterator(this.request);
            while (fii.hasNext()) {
                FileItemStream fis = fii.next();
                if (!fis.isFormField()) {
                    this.originalName = fis.getName().substring(fis.getName().lastIndexOf(System.getProperty("file.separator")) + 1);
                    if (!this.checkFileType(this.originalName)) {
                        this.state = this.errorInfo.get("TYPE");
                        continue;
                    }
                    this.fileName = this.getName(this.originalName);
                    this.type = this.getFileExt(this.fileName);
                    this.url = savePath + "/" + this.fileName;
                    BufferedInputStream in = new BufferedInputStream(fis.openStream());
                    FileOutputStream out = new FileOutputStream(new File(this.getPhysicalPath(this.url)));
                    BufferedOutputStream output = new BufferedOutputStream(out);
                    Streams.copy((InputStream)in, (OutputStream)output, (boolean)true);
                    this.state = this.errorInfo.get("SUCCESS");
                    break;
                }
                String fname = fis.getFieldName();
                if (!fname.equals("pictitle")) continue;
                BufferedInputStream in = new BufferedInputStream(fis.openStream());
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuffer result = new StringBuffer();
                while (reader.ready()) {
                    result.append((char)reader.read());
                }
                this.title = new String(result.toString().getBytes(), "utf-8");
                reader.close();
            }
        }
        catch (FileUploadBase.SizeLimitExceededException e2) {
            this.state = this.errorInfo.get("SIZE");
        }
        catch (FileUploadBase.InvalidContentTypeException e3) {
            this.state = this.errorInfo.get("ENTYPE");
        }
        catch (FileUploadException e4) {
            this.state = this.errorInfo.get("REQUEST");
        }
        catch (Exception e5) {
            this.state = this.errorInfo.get("UNKNOWN");
        }
    }

    public void uploadBase64(String fieldName) {
        String savePath = this.getFolder(this.savePath);
        String base64Data = this.request.getParameter(fieldName);
        this.fileName = this.getName("test.png");
        this.url = savePath + "/" + this.fileName;
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            File outFile = new File(this.getPhysicalPath(this.url));
            FileOutputStream ro = new FileOutputStream(outFile);
            byte[] b = decoder.decodeBuffer(base64Data);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            ((OutputStream)ro).write(b);
            ro.flush();
            ((OutputStream)ro).close();
            this.state = this.errorInfo.get("SUCCESS");
        }
        catch (Exception e2) {
            this.state = this.errorInfo.get("IO");
        }
    }

    private boolean checkFileType(String fileName) {
        for (String ext : Arrays.asList(this.allowFiles)) {
            if (!fileName.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private String getFileExt(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    private String getName(String fileName) {
        Random random = new Random();
        this.fileName = "" + random.nextInt(10000) + System.currentTimeMillis() + this.getFileExt(fileName);
        return this.fileName;
    }

    private String getFolder(String path) {
        SimpleDateFormat formater = new SimpleDateFormat("yyyyMMdd");
        File dir = new File(this.getPhysicalPath(path = path + "/" + formater.format(new Date())));
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception e2) {
                this.state = this.errorInfo.get("DIR");
                return "";
            }
        }
        return path;
    }

    private String getPhysicalPath(String path) {
        String servletPath = this.request.getServletPath();
        String realPath = this.request.getSession().getServletContext().getRealPath(servletPath);
        return new File(realPath).getParent() + "/" + path;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public void setAllowFiles(String[] allowFiles) {
        this.allowFiles = allowFiles;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public String getSize() {
        return this.size;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getState() {
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public String getOriginalName() {
        return this.originalName;
    }
}

