/*
 * Decompiled with CFR 0.152.
 */
package pams.function.guangzhou.port.service.impl;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import pams.function.guangzhou.common.exception.GuangzhouException;
import pams.function.guangzhou.port.bean.ApplyInfoBean;
import pams.function.guangzhou.port.bean.AuditStatusEnum;
import pams.function.guangzhou.port.entity.AttachmentInfo;
import pams.function.guangzhou.port.entity.PortInfo;
import pams.function.guangzhou.port.service.PortCheckService;

@Service
public class PortCheckServiceImpl
implements PortCheckService {
    private static Logger log = LoggerFactory.getLogger(PortCheckServiceImpl.class);

    @Override
    public void checkSaveApplyInfoBean(ApplyInfoBean applyInfoBean) throws GuangzhouException {
        if (applyInfoBean == null) {
            log.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)applyInfoBean.getPersonName())) {
            log.error("\u7533\u8bf7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u7533\u8bf7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)applyInfoBean.getDepName())) {
            log.error("\u7533\u8bf7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u7533\u8bf7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)applyInfoBean.getNetworkTypes())) {
            log.error("\u7f51\u7edc\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u7f51\u7edc\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.checkOverlength(applyInfoBean.getPersonId(), 32)) {
            log.error("personId\u957f\u5ea6\u8d85\u8fc732");
            throw new GuangzhouException("personId\u957f\u5ea6\u8d85\u8fc732");
        }
        if (this.checkOverlength(applyInfoBean.getPersonName(), 32)) {
            log.error("personName\u957f\u5ea6\u8d85\u8fc732");
            throw new GuangzhouException("\u7533\u8bf7\u4eba\u957f\u5ea6\u8d85\u8fc732");
        }
        if (this.checkOverlength(applyInfoBean.getDepId(), 32)) {
            log.error("depId\u957f\u5ea6\u8d85\u8fc732");
            throw new GuangzhouException("depId\u957f\u5ea6\u8d85\u8fc732");
        }
        if (this.checkOverlength(applyInfoBean.getDepName(), 64)) {
            log.error("\u7533\u8bf7\u5355\u4f4d\u957f\u5ea6\u8d85\u8fc764");
            throw new GuangzhouException("\u7533\u8bf7\u5355\u4f4d\u957f\u5ea6\u8d85\u8fc764");
        }
        if (this.checkOverlength(applyInfoBean.getCity(), 32)) {
            log.error("\u6240\u5c5e\u5730\u5e02\u957f\u5ea6\u8d85\u8fc732");
            throw new GuangzhouException("\u6240\u5c5e\u5730\u5e02\u957f\u5ea6\u8d85\u8fc732");
        }
        if (this.checkOverlength(applyInfoBean.getDuty(), 32)) {
            log.error("\u804c\u52a1\u957f\u5ea6\u8d85\u8fc732");
            throw new GuangzhouException("\u804c\u52a1\u957f\u5ea6\u8d85\u8fc732");
        }
        if (this.checkOverlength(applyInfoBean.getPhone(), 32)) {
            log.error("\u7533\u8bf7\u4eba\u7535\u8bdd\u957f\u5ea6\u8d85\u8fc732");
            throw new GuangzhouException("\u7533\u8bf7\u4eba\u7535\u8bdd\u957f\u5ea6\u8d85\u8fc732");
        }
        if (this.checkOverlength(applyInfoBean.getMail(), 64)) {
            log.error("\u516c\u5b89\u90ae\u7bb1\u957f\u5ea6\u8d85\u8fc764");
            throw new GuangzhouException("\u516c\u5b89\u90ae\u7bb1\u957f\u5ea6\u8d85\u8fc764");
        }
        if (this.checkOverlength(applyInfoBean.getFactory(), 64)) {
            log.error("\u627f\u5efa\u5382\u5546\u957f\u5ea6\u8d85\u8fc764");
            throw new GuangzhouException("\u627f\u5efa\u5382\u5546\u957f\u5ea6\u8d85\u8fc764");
        }
        if (this.checkOverlength(applyInfoBean.getFactoryLinkman(), 32)) {
            log.error("\u627f\u5efa\u5382\u5546\u8054\u7cfb\u4eba\u957f\u5ea6\u8d85\u8fc732");
            throw new GuangzhouException("\u627f\u5efa\u5382\u5546\u8054\u7cfb\u4eba\u957f\u5ea6\u8d85\u8fc732");
        }
        if (this.checkOverlength(applyInfoBean.getFactoryPhone(), 32)) {
            log.error("\u627f\u5efa\u5382\u5546\u8054\u7cfb\u7535\u8bdd\u957f\u5ea6\u8d85\u8fc732");
            throw new GuangzhouException("\u627f\u5efa\u5382\u5546\u8054\u7cfb\u7535\u8bdd\u957f\u5ea6\u8d85\u8fc732");
        }
        if (this.checkOverlength(applyInfoBean.getAppDescription(), 500)) {
            log.error("\u5e94\u7528\u63cf\u8ff0\u957f\u5ea6\u8d85\u8fc7500");
            throw new GuangzhouException("\u5e94\u7528\u63cf\u8ff0\u957f\u5ea6\u8d85\u8fc7500");
        }
        if (this.checkOverlength(applyInfoBean.getApplyReason(), 500)) {
            log.error("\u7533\u8bf7\u4e8b\u7531\u957f\u5ea6\u8d85\u8fc7500");
            throw new GuangzhouException("\u7533\u8bf7\u4e8b\u7531\u957f\u5ea6\u8d85\u8fc7500");
        }
        if (this.checkOverlength(applyInfoBean.getDepApprovalOpinion(), 500)) {
            log.error("\u7533\u8bf7\u5355\u4f4d\u5ba1\u6279\u957f\u5ea6\u8d85\u8fc7500");
            throw new GuangzhouException("\u7533\u8bf7\u5355\u4f4d\u5ba1\u6279\u957f\u5ea6\u8d85\u8fc7500");
        }
        if (this.checkOverlength(applyInfoBean.getKxcAuditOpinion(), 500)) {
            log.error("\u79d1\u5ba1\u5904\u5ba1\u6838\u610f\u89c1\u957f\u5ea6\u8d85\u8fc7500");
            throw new GuangzhouException("\u79d1\u5ba1\u5904\u5ba1\u6838\u610f\u89c1\u957f\u5ea6\u8d85\u8fc7500");
        }
        ArrayList<PortInfo> portInfoList = new ArrayList<PortInfo>();
        portInfoList.addAll(applyInfoBean.getIntranetPortList());
        portInfoList.addAll(applyInfoBean.getOuternetPortList());
        if (CollectionUtils.isEmpty(portInfoList)) {
            log.error("\u7533\u8bf7\u5f00\u653e\u7aef\u53e3\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u7533\u8bf7\u5f00\u653e\u7aef\u53e3\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PortInfo portInfo : portInfoList) {
            this.checkPortInfo(portInfo);
        }
        for (AttachmentInfo attachmentInfo : applyInfoBean.getAttachmentList()) {
            this.checkAttachmentInfo(attachmentInfo);
        }
    }

    @Override
    public void checkAuditApplyInfoBean(ApplyInfoBean applyInfoBean) throws GuangzhouException {
        if (applyInfoBean == null) {
            log.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)applyInfoBean.getApplyId())) {
            log.error("\u7533\u8bf7id\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u7533\u8bf7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (applyInfoBean.getAuditStatus() == null) {
            log.error("\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (applyInfoBean.getAuditStatus().intValue() == AuditStatusEnum.REFUSE.getStatus().intValue()) {
            return;
        }
        if (applyInfoBean.getAuditStatus().intValue() != AuditStatusEnum.PASS.getStatus().intValue()) {
            log.error("\u5ba1\u6279\u72b6\u6001\u4e0d\u5408\u6cd5");
            throw new GuangzhouException("\u5ba1\u6279\u72b6\u6001\u4e0d\u5408\u6cd5");
        }
        ArrayList<PortInfo> portInfoList = new ArrayList<PortInfo>();
        portInfoList.addAll(applyInfoBean.getIntranetPortList());
        portInfoList.addAll(applyInfoBean.getOuternetPortList());
        if (CollectionUtils.isEmpty(portInfoList)) {
            log.error("\u7533\u8bf7\u5f00\u653e\u7aef\u53e3\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u7533\u8bf7\u5f00\u653e\u7aef\u53e3\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PortInfo portInfo : portInfoList) {
            this.checkPortInfo(portInfo);
            if (StringUtils.isBlank((CharSequence)portInfo.getMapIp())) {
                log.error("\u6620\u5c04ip\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                throw new GuangzhouException("\u6620\u5c04ip\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)portInfo.getMapPort())) continue;
            log.error("\u6620\u5c04\u7aef\u53e3\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u6620\u5c04\u7aef\u53e3\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void checkPortInfo(PortInfo portInfo) throws GuangzhouException {
        if (portInfo == null) {
            log.error("\u7aef\u53e3\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u7aef\u53e3\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)portInfo.getIp())) {
            log.error("ip\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("ip\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)portInfo.getPort())) {
            log.error("\u7aef\u53e3\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u7aef\u53e3\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)portInfo.getProtocol())) {
            log.error("\u534f\u8bae\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u534f\u8bae\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.checkOverlength(portInfo.getIp(), 32) || this.checkOverlength(portInfo.getMapIp(), 32)) {
            log.error("ip\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
            throw new GuangzhouException("ip\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
        }
        if (this.checkOverlength(portInfo.getPort(), 32) || this.checkOverlength(portInfo.getPort(), 32)) {
            log.error("\u7aef\u53e3\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
            throw new GuangzhouException("\u7aef\u53e3\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
        }
        if (this.checkOverlength(portInfo.getDescription(), 500)) {
            log.error("\u7aef\u53e3\u63cf\u8ff0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500");
            throw new GuangzhouException("\u7aef\u53e3\u63cf\u8ff0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500");
        }
        if (this.checkOverlength(portInfo.getComments(), 500)) {
            log.error("\u7aef\u53e3\u5907\u6ce8\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500");
            throw new GuangzhouException("\u7aef\u53e3\u5907\u6ce8\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500");
        }
    }

    @Override
    public void checkAttachmentInfo(AttachmentInfo attachmentInfo) throws GuangzhouException {
        if (attachmentInfo == null) {
            log.error("\u9644\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u9644\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)attachmentInfo.getAttachmentId())) {
            log.error("\u9644\u4ef6\u7684attachmentId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u9644\u4ef6\u7684attachmentId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)attachmentInfo.getAttachmentName())) {
            log.error("\u9644\u4ef6\u7684attachmentName\u4e0d\u80fd\u4e3a\u7a7a");
            throw new GuangzhouException("\u9644\u4ef6\u7684attachmentName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.checkOverlength(attachmentInfo.getAttachmentId(), 256)) {
            log.error("attachmentId\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7256");
            throw new GuangzhouException("attachmentId\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7256");
        }
        if (this.checkOverlength(attachmentInfo.getAttachmentName(), 128)) {
            log.error("\u6587\u4ef6\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
            throw new GuangzhouException("\u6587\u4ef6\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7128");
        }
    }

    @Override
    public boolean checkOverlength(String value, int length) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return value.length() > length;
    }
}

