/*
 * Decompiled with CFR 0.152.
 */
package pams.function.guangzhou.common.control;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.guangzhou.common.bean.ErrorCode;
import pams.function.guangzhou.common.bean.PageResponseBean;
import pams.function.guangzhou.common.bean.ResponseBean;

public class CommonControl
extends BaseControler {
    private static Logger log = LoggerFactory.getLogger(CommonControl.class);

    public void logObject(Logger logger, String objectName, Object object, int type) {
        if (logger == null) {
            logger = log;
        }
        Throwable ex = new Throwable();
        String typeName = "";
        String method = "";
        StackTraceElement[] stackElements = ex.getStackTrace();
        if (type == 1) {
            typeName = "\u3010\u5165\u53c2\u3011";
            if (stackElements.length > 1) {
                method = stackElements[1].getMethodName() + "() :: ";
            }
        }
        if (type == 2) {
            typeName = "[\u51fa\u53c2]";
            if (stackElements.length > 2) {
                method = stackElements[2].getMethodName() + "() :: ";
            }
        }
        String jsonString = JSON.toJSONString((Object)object);
        logger.info(method + typeName + objectName + "\u7684\u503c\u4e3a \uff1a" + jsonString);
    }

    public <T> T getRequestBean(HttpServletRequest request, Logger logger, Class<T> tClass) throws IOException {
        String requestJson = null;
        requestJson = CharStreams.toString((Readable)new InputStreamReader((InputStream)request.getInputStream(), Charsets.UTF_8));
        logger.debug("\u83b7\u53d6\u5230\u7684\u8bf7\u6c42\u5185\u5bb9\u4e3a,requestJson:{}", (Object)requestJson);
        Object t = JSON.parseObject((String)requestJson, tClass);
        this.forgePerson(request);
        return (T)t;
    }

    public void forgePerson(HttpServletRequest request) {
        String forgePersonId = request.getParameter("forgePersonId");
        if (StringUtils.isNotBlank((CharSequence)forgePersonId)) {
            this.person = new Person();
            this.person.setId(forgePersonId);
            log.debug("\u4f2a\u9020\u4eba\u5458\uff0cpersonId:{}", (Object)forgePersonId);
        }
    }

    public <T> void writeResponseBeanWrong(HttpServletResponse response, Logger logger, T data) {
        ResponseBean<T> responseBean = new ResponseBean<T>();
        responseBean.setData(data);
        responseBean.setCode(ErrorCode.CODE_1);
        String responseJson = JSON.toJSONString(responseBean);
        logger.debug("\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef\u6570\u636e\u4e3a:{}", (Object)responseJson);
        response.setContentType("application/json");
        try {
            response.getOutputStream().write(responseJson.getBytes());
        }
        catch (IOException e) {
            log.error("\u5411\u5ba2\u6237\u7aef\u8fd4\u56de\u6570\u636e\u5931\u8d25{}", (Object)e.getMessage());
        }
    }

    public <T> void writeResponseBeanSuccess(HttpServletResponse response, Logger logger, T data) {
        ResponseBean<T> responseBean = new ResponseBean<T>();
        responseBean.setData(data);
        responseBean.setCode(ErrorCode.CODE_0);
        String responseJson = JSON.toJSONString(responseBean);
        logger.debug("\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef\u6570\u636e\u4e3a:{}", (Object)responseJson);
        response.setContentType("application/json");
        try {
            response.getOutputStream().write(responseJson.getBytes());
        }
        catch (IOException e) {
            log.error("\u5411\u5ba2\u6237\u7aef\u8fd4\u56de\u6570\u636e\u5931\u8d25{}", (Object)e.getMessage());
        }
    }

    public void writePageResponseBeanWrong(HttpServletResponse response, Logger logger) {
        PageResponseBean pageResponseBean = new PageResponseBean();
        pageResponseBean.setTotal(0);
        pageResponseBean.setRows(new ArrayList());
        this.writePageResponseBeanSuccess(response, logger, pageResponseBean);
    }

    public void writePageResponseBeanSuccess(HttpServletResponse response, Logger logger, PageResponseBean pageResponseBean) {
        String responseJson = JSON.toJSONString((Object)pageResponseBean);
        logger.debug("\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef\u6570\u636e\u4e3a:{}", (Object)responseJson);
        response.setContentType("application/json");
        try {
            response.getOutputStream().write(responseJson.getBytes());
        }
        catch (IOException e) {
            log.error("\u5411\u5ba2\u6237\u7aef\u8fd4\u56de\u6570\u636e\u5931\u8d25{}", (Object)e.getMessage());
        }
    }
}

