/*
 * Decompiled with CFR 0.152.
 */
package pams.function.guangzhou.common.exception;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import pams.function.guangzhou.common.bean.ErrorCode;
import pams.function.guangzhou.common.bean.ResponseBean;
import pams.function.guangzhou.common.exception.GuangzhouException;

public class ControllerExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={GuangzhouException.class})
    public void handleException(HttpServletResponse response, GuangzhouException exception) {
        ResponseBean<String> responseBean = new ResponseBean<String>();
        responseBean.setData(exception.getMessage());
        responseBean.setCode(ErrorCode.CODE_1);
        String responseJson = JSON.toJSONString(responseBean);
        response.setContentType("application/json");
        this.logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:{}", (Object)exception.getMessage());
        try {
            response.getOutputStream().write(responseJson.getBytes());
        }
        catch (IOException e) {
            this.logger.error("\u5411\u5ba2\u6237\u7aef\u8fd4\u56de\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    @ExceptionHandler(value={Exception.class})
    public void handleException(HttpServletResponse response, Exception exception) {
        ResponseBean<String> responseBean = new ResponseBean<String>();
        responseBean.setData(exception.getMessage());
        responseBean.setCode(ErrorCode.CODE_1);
        String responseJson = JSON.toJSONString(responseBean);
        response.setContentType("application/json");
        this.logger.error("\u7cfb\u7edf\u5185\u90e8\u9519\u8bef{}", (Object)exception.getMessage());
        try {
            response.getOutputStream().write(responseJson.getBytes());
        }
        catch (IOException e) {
            this.logger.error("\u672a\u77e5\u5f02\u5e38,\u5411\u5ba2\u6237\u7aef\u8fd4\u56de\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }
}

